
package kernpruefung;

/**
 * Das Interface Rueckgabe enthlt alle Methoden, die fr die Abfrage des
 * Ergebnisses der Kernprfung notwendig sind.
 * <p>
 * Fr die Implementierung des Interfaces in der einheitlichen Kernprfung
 * gilt folgendes Namensschema:<br>
 * <pre>
 *           RueckgabeXYZDummyImpl (Dummy-Impementierung fr XYZ-Verfahren)
 *           RueckgabeXYZImpl      (Implementierung fr XYZ = Verfahrensname)
 * 
 * Beispiel: RueckgabeZAVDummyImpl (Dummy-Implementierung fr das Zahlstellenmeldeverfahren)
 *           RueckgabeZAVImpl      (Implementierung fr das Zahlstellenmeldeverfahren) 
 * </pre><p>
 * @author  Uwe Loske (Knappschaft-Bahn-See)
 * @version 1.0
 */
public interface Rueckgabe
{
  /**
   * Gibt den Return-Code der Kernprfung zurck.
   * <p>
   * Es werden folgende Return-Code festgelegt:
   * <ul>
   * 	<li>0 = Kernprfung fehlerfrei String-Array getRueckgabeMeldung() ist leer
   * 	<li>1 = Kernprfung enthlt Hinweise
   * 	<li>2 = Kernprfung enthlt Fehler
   * 	<li>3 = Kernprfung enthlt Fehler und Hinweise
   * 	<li>4 = Kernprfung ist abgebrochen
   * </ul>
   * @return int
   */
  public int getReturnCode();

  /**
   * Gibt die Rckgabemeldungen als String-Array zurck.
   * <p>
   * Es sind maximal neun Eintrge im Array vorhanden.
   *
   * @return String[]
   */
  public String[] getRueckgabeMeldungen();

  /**
   * Gibt die String-Darstellung eines Rueckgabeobjektes zurck.
   * <p>
   * <table border="3" frame="box">
   *   <caption>Aufbau des String's:</caption>
   *   <tr bgcolor="#C0C0C0"><th colspan="2">Stelle</th><th rowspan="2">Inhalt</th></tr>
   *   <tr bgcolor="#C0C0C0"><th width="60">von</th><th width="60">bis</th>
   *   <tr><td align="right">  1</td><td align="right">  1</td><td>Return-Code</td></tr>
   *   <tr><td align="right">  2</td><td align="right">  2</td><td>Anzahl der DBFE-Bausteine (max. 9)</td></tr>
   *   <tr><td align="right">  3</td><td align="right"> 78</td><td>DBFE-Baustein 1 (falls vorhanden)</td></tr>
   *   <tr><td align="right"> 79</td><td align="right">154</td><td>DBFE-Baustein 2 (falls vorhanden)</td></tr>
   *   <tr><td align="right">155</td><td align="right">230</td><td>DBFE-Baustein 3 (falls vorhanden)</td></tr>
   *   <tr><td align="right">231</td><td align="right">306</td><td>DBFE-Baustein 4 (falls vorhanden)</td></tr>
   *   <tr><td align="right">307</td><td align="right">382</td><td>DBFE-Baustein 5 (falls vorhanden)</td></tr>
   *   <tr><td align="right">383</td><td align="right">458</td><td>DBFE-Baustein 6 (falls vorhanden)</td></tr>
   *   <tr><td align="right">459</td><td align="right">534</td><td>DBFE-Baustein 7 (falls vorhanden)</td></tr>
   *   <tr><td align="right">535</td><td align="right">610</td><td>DBFE-Baustein 8 (falls vorhanden)</td></tr>
   *   <tr><td align="right">611</td><td align="right">686</td><td>DBFE-Baustein 9 (falls vorhanden)</td></tr>
   * </table>
   *
   * @return String
   */
  public String toString();

}
