/*
 * Decompiled with CFR 0.152.
 */
package de.werum.uvkp.plausi.record.init;

import de.werum.uvkp.plausi.record.FieldCondition;
import de.werum.uvkp.plausi.record.FieldDefinition;
import de.werum.uvkp.plausi.record.RecordDefinition;
import de.werum.uvkp.plausi.record.RecordDefinitionFactory;
import de.werum.uvkp.plausi.record.SingleFieldDefinition;
import de.werum.uvkp.plausi.record.StructureFieldDefinition;
import de.werum.uvkp.plausi.record.init.DataRecord;
import de.werum.uvkp.plausi.runtime.DataFormatException;

public class AsciiRecordInitializer {
    protected String satzkennzeichen;
    protected String version;
    protected String satzart;

    public AsciiRecordInitializer(String string, String string2, String string3) {
        this.satzkennzeichen = string;
        this.version = string2;
        this.satzart = string3;
    }

    public DataRecord initializeDataRecord(String string, RecordDefinition recordDefinition) throws DataFormatException {
        DataRecord dataRecord = new DataRecord();
        int n = 0;
        String string2 = "";
        for (FieldDefinition fieldDefinition : recordDefinition.getFieldDefinitions()) {
            n = this.handleFieldDefinition(fieldDefinition, n, string2, string, dataRecord);
        }
        if (n != string.length()) {
            String string3 = "Datensatz zu lang. Der Datensatz enth\u00e4lt am Ende der Struktur (Position: " + n + ") noch weitere Zeichen. Datensatzl\u00e4nge: " + string.length() + ". Es ist ggf. das Strukturanzahlfeld zu korrigieren.";
            throw new DataFormatException(this.satzkennzeichen, this.version, this.satzart, 25, null, string3);
        }
        return dataRecord;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int handleFieldDefinition(FieldDefinition fieldDefinition, int n, String string, String string2, DataRecord dataRecord) throws DataFormatException {
        int n2 = n;
        if (fieldDefinition instanceof SingleFieldDefinition) {
            SingleFieldDefinition singleFieldDefinition = (SingleFieldDefinition)fieldDefinition;
            String string3 = string + singleFieldDefinition.getName();
            n2 = n + singleFieldDefinition.getLength();
            if (n2 <= string2.length()) {
                String string4 = string2.substring(n, n2);
                dataRecord.setValue(string3, (Object)string4);
                return n2;
            }
            String string5 = "Datensatz zu kurz. Das Strukturfeld: " + string3 + " von " + n + " bis " + n2 + " kann nicht ausgelesen werden. L\u00e4nge des Datensatzes ist " + string2.length() + ". " + "Es ist ggf. das Strukturanzahlfeld zu korrigieren.";
            throw new DataFormatException(this.satzkennzeichen, this.version, this.satzart, 20, string3, string5);
        }
        if (!(fieldDefinition instanceof StructureFieldDefinition)) return n2;
        StructureFieldDefinition structureFieldDefinition = (StructureFieldDefinition)fieldDefinition;
        String string6 = string + structureFieldDefinition.getName();
        n2 = n;
        if (!this.isStructurePresent(structureFieldDefinition, dataRecord)) return n2;
        int n3 = this.determinRecordCount(structureFieldDefinition, dataRecord);
        int n4 = 1;
        while (true) {
            if (n4 > n3) {
                String string7 = DataRecord.calculateStructureCounterFieldname(string, string6);
                dataRecord.setValue(string7, n3);
                return n2;
            }
            String string8 = DataRecord.calculateStructurePrefix(string, string6, n4);
            for (FieldDefinition fieldDefinition2 : structureFieldDefinition.getFieldDefinitions()) {
                n2 = this.handleFieldDefinition(fieldDefinition2, n2, string8, string2, dataRecord);
            }
            ++n4;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isStructurePresent(StructureFieldDefinition structureFieldDefinition, DataRecord dataRecord) throws DataFormatException {
        boolean bl = false;
        FieldCondition fieldCondition = structureFieldDefinition.getExistenceCondition();
        if (fieldCondition == null) return true;
        try {
            String string = (String)dataRecord.getValue(fieldCondition.getReferenceFieldName());
            if (string == null) return bl;
            if (fieldCondition.getCompareOperator() != FieldCondition.CompareOperator.EQUAL) return bl;
            return string.equals(fieldCondition.getCompareValue());
        }
        catch (Exception exception) {
            String string = "Fehler beim Auswerten der Strukturbedingung. Das Strukturfeld: " + fieldCondition.getReferenceFieldName() + " mit Vergleichsfunktion " + (Object)((Object)fieldCondition.getCompareOperator()) + " und Vergleichswert " + fieldCondition.getCompareValue() + "." + " Es ist ggf. das Referenzfeld zu korrigieren.";
            throw new DataFormatException(this.satzkennzeichen, this.version, this.satzart, 15, fieldCondition.getReferenceFieldName(), string);
        }
    }

    private int determinRecordCount(StructureFieldDefinition structureFieldDefinition, DataRecord dataRecord) throws DataFormatException {
        int n = 1;
        String string = structureFieldDefinition.getCounterFieldName();
        if (string != null && !"".equals(string)) {
            try {
                n = Integer.parseInt((String)dataRecord.getValue(string));
            }
            catch (NumberFormatException numberFormatException) {
                String string2 = "Strukturfehler: Anzahlfeld " + string + " muss numerisch sein.";
                throw new DataFormatException(this.satzkennzeichen, this.version, this.satzart, 5, string, string2);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                String string3 = "Strukturfehler: Anzahlfeld " + string + " kann nicht ermittelt werden.";
                throw new DataFormatException(this.satzkennzeichen, this.version, this.satzart, 10, string, string3);
            }
        }
        return n;
    }

    public static void main(String[] stringArray) {
        AsciiRecordInitializer asciiRecordInitializer = new AsciiRecordInitializer("DSLN", "0100", "DSLN_0100");
        String string = "DSLNUVELN13579024       95783331       0100012011030414151611111111223344556677889900N00Dies ist ein Reservefeld Dies ist ein Reservefeld Dies ist ein Reservefeld Dies ist ein Reservefeld.abc1234abcd1234diesIstDatensatzIdDiesistDatensaVORGANGSIDdiesIstVORGANGSIDdiesINDies ist ein Reservefeld Dies is1Dies ist ein Reservefeld Dies ist ein Reservefeld Dies ist ein Reservefeld Dies ist ein Reservefeld.44679001       7641894531024685231298455105201675395120       12345678       JUV01   0000430144679001       GT475611753001164822615998561044356123987456DBAPSSascha Sonnenmond             043267755331        0432699775531       sascha!:-)sonnenmond@s\u00fc\u00dfmilch.de                                      Beispiel-Tr\u00e4ger-Namen         Musterbestandteil             Testnamensbestandteil         8865320225Musterort                         Bauernbr\u00f6tchenstra\u00dfe             3475b    ";
        try {
            RecordDefinition recordDefinition = RecordDefinitionFactory.getRecordDefinition("DSLN_0100");
            DataRecord dataRecord = asciiRecordInitializer.initializeDataRecord(string, recordDefinition);
            dataRecord.debugMap();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getSatzkennzeichen() {
        return this.satzkennzeichen;
    }
}

