/*
 * Decompiled with CFR 0.152.
 */
package de.werum.uvkp.plausi;

import de.werum.uvkp.plausi.PlausiError;
import de.werum.uvkp.plausi.PlausiResult;
import java.util.ArrayList;
import kernpruefung.Rueckgabe;

public class RueckgabeUv
implements Rueckgabe {
    private final int returnCode;
    private final String[] rueckgabeMeldungen;
    private final PlausiResult plausiResult;

    public RueckgabeUv(PlausiResult plausiResult) {
        this.returnCode = plausiResult.getMaxErrorType();
        int n = plausiResult.getErrorCount();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            PlausiError plausiError = plausiResult.getError(i);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(plausiError.getErrorCode());
            stringBuffer.append(" ");
            stringBuffer.append(plausiError.getErrorText());
            arrayList.add(stringBuffer.toString());
        }
        this.rueckgabeMeldungen = arrayList.toArray(new String[0]);
        this.plausiResult = plausiResult;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public String[] getRueckgabeMeldungen() {
        return this.rueckgabeMeldungen;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.rueckgabeMeldungen.length < 9 ? this.rueckgabeMeldungen.length : 9;
        for (int i = 0; i < n; ++i) {
            String string = this.rueckgabeMeldungen[i];
            stringBuilder.append(String.format("%-72.72s", string));
        }
        return Integer.toString(this.returnCode) + Integer.toString(n) + stringBuilder.toString();
    }

    public PlausiResult getPlausiResult() {
        return this.plausiResult;
    }
}

