/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.ui.structureditor;

import de.statspez.pleditor.ui.structureditor.TreeTableModel;
import de.statspez.pleditor.ui.structureditor.TreeTableModelAdapter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class TreeTable
extends JTable
implements MouseListener {
    protected static Border focusBorder = UIManager.getBorder("Table.focusCellHighlightBorder");
    protected TreeTableCellRenderer tableRenderer = new TreeTableCellRenderer(this);
    private Color treeBackground = null;
    private static final long serialVersionUID = -5029984201048159947L;
    static /* synthetic */ Class class$0;

    public TreeTable(TreeTableModel treeTableModel) {
        this.setModel(treeTableModel);
        this.tableRenderer.getTree().setSelectionModel(new DefaultTreeSelectionModel(){
            {
                TreeTable.this.setSelectionModel(this.listSelectionModel);
            }
        });
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.statspez.pleditor.ui.structureditor.TreeTableModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setDefaultRenderer(clazz, this.tableRenderer);
        this.addMouseListener(this);
    }

    public void setModel(TreeTableModel treeTableModel) {
        this.tableRenderer.setModel(treeTableModel);
        this.setModel(new TreeTableModelAdapter(treeTableModel, this.tableRenderer.getTree()));
    }

    public void setTreeCellRenderer(TreeCellRenderer renderer) {
        this.tableRenderer.getTree().setCellRenderer(renderer);
    }

    public Color getTreeBackground() {
        Color result = this.treeBackground;
        if (result == null) {
            result = this.getBackground();
        }
        return result;
    }

    public void setTreeBackground(Color treeBackground) {
        this.treeBackground = treeBackground;
    }

    public JTree getTree() {
        if (this.tableRenderer == null) {
            this.tableRenderer = new TreeTableCellRenderer(this);
        }
        return this.tableRenderer.getTree();
    }

    public void expandAll() {
        if (this.getRowCount() == 0) {
            this.expandRoot();
        }
        int i = 0;
        while (i < this.getRowCount()) {
            this.tableRenderer.getTree().expandRow(i);
            ++i;
        }
    }

    public void expandRow(int row) {
        this.tableRenderer.getTree().expandRow(row);
    }

    public void collapseAll() {
        int i = this.getRowCount() - 1;
        while (i >= 0) {
            this.tableRenderer.getTree().collapseRow(i);
            --i;
        }
    }

    private void expandRoot() {
        TreeModel model = this.tableRenderer.getTree().getModel();
        if (model != null && model.getRoot() != null) {
            this.tableRenderer.getTree().expandPath(new TreePath(model.getRoot()));
        }
    }

    public int getEditingRow() {
        Class<?> clazz = this.getColumnClass(this.editingColumn);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("de.statspez.pleditor.ui.structureditor.TreeTableModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz == clazz2 ? -1 : this.editingRow;
    }

    private void translateMouseEventToTree(MouseEvent e) {
        int row;
        int column = this.columnAtPoint(e.getPoint());
        Class<?> clazz = this.getColumnClass(column);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("de.statspez.pleditor.ui.structureditor.TreeTableModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz2 && (row = this.rowAtPoint(e.getPoint())) >= 0) {
            int dx = 0;
            int dy = 0;
            Rectangle tableCellRect = this.getCellRect(row, column, false);
            Rectangle treeCellRect = this.getTree().getRowBounds(row);
            if (tableCellRect != null) {
                dx = -tableCellRect.x;
                if (treeCellRect != null) {
                    dy = treeCellRect.y - tableCellRect.y;
                }
            }
            this.getTree().dispatchEvent(new MouseEvent(this.getTree(), e.getID(), e.getWhen(), e.getModifiers(), e.getX() + dx, e.getY() + dy, e.getClickCount(), e.isPopupTrigger()));
        }
    }

    public void mouseClicked(MouseEvent e) {
        this.translateMouseEventToTree(e);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.translateMouseEventToTree(e);
    }

    public void mouseReleased(MouseEvent e) {
        this.translateMouseEventToTree(e);
    }

    private static class DefaultTreeTableModel
    extends DefaultTreeModel
    implements TreeTableModel {
        private static final long serialVersionUID = -9116870341824229114L;

        public DefaultTreeTableModel() {
            super(null);
        }

        public int getColumnCount() {
            return 1;
        }

        public String getColumnName(int column) {
            return "Tree";
        }

        public Object getValueAt(Object node, int column) {
            return node;
        }

        public Class getColumnClass(int column) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("de.statspez.pleditor.ui.structureditor.TreeTableModel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }

        public boolean isCellEditable(Object node, int column) {
            return false;
        }

        public void setValueAt(Object aValue, Object node, int column) {
        }
    }

    private class TreeTableCellRenderer
    extends JComponent
    implements TableCellRenderer,
    LayoutManager {
        protected int visibleRow;
        protected boolean hasFocus;
        private static final long serialVersionUID = 4420510748504659591L;
        private TreeTable treeTable;
        private JTree tree;
        private int rowHeight;

        public TreeTableCellRenderer(TreeTable treeTable2) {
            this.treeTable = treeTable2;
            this.tree = new JTree();
            this.tree.setShowsRootHandles(true);
            this.rowHeight = treeTable2.getRowHeight();
            this.setOpaque(false);
            this.setLayout(this);
            this.add(this.tree);
        }

        public TreeTableCellRenderer(TreeTable treeTable2, TreeModel model) {
            this(treeTable2);
            this.setModel(model);
        }

        public void setModel(TreeModel model) {
            this.tree.setModel(model);
        }

        public JTree getTree() {
            return this.tree;
        }

        public void setBounds(int x, int y, int w, int h) {
            super.setBounds(x, 0, w, this.treeTable.getModel().getRowCount() * this.tree.getRowHeight() + this.rowHeight);
        }

        public void paint(Graphics g) {
            int deltaY = this.visibleRow * this.tree.getRowHeight() + this.tree.getRowHeight() - this.treeTable.getRowHeight() / 2;
            g.translate(0, -deltaY);
            super.paint(g);
            g.translate(0, deltaY);
            if (this.hasFocus) {
                focusBorder.paintBorder(this.tree, g, 0, 0, this.getWidth(), this.rowHeight - this.treeTable.getIntercellSpacing().height);
            }
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean isFocused, int row, int column) {
            this.visibleRow = row;
            this.hasFocus = isFocused;
            this.rowHeight = table.getRowHeight(row);
            this.tree.setRowHeight(this.rowHeight * 2);
            if (isSelected) {
                this.tree.setBackground(table.getSelectionBackground());
            } else {
                this.tree.setBackground(table.getBackground());
            }
            return this;
        }

        public void removeLayoutComponent(Component comp) {
        }

        public void layoutContainer(Container parent) {
            this.tree.setBounds(0, this.rowHeight, parent.getWidth(), parent.getHeight());
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public Dimension minimumLayoutSize(Container parent) {
            return null;
        }

        public Dimension preferredLayoutSize(Container parent) {
            return null;
        }
    }
}

