/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.ui.editor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;

public class Ruler
extends JComponent
implements CaretListener,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private static final int SCALE_LINE_HEIGHT = 3;
    private static final int NUMBER_SCALE_LINE_HEIGHT = 8;
    private static final int FIVE_SCALE_LINE_HEIGHT = 5;
    private static final Font FONT = new Font("SansSerif", 0, 10);
    private static final FontMetrics FONT_METRICS;
    private static final int FONT_HEIGHT;
    private static final int HEIGHT;
    private int fontWidth;
    private JTextComponent textComp;
    private int caretColPos = -1;

    static {
        JLabel label = new JLabel();
        FONT_METRICS = label.getFontMetrics(FONT);
        FONT_HEIGHT = FONT_METRICS.getHeight();
        HEIGHT = 8 + FONT_HEIGHT;
    }

    public Ruler(JTextComponent textComp) {
        this.setBorder(null);
        this.textComp = textComp;
        this.textComp.addCaretListener(this);
        this.textComp.addPropertyChangeListener("document", this);
        FontMetrics fm = textComp.getFontMetrics(textComp.getFont());
        this.fontWidth = fm.charWidth('a');
    }

    protected void paintComponent(Graphics g) {
        Insets insets;
        Rectangle r = g.getClipBounds();
        Rectangle bounds = this.getBounds();
        int offset = 0;
        Border border = this.textComp.getBorder();
        if (border != null && (insets = border.getBorderInsets(this.textComp)) != null) {
            offset = insets.left;
        }
        int start = r.x / this.fontWidth * this.fontWidth;
        int end = ((r.x + bounds.width) / this.fontWidth + 1) * this.fontWidth;
        g.setColor(Color.BLACK);
        int drawCaretIdx = this.caretColPos * this.fontWidth;
        int i = start;
        while (i < end) {
            boolean fiveStep;
            int drawX = i + offset;
            boolean tenStep = i % (10 * this.fontWidth) == 0;
            boolean bl = fiveStep = i % (5 * this.fontWidth) == 0;
            g.drawLine(drawX, HEIGHT, drawX, tenStep ? HEIGHT - 8 : (fiveStep ? HEIGHT - 5 : HEIGHT - 3));
            if (tenStep && i != 0) {
                String number = String.valueOf(i / this.fontWidth);
                int numberWidth = FONT_METRICS.stringWidth(number);
                int numberPixelPos = drawX - numberWidth / 2 + 1;
                g.setFont(FONT);
                g.drawString(number, numberPixelPos, HEIGHT - 8 - 1);
            }
            if (i == drawCaretIdx) {
                g.drawLine(drawX, 5, drawX, 0);
                g.drawLine(drawX - (i == 0 ? 0 : 4), 0, drawX + 4, 0);
            }
            i += this.fontWidth;
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension((int)this.textComp.getPreferredSize().getWidth(), HEIGHT);
    }

    public Dimension getMinimumSize() {
        return new Dimension((int)this.textComp.getMinimumSize().getWidth(), HEIGHT);
    }

    public Dimension getMaximumSize() {
        return new Dimension((int)this.textComp.getMaximumSize().getWidth(), HEIGHT);
    }

    public void caretUpdate(CaretEvent e) {
        this.refreshCaretColPos();
        this.repaint();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt != null && "document".equals(evt.getPropertyName())) {
            this.refreshCaretColPos();
            this.repaint();
        }
    }

    private void refreshCaretColPos() {
        int column;
        int offset = this.textComp.getCaretPosition();
        Element root = this.textComp.getDocument().getDefaultRootElement();
        int lineIndex = root.getElementIndex(offset);
        Element lineElement = root.getElement(lineIndex);
        int lineStartOffset = lineElement.getStartOffset();
        this.caretColPos = column = offset - lineStartOffset;
    }
}

