/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.ui.editor;

import de.statspez.pleditor.ui.editor.marker.Marker;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;

public class LineNumberJTable
extends JTable
implements ListSelectionListener,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private static final int MIN_WIDTH = 10;
    private JTextComponent textComponent;
    private int fixedHeight;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public LineNumberJTable(JTextComponent textComponent) {
        this.textComponent = textComponent;
        this.textComponent.addPropertyChangeListener("document", this);
        this.setFocusable(false);
        this.getSelectionModel().addListSelectionListener(this);
        this.setModel(new LineNumberListModel());
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.statspez.pleditor.ui.editor.marker.Marker");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setDefaultRenderer(clazz, new MarkerRenderer());
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setDefaultRenderer(clazz2, new LineNumberRenderer());
        this.setSelectionMode(1);
        this.setFont(textComponent.getFont());
        this.fixedHeight = textComponent.getFontMetrics(textComponent.getFont()).getHeight();
        this.setRowHeight(this.fixedHeight);
        this.setShowGrid(false);
        this.getColumnModel().setColumnMargin(0);
        this.getColumnModel().getColumn(0).setPreferredWidth(18);
        this.getColumnModel().getColumn(0).setResizable(false);
        this.getColumnModel().getColumn(1).setMinWidth(10);
        this.getColumnModel().getColumn(1).setResizable(false);
        this.setAutoResizeMode(0);
        this.setRowMargin(0);
    }

    protected void printBorder(Graphics g) {
    }

    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        if (d.width < 10) {
            d = new Dimension(10, d.height);
        }
        return d;
    }

    public void valueChanged(ListSelectionEvent e) {
        int offset;
        if (e.getValueIsAdjusting()) {
            return;
        }
        int selectedLine = this.getSelectedRow();
        if (selectedLine == -1) {
            return;
        }
        Element root = this.textComponent.getDocument().getDefaultRootElement();
        int currentLine = root.getElementIndex(offset = this.textComponent.getCaretPosition());
        if (selectedLine != currentLine) {
            Element element = root.getElement(selectedLine);
            this.textComponent.setCaretPosition(element.getStartOffset());
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt != null && "document".equals(evt.getPropertyName())) {
            Element root = this.textComponent.getDocument().getDefaultRootElement();
            int offset = this.textComponent.getCaretPosition();
            int line = root.getElementIndex(offset);
            this.getSelectionModel().setSelectionInterval(line, line);
        }
    }

    public static void main(String[] args) {
        JTextArea textArea = new JTextArea();
        JScrollPane scrollPane = new JScrollPane(textArea);
        LineNumberJTable list = new LineNumberJTable(textArea);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)list, "Center");
        scrollPane.setRowHeaderView(panel);
        JFrame frame = new JFrame("Line Number JTable");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add((Component)scrollPane, "Center");
        frame.setSize(400, 300);
        frame.setVisible(true);
    }

    class LineNumberListModel
    extends DefaultTableModel
    implements CaretListener,
    DocumentListener {
        private static final long serialVersionUID = 1L;
        private int currentLines;

        public LineNumberListModel() {
            LineNumberJTable.this.textComponent.getDocument().addDocumentListener(this);
            LineNumberJTable.this.textComponent.addCaretListener(this);
        }

        public int getSize() {
            Element root = LineNumberJTable.this.textComponent.getDocument().getDefaultRootElement();
            return root.getElementCount();
        }

        public Object getElementAt(int index) {
            Element root = LineNumberJTable.this.textComponent.getDocument().getDefaultRootElement();
            int lines = root.getElementCount();
            if (index < lines) {
                return "" + (index + 1);
            }
            return "";
        }

        public void caretUpdate(CaretEvent e) {
            Element root = LineNumberJTable.this.textComponent.getDocument().getDefaultRootElement();
            int offset = LineNumberJTable.this.textComponent.getCaretPosition();
            int line = root.getElementIndex(offset);
            LineNumberJTable.this.getSelectionModel().setSelectionInterval(line, line);
            LineNumberJTable.this.repaint();
        }

        public void insertUpdate(DocumentEvent e) {
            Element root = LineNumberJTable.this.textComponent.getDocument().getDefaultRootElement();
            int lines = root.getElementCount();
            if (lines > this.currentLines) {
                this.fireTableRowsInserted(this.currentLines, lines);
                this.currentLines = lines;
            }
        }

        public void removeUpdate(DocumentEvent e) {
            Element root = LineNumberJTable.this.textComponent.getDocument().getDefaultRootElement();
            int lines = root.getElementCount();
            if (lines < this.currentLines) {
                this.fireTableRowsDeleted(this.currentLines, lines);
                this.currentLines = lines;
            }
        }

        public Class getColumnClass(int columnIndex) {
            Class<?> clazz;
            block5: {
                block6: {
                    if (columnIndex != 0) break block6;
                    clazz = class$0;
                    if (clazz != null) break block5;
                    try {
                        clazz = class$0 = Class.forName("de.statspez.pleditor.ui.editor.marker.Marker");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    break block5;
                }
                clazz = class$1;
                if (clazz == null) {
                    try {
                        class$1 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz = class$1;
                }
            }
            return clazz;
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int columnIndex) {
            return "" + columnIndex;
        }

        public int getRowCount() {
            return this.getSize();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            return columnIndex == 0 ? null : this.getElementAt(rowIndex);
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public void changedUpdate(DocumentEvent e) {
        }
    }

    class LineNumberRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        LineNumberRenderer() {
            this.setBorder(new EmptyBorder(0, 0, 0, 2));
            this.setHorizontalAlignment(4);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Element root = LineNumberJTable.this.textComponent.getDocument().getDefaultRootElement();
            this.setText(value == null ? "" : String.valueOf(value.toString()) + "123456789");
            int offset = LineNumberJTable.this.textComponent.getCaretPosition();
            int line = root.getElementIndex(offset);
            this.setBackground(row == line ? Color.yellow : Color.lightGray);
            return this;
        }
    }

    class MarkerRenderer
    extends DefaultTableCellRenderer {
        public MarkerRenderer() {
            this.setBorder(new EmptyBorder(0, 0, 0, 2));
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            int offset;
            int line;
            Element root = LineNumberJTable.this.textComponent.getDocument().getDefaultRootElement();
            if (value != null && value instanceof Marker) {
                Marker marker = (Marker)value;
                this.setIcon(marker.getIcon());
            }
            this.setBackground(row == (line = root.getElementIndex(offset = LineNumberJTable.this.textComponent.getCaretPosition())) ? Color.yellow : Color.lightGray);
            return this;
        }
    }
}

