/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.ui.editor;

import de.statspez.pleditor.generator.codeassist.ui.ScopeProvider;
import de.statspez.pleditor.ui.editor.PLCodeEditor;
import de.statspez.pleditor.ui.editor.PLCodeEditorConfig;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class FullScreanDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private PLCodeEditor editor = null;

    public FullScreanDialog(JFrame frame) {
        super(frame);
    }

    public FullScreanDialog(JDialog dialog) {
        super(dialog);
    }

    public FullScreanDialog() {
    }

    public void showFullScrean(PLCodeEditorConfig config, boolean editable, String text, ScopeProvider scopeProvider, String title) {
        this.editor = new PLCodeEditor(config, true);
        this.editor.addMinimizeActionListener(this);
        this.editor.setEditable(editable);
        this.editor.setText(text);
        this.editor.setScopeProvider(scopeProvider);
        this.add(this.editor);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                FullScreanDialog.this.setVisible(false);
            }
        });
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(this.getGraphicsConfiguration());
        int width = (int)(screenSize.getWidth() - (double)(screenInsets.left + screenInsets.right));
        int height = (int)(screenSize.getHeight() - (double)(screenInsets.top + screenInsets.bottom));
        this.setSize(width, height);
        this.setTitle(title != null ? title : "");
        this.setModal(true);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        this.editor.removeMinimizeActionListener(this);
        this.setVisible(false);
    }

    public void destroy() {
        this.editor.destroy();
    }

    public String getText() {
        return this.editor.getText();
    }

    public int getCaretPosition() {
        return this.editor.getTextComponent().getCaretPosition();
    }
}

