/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.xml;

import de.statspez.pleditor.generator.meta.generated.MetaDsbFeld;
import de.statspez.pleditor.generator.meta.generated.MetaDsbKommentar;
import de.statspez.pleditor.generator.meta.generated.MetaDsbObjekt;
import de.statspez.pleditor.generator.meta.generated.MetaEinzelfeld;
import de.statspez.pleditor.generator.meta.generated.MetaSatzart;
import de.statspez.pleditor.generator.parser.SSPTags;
import de.statspez.pleditor.generator.xml.AbstractXmlGenerator;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;

public class DsbXmlGenerator
extends AbstractXmlGenerator {
    public void printDsb(PrintStream out, MetaDsbObjekt dsb, String abstand) throws Exception {
        if (out == null) {
            throw new Exception("Der Ausgabe-Stream muss angegeben werden.");
        }
        if (abstand == null) {
            throw new Exception("Der Abstand muss angegeben werden.");
        }
        out.print(String.valueOf(abstand) + "<" + SSPTags.printTag("dataSetType"));
        this.printAttribut(out, "class", "");
        this.printAttribut(out, "name", dsb.getName());
        this.printAttribut(out, "id", dsb.getId());
        this.printAttribut(out, "state", this.state(dsb.getFreigabeStatus()));
        out.println(">");
        String ab1 = this.indentation(abstand, 1);
        this.printProperties(out, dsb, ab1);
        this.printObjectContext(out, dsb, ab1);
        this.printEncoding(out, "", ab1);
        this.printTechnicalProperties(out, dsb, ab1);
        this.printUseProperties(out, dsb, ab1);
        if (dsb.getAspBit() == 0) {
            this.printRecordType(out, ab1, dsb, null);
        } else {
            this.printRecordHeaderType(dsb, out, ab1);
            Iterator satzarten = dsb.getComps().getSatzList();
            while (satzarten != null && satzarten.hasNext()) {
                MetaSatzart satzart = (MetaSatzart)satzarten.next();
                this.printRecordType(out, ab1, null, satzart);
            }
        }
        this.printAnnotation(out, "", ab1);
        out.println(String.valueOf(abstand) + "</" + SSPTags.printTag("dataSetType") + ">");
    }

    private void printRecordType(PrintStream out, String indentation, MetaDsbObjekt dsb, MetaSatzart sa) {
        out.print(String.valueOf(indentation) + "<" + SSPTags.printTag("recordType"));
        String str = dsb != null ? dsb.getName() : sa.getName();
        String id = dsb != null ? dsb.getId() : sa.getId();
        this.printAttribut(out, "name", str);
        this.printAttribut(out, "id", id);
        this.printAttribut(out, "class", "");
        str = dsb != null ? "" + dsb.getSatzlaenge() : "" + sa.getSatzlaenge();
        this.printAttribut(out, "length", str);
        if (dsb != null) {
            this.printAttribut(out, "name-prefix", dsb.getPraefix());
        }
        if (sa != null) {
            this.printAttribut(out, "name-prefix", sa.getPraefix());
            this.printAttribut(out, "name-headprefix", sa.getKopfPraefix());
        }
        out.println(">");
        String ab2 = this.indentation(indentation, 1);
        MetaDsbFeld feld = null;
        Iterator it = null;
        it = dsb != null ? dsb.getComps().getCompList() : sa.getFelder();
        while (feld != null || it != null && it.hasNext()) {
            if (feld == null) {
                feld = (MetaDsbFeld)it.next();
            }
            feld = this.printDSBFeld(out, feld, ab2, it);
        }
        if (sa != null) {
            this.printRecordIdentifiers(out, ab2, sa.getEf(), sa.getKey());
        }
        this.printEncoding(out, "", ab2);
        this.printAnnotation(out, "", ab2);
        out.println(String.valueOf(indentation) + "</" + SSPTags.printTag("recordType") + ">");
    }

    private void printRecordIdentifiers(PrintStream out, String indentation, MetaEinzelfeld refEF, String refKey) {
        if (refEF == null || refKey == null) {
            return;
        }
        out.println(String.valueOf(indentation) + "<" + SSPTags.printTag("recordIdentifiers") + ">");
        String ab2 = this.indentation(indentation, 1);
        out.print(String.valueOf(ab2) + "<" + SSPTags.printTag("recordIdentifier"));
        this.printAttribut(out, "record-selector", refEF.getName());
        this.printAttribut(out, "record-selector-id", refEF.getId());
        out.print(">" + this.escapeStringXML(refKey));
        out.println("</" + SSPTags.printTag("recordIdentifier") + ">");
        out.println(String.valueOf(indentation) + "</" + SSPTags.printTag("recordIdentifiers") + ">");
    }

    private MetaDsbFeld printDSBFeld(PrintStream out, MetaDsbFeld feld, String indentation, Iterator it) {
        if (feld instanceof MetaDsbKommentar) {
            this.printDsbKommentar(out, (MetaDsbKommentar)feld, indentation);
            return null;
        }
        if (feld instanceof MetaEinzelfeld) {
            MetaEinzelfeld ef = (MetaEinzelfeld)feld;
            if (ef.getTyp().equals("Str") || ef.getTyp().equals("Wfgr") || ef.getTyp().equals("VKWG")) {
                return this.printGroupType(out, ef, indentation, it);
            }
            this.printFiefdType(out, ef, indentation);
            return null;
        }
        return null;
    }

    private void printTechnicalProperties(PrintStream out, MetaDsbObjekt dsb, String indentation) {
        out.println(String.valueOf(indentation) + "<" + SSPTags.printTag("technicalProperties") + ">");
        String ab = this.indentation(indentation, 1);
        this.printPCDATA(out, SSPTags.printTag("aspName"), dsb.getAspName(), ab);
        this.printPCDATA(out, SSPTags.printTag("index"), dsb.getIndex(), ab);
        this.printPCDATA(out, SSPTags.printTag("fileType"), "" + dsb.getSatztyp(), ab);
        this.printPCDATA(out, SSPTags.printTag("recordFormat"), "" + dsb.getSatzformat(), ab);
        this.printPCDATA(out, SSPTags.printTag("dataType"), "" + dsb.getDatentyp(), ab);
        this.printPCDATA(out, SSPTags.printTag("internalState"), "" + dsb.getDsbStatus(), ab);
        this.printPCDATA(out, SSPTags.printTag("fieldTyps"), "" + dsb.getDsbTypen(), ab);
        out.println(String.valueOf(indentation) + "</" + SSPTags.printTag("technicalProperties") + ">");
    }

    private void printUseProperties(PrintStream out, MetaDsbObjekt dsb, String abstand) {
        out.println(String.valueOf(abstand) + "<" + SSPTags.printTag("useProperties") + ">");
        String ab = this.indentation(abstand, 1);
        this.printPCDATA(out, SSPTags.printTag("author"), dsb.getBearbeiter(), ab);
        this.printPCDATA(out, SSPTags.printTag("currentName"), dsb.getDsName(), ab);
        this.printPCDATA(out, SSPTags.printTag("firstName"), dsb.getErsteller(), ab);
        this.printPCDATA(out, SSPTags.printTag("region"), dsb.getLand(), ab);
        this.printPCDATA(out, SSPTags.printTag("referencePeriod"), dsb.getZeitraum(), ab);
        this.printPCDATA(out, SSPTags.printTag("state"), dsb.getStand(), ab);
        this.printPCDATA(out, SSPTags.printTag("jobDescription"), dsb.getAufgabe(), ab);
        this.printPCDATA(out, SSPTags.printTag("sort"), dsb.getSort(), ab);
        out.println(String.valueOf(abstand) + "</" + SSPTags.printTag("useProperties") + ">");
    }

    private void printRecordHeaderType(MetaDsbObjekt dsb, PrintStream out, String indentation) {
        out.print(String.valueOf(indentation) + "<" + SSPTags.printTag("recordHeaderType"));
        this.printAttribut(out, "name", "");
        this.printAttribut(out, "class", "");
        this.printAttribut(out, "length", "" + dsb.getSatzlaenge());
        this.printAttribut(out, "name-prefix", dsb.getPraefix());
        out.println(">");
        Iterator it = dsb.getComps().getCompList();
        String ab2 = this.indentation(indentation, 1);
        MetaDsbFeld feld = null;
        while (feld != null || it != null && it.hasNext()) {
            if (feld == null) {
                feld = (MetaDsbFeld)it.next();
            }
            feld = this.printDSBFeld(out, feld, ab2, it);
        }
        this.printRecordSelectors(dsb, out, ab2);
        this.printAnnotation(out, "", ab2);
        out.println(String.valueOf(indentation) + "</" + SSPTags.printTag("recordHeaderType") + ">");
    }

    private void printRecordSelectors(MetaDsbObjekt dsb, PrintStream out, String indentation) {
        Iterator it = dsb.getComps().getSatzList();
        ArrayList<MetaEinzelfeld> efs = new ArrayList<MetaEinzelfeld>();
        while (it != null && it.hasNext()) {
            MetaSatzart satzart = (MetaSatzart)it.next();
            if (satzart == null || satzart.getEf() == null || efs.contains(satzart.getEf())) continue;
            efs.add(satzart.getEf());
        }
        if (efs.size() > 0) {
            out.println(String.valueOf(indentation) + "<" + SSPTags.printTag("recordSelectors") + ">");
            String ab2 = this.indentation(indentation, 1);
            int i = 0;
            while (i < efs.size()) {
                MetaEinzelfeld ef = (MetaEinzelfeld)efs.get(i);
                this.printRecordSelector(out, ef, ab2);
                ++i;
            }
            out.println(String.valueOf(indentation) + "</" + SSPTags.printTag("recordSelectors") + ">");
        }
    }

    private void printRecordSelector(PrintStream out, MetaEinzelfeld value, String indentation) {
        out.print(String.valueOf(indentation) + "<" + SSPTags.printTag("recordSelector"));
        this.printAttribut(out, "name", value.getName());
        this.printAttribut(out, "id", value.getId());
        out.println("/>");
    }

    private void printFiefdType(PrintStream out, MetaEinzelfeld ef, String indentation) {
        String name = ef.getName();
        String klasse = "single-field";
        String offset = "" + ef.getSatzVon();
        String length = "" + ef.getSatzAnz();
        String ab2 = this.indentation(indentation, 1);
        out.print(String.valueOf(indentation) + "<" + SSPTags.printTag("fieldType"));
        this.printAttribut(out, "name", name);
        this.printAttribut(out, "id", ef.getId());
        this.printAttribut(out, "class", klasse);
        out.println(">");
        this.printLocation(out, offset, length, ab2);
        this.printGenericDataType(out, ef, ab2);
        this.printApplicationDataType(out, ef, ab2);
        this.printEncoding(out, "", ab2);
        if (ef.getInhalt() != null && ef.getInhalt().length() > 0) {
            this.printAnnotation(out, ef.getInhalt(), ab2);
        }
        out.println(String.valueOf(indentation) + "</" + SSPTags.printTag("fieldType") + ">");
    }

    private MetaDsbFeld printGroupType(PrintStream out, MetaEinzelfeld ef, String abstand, Iterator it) {
        String str;
        int i;
        out.print(String.valueOf(abstand) + "<" + SSPTags.printTag("groupType"));
        this.printAttribut(out, "name", ef.getName());
        this.printAttribut(out, "id", ef.getId());
        this.printAttribut(out, "class", "");
        String typ = ef.getTyp().equals("VKWG") ? "infinite-group" : (ef.getTyp().equals("Wfgr") ? "group" : "structur");
        this.printAttribut(out, "type", typ);
        String wiederholungen = "1";
        if ((ef.getTyp().equals("Wfgr") || ef.getTyp().equals("VKWG")) && (i = (str = ef.getTypIntern()).indexOf("*")) > -1) {
            wiederholungen = str.substring(0, i).trim();
        }
        this.printAttribut(out, "occurrence", wiederholungen);
        out.println(">");
        String ab2 = this.indentation(abstand, 1);
        this.printLocation(out, "" + ef.getSatzVon(), "" + ef.getSatzAnz(), ab2);
        MetaDsbFeld feld = this.printGroup(out, ef.getStufenNr(), ab2, it);
        this.printEncoding(out, "", ab2);
        this.printAnnotation(out, ef.getInhalt(), ab2);
        out.println(String.valueOf(abstand) + "</" + SSPTags.printTag("groupType") + ">");
        return feld;
    }

    private MetaDsbFeld printGroup(PrintStream out, int grStufe, String indentation, Iterator it) {
        MetaDsbFeld feld = null;
        while (true) {
            if (feld == null && it.hasNext()) {
                feld = (MetaDsbFeld)it.next();
            }
            if (feld == null) break;
            if (feld instanceof MetaEinzelfeld) {
                if (((MetaEinzelfeld)feld).getStufenNr() <= grStufe) break;
                feld = this.printDSBFeld(out, feld, indentation, it);
                continue;
            }
            if (!(feld instanceof MetaDsbKommentar)) continue;
            this.printDsbKommentar(out, (MetaDsbKommentar)feld, indentation);
            feld = null;
        }
        return feld;
    }

    private void printDsbKommentar(PrintStream out, MetaDsbKommentar kommFeld, String abstand) {
        this.printPCDATA(out, "comment", kommFeld.getInhalt(), abstand);
    }

    private void printLocation(PrintStream out, String offset, String length, String indentation) {
        out.print(String.valueOf(indentation) + "<" + SSPTags.printTag("location"));
        if (offset != null) {
            this.printAttribut(out, "absolute-offset", offset);
        }
        this.printAttribut(out, "length", length);
        out.println("/>");
    }

    private void printGenericDataType(PrintStream out, MetaEinzelfeld ef, String indentation) {
        String praefixTypIntern;
        out.print(String.valueOf(indentation) + "<" + SSPTags.printTag("genericDataType"));
        String typIntern = ef.getTypIntern();
        String typ = ef.getTyp();
        String gesamtanzahl = "";
        String nachKomma = "";
        int i = typIntern.indexOf(" ");
        if (i > -1) {
            praefixTypIntern = typIntern.substring(0, i);
            gesamtanzahl = typIntern.substring(i + 1, i + 4);
            gesamtanzahl = gesamtanzahl.replace('0', ' ').trim();
            i = typIntern.indexOf("K");
            if (i > -1) {
                nachKomma = typIntern.substring(i + 2);
                nachKomma = nachKomma.replace('0', ' ').trim();
            }
        } else {
            praefixTypIntern = typIntern;
        }
        typ = SSPTags.getInstance().getBaseTypeFor(praefixTypIntern);
        this.printAttribut(out, "name", ef.getTyp());
        this.printAttribut(out, "class", "");
        this.printAttribut(out, "base-type", typ);
        this.printAttribut(out, "fraction-digits", nachKomma);
        this.printAttribut(out, "total-digits", gesamtanzahl);
        this.printAttribut(out, "white-space", "default");
        this.printAttribut(out, "zero-equivalent", "default");
        this.printAttribut(out, "zero-equivalent-character", "");
        out.println("/>");
    }

    private void printApplicationDataType(PrintStream out, MetaEinzelfeld ef, String indentation) {
        String typIntern = ef.getTypIntern();
        String type = null;
        String ges_stellen = null;
        String nach_stellen = null;
        int i = typIntern.indexOf(" ");
        if (i > -1) {
            type = typIntern.substring(0, i);
            ges_stellen = typIntern.substring(i + 1, i + 4);
            ges_stellen = ges_stellen.replace('0', ' ').trim();
            int j = typIntern.indexOf("K");
            if (j > -1) {
                nach_stellen = typIntern.substring(j + 2);
                nach_stellen = nach_stellen.replace('0', ' ').trim();
            }
        } else {
            type = typIntern;
        }
        out.print(String.valueOf(indentation) + "<" + SSPTags.printTag("applicationDataType"));
        this.printAttribut(out, "name", ef.getTypIntern());
        this.printAttribut(out, "class", "");
        this.printAttribut(out, "type", type);
        this.printAttribut(out, "fraction-digits", nach_stellen);
        this.printAttribut(out, "total-digits", ges_stellen);
        out.println("/>");
    }

    private void printEncoding(PrintStream out, String value, String indentation) {
        out.print(String.valueOf(indentation) + "<" + SSPTags.printTag("encoding") + " ");
        this.printAttribut(out, "class", "");
        this.printAttribut(out, "name", value);
        out.println("/>");
    }

    private void printAnnotation(PrintStream out, String value, String abstand) {
        if (value != null && value.trim().length() > 0) {
            out.print(String.valueOf(abstand) + "<" + SSPTags.printTag("annotation") + ">");
            out.print(this.escapeStringXML(value));
            out.println("</" + SSPTags.printTag("annotation") + ">");
        }
    }
}

