/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.test.runtime.export;

import de.statspez.pleditor.generator.codegen.support.Traverser;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import de.statspez.pleditor.generator.test.runtime.RuntimeInfos;
import de.statspez.pleditor.generator.test.runtime.RuntimeInfosUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class ComplexityCsvGenerator
extends Traverser {
    public static final int MEAN = 0;
    public static final int MINIMUM = 1;
    private HashMap metaProgramms;
    private MetaThemenbereich currentTB;
    private int type = 0;

    public void outputComplexityRuntimeInfos(OutputStream out, MetaCustomPlausibilisierung plausi, File[] csvFiles) throws FileNotFoundException, Exception {
        this.metaProgramms = new HashMap();
        plausi.accept(this);
        ArrayList<RuntimeInfos> runtimeInfosList = new ArrayList<RuntimeInfos>(csvFiles.length);
        RuntimeInfosUtil runtimeInfosIO = RuntimeInfosUtil.instance();
        int i = 0;
        while (i < csvFiles.length) {
            RuntimeInfos runtimeInfos = runtimeInfosIO.loadRuntimeInfos(new FileInputStream(csvFiles[i]));
            runtimeInfosList.add(runtimeInfos);
            ++i;
        }
        this.printHaeder(out);
        this.printCSV(out, runtimeInfosList);
    }

    public void setType(int type) {
        this.type = type;
    }

    public void visitThemenbereich(MetaThemenbereich anObject) {
        this.currentTB = anObject;
        super.visitThemenbereich(anObject);
        this.currentTB = null;
    }

    public void visitProgram(MetaProgram aProgram) {
        if (!this.metaProgramms.containsValue(aProgram)) {
            String key = aProgram.name();
            if (this.currentTB != null) {
                key = String.valueOf(this.currentTB.getName()) + "." + key;
            }
            this.metaProgramms.put(key, aProgram);
        }
    }

    private void printHaeder(OutputStream out) {
        StringBuffer buf = new StringBuffer(35);
        buf.append("Name").append(';');
        buf.append("Kompl.").append(';');
        buf.append("Lz").append(';');
        buf.append("Lz/Kompl.").append(';');
        buf.append(System.getProperty("line.separator"));
        try {
            out.write(buf.toString().getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void printCSV(OutputStream out, ArrayList runtimeInfosList) {
        Object[] keys = this.metaProgramms.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        int i = 0;
        while (i < keys.length) {
            Object key = keys[i];
            MetaProgram aProgram = (MetaProgram)this.metaProgramms.get(key);
            if (aProgram.getFunctionalComplexity() != null) {
                long summeLz = 0L;
                long minimumLz = 0L;
                StringBuffer buf = new StringBuffer();
                int j = 0;
                while (j < runtimeInfosList.size()) {
                    RuntimeInfos runtimeInfos = (RuntimeInfos)runtimeInfosList.get(j);
                    long lz = runtimeInfos.gibDurchschnittdauer((String)key);
                    summeLz += lz;
                    if (minimumLz == 0L || minimumLz > lz) {
                        minimumLz = lz;
                    }
                    buf.append(lz).append(';');
                    buf.append(runtimeInfos.gibAufrufAnzahl((String)key)).append(';');
                    buf.append(runtimeInfos.gibGesamtdauer((String)key)).append(';');
                    if (j < runtimeInfosList.size() - 1) {
                        buf.append(';');
                    }
                    ++j;
                }
                buf.append(System.getProperty("line.separator"));
                long durchschnittLz = 0L;
                if (runtimeInfosList.size() > 0) {
                    durchschnittLz = summeLz / (long)runtimeInfosList.size();
                }
                buf.insert(0, ';');
                buf.insert(0, ';');
                String str = this.type == 0 ? Integer.toString((int)((double)durchschnittLz / aProgram.getFunctionalComplexity())) : Integer.toString((int)((double)minimumLz / aProgram.getFunctionalComplexity()));
                buf.insert(0, str);
                buf.insert(0, ';');
                buf.insert(0, "" + durchschnittLz);
                String complexity = aProgram.getFunctionalComplexity().toString();
                complexity = complexity.replace('.', ',');
                buf.insert(0, ';');
                buf.insert(0, complexity);
                buf.insert(0, ';');
                buf.insert(0, (String)key);
                try {
                    out.write(buf.toString().getBytes());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            ++i;
        }
    }
}

