/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.test.inspector;

import de.statspez.pleditor.generator.meta.AbstractElementVisitor;
import de.statspez.pleditor.generator.meta.MetaAblaufStatement;
import de.statspez.pleditor.generator.meta.MetaArrayAccess;
import de.statspez.pleditor.generator.meta.MetaBoolean;
import de.statspez.pleditor.generator.meta.MetaBooleanOperator;
import de.statspez.pleditor.generator.meta.MetaBreakStatement;
import de.statspez.pleditor.generator.meta.MetaCheckFeldStatement;
import de.statspez.pleditor.generator.meta.MetaClassificationReference;
import de.statspez.pleditor.generator.meta.MetaConditionalStatement;
import de.statspez.pleditor.generator.meta.MetaContextOperator;
import de.statspez.pleditor.generator.meta.MetaDate;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.MetaErrorStatement;
import de.statspez.pleditor.generator.meta.MetaFieldAccess;
import de.statspez.pleditor.generator.meta.MetaForEachCheck;
import de.statspez.pleditor.generator.meta.MetaForEachLoop;
import de.statspez.pleditor.generator.meta.MetaForEachStatement;
import de.statspez.pleditor.generator.meta.MetaForNextLoop;
import de.statspez.pleditor.generator.meta.MetaFunctionCall;
import de.statspez.pleditor.generator.meta.MetaHierarchicalForEachLoop;
import de.statspez.pleditor.generator.meta.MetaHierarchicalOperator;
import de.statspez.pleditor.generator.meta.MetaIdentifier;
import de.statspez.pleditor.generator.meta.MetaIndexOfOperator;
import de.statspez.pleditor.generator.meta.MetaInterval;
import de.statspez.pleditor.generator.meta.MetaLiteralAccess;
import de.statspez.pleditor.generator.meta.MetaMapStatement;
import de.statspez.pleditor.generator.meta.MetaMaterialAccess;
import de.statspez.pleditor.generator.meta.MetaMathOperator;
import de.statspez.pleditor.generator.meta.MetaMultiAssignment;
import de.statspez.pleditor.generator.meta.MetaNoValue;
import de.statspez.pleditor.generator.meta.MetaNumber;
import de.statspez.pleditor.generator.meta.MetaPrintStatement;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.MetaPruefeStatement;
import de.statspez.pleditor.generator.meta.MetaRange;
import de.statspez.pleditor.generator.meta.MetaRangeSeries;
import de.statspez.pleditor.generator.meta.MetaReturnStatement;
import de.statspez.pleditor.generator.meta.MetaSelfAccess;
import de.statspez.pleditor.generator.meta.MetaSequence;
import de.statspez.pleditor.generator.meta.MetaSignOperator;
import de.statspez.pleditor.generator.meta.MetaSingleAssignment;
import de.statspez.pleditor.generator.meta.MetaSingleValueRange;
import de.statspez.pleditor.generator.meta.MetaSizeOfOperator;
import de.statspez.pleditor.generator.meta.MetaSizeTestingOperator;
import de.statspez.pleditor.generator.meta.MetaStatementSequence;
import de.statspez.pleditor.generator.meta.MetaString;
import de.statspez.pleditor.generator.meta.MetaStructureAccess;
import de.statspez.pleditor.generator.meta.MetaTestingOperator;
import de.statspez.pleditor.generator.meta.MetaTypeCheck;
import de.statspez.pleditor.generator.meta.MetaUnaryBoolOperator;
import de.statspez.pleditor.generator.meta.MetaVarDeclaration;
import de.statspez.pleditor.generator.meta.MetaWhileLoop;
import de.statspez.pleditor.generator.meta.MetaWithOperator;
import java.util.Iterator;
import java.util.Stack;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;

public class TreeBuilder
extends AbstractElementVisitor {
    private Stack nodeStack = new Stack();

    public DefaultMutableTreeNode build(MetaElement syntax) {
        syntax.accept(this);
        return (DefaultMutableTreeNode)this.nodeStack.pop();
    }

    public static TreeModel createTree(MetaElement syntax) {
        TreeBuilder builder = new TreeBuilder();
        return new DefaultTreeModel(builder.build(syntax));
    }

    public void visitNumber(MetaNumber aNumber) {
        DefaultMutableTreeNode numberNode = new DefaultMutableTreeNode(aNumber, false);
        this.nodeStack.push(numberNode);
    }

    public void visitString(MetaString aString) {
        DefaultMutableTreeNode stringNode = new DefaultMutableTreeNode(aString, false);
        this.nodeStack.push(stringNode);
    }

    public void visitIdentifier(MetaIdentifier anIdentifier) {
        DefaultMutableTreeNode idNode = new DefaultMutableTreeNode(anIdentifier, false);
        this.nodeStack.push(idNode);
    }

    public void visitDate(MetaDate aDate) {
        DefaultMutableTreeNode dateNode = new DefaultMutableTreeNode(aDate, true);
        aDate.specification().accept(this);
        dateNode.add((MutableTreeNode)this.nodeStack.pop());
        this.nodeStack.push(dateNode);
    }

    public void visitNoValue(MetaNoValue value) {
        DefaultMutableTreeNode novalueNode = new DefaultMutableTreeNode(value, false);
        this.nodeStack.push(novalueNode);
    }

    public void visitFieldAccess(MetaFieldAccess aFieldAccess) {
        aFieldAccess.accessedField().accept(this);
        DefaultMutableTreeNode idNode = (DefaultMutableTreeNode)this.nodeStack.pop();
        DefaultMutableTreeNode accessNode = new DefaultMutableTreeNode(aFieldAccess, true);
        accessNode.add(idNode);
        this.nodeStack.push(accessNode);
    }

    public void visitSelfAccess(MetaSelfAccess aSelfAccess) {
        DefaultMutableTreeNode aSelfAccesNode = new DefaultMutableTreeNode(aSelfAccess, false);
        this.nodeStack.push(aSelfAccesNode);
    }

    public void visitLiteralAccess(MetaLiteralAccess anAccess) {
        anAccess.accessedLiteral().accept(this);
        DefaultMutableTreeNode literalNode = (DefaultMutableTreeNode)this.nodeStack.pop();
        DefaultMutableTreeNode accessNode = new DefaultMutableTreeNode(anAccess, true);
        accessNode.add(literalNode);
        this.nodeStack.push(accessNode);
    }

    public void visitClassificationReference(MetaClassificationReference aReference) {
        DefaultMutableTreeNode refNode = new DefaultMutableTreeNode(aReference);
        Iterator it = aReference.levels();
        while (it.hasNext()) {
            ((MetaElement)it.next()).accept(this);
            refNode.add((MutableTreeNode)this.nodeStack.pop());
        }
        this.nodeStack.push(refNode);
    }

    public void visitRangeSeries(MetaRangeSeries aRangeSeries) {
        DefaultMutableTreeNode seriesNode = new DefaultMutableTreeNode(aRangeSeries, true);
        Iterator it = aRangeSeries.ranges();
        while (it.hasNext()) {
            ((MetaElement)it.next()).accept(this);
            seriesNode.add((MutableTreeNode)this.nodeStack.pop());
        }
        this.nodeStack.push(seriesNode);
    }

    public void visitSingleValueRange(MetaSingleValueRange aRange) {
        DefaultMutableTreeNode rangeNode = new DefaultMutableTreeNode(aRange, true);
        aRange.value().accept(this);
        rangeNode.add((MutableTreeNode)this.nodeStack.pop());
        this.nodeStack.push(rangeNode);
    }

    public void visitSequence(MetaSequence aSequence) {
        DefaultMutableTreeNode sequenceNode = new DefaultMutableTreeNode(aSequence, true);
        aSequence.first().accept(this);
        sequenceNode.add((MutableTreeNode)this.nodeStack.pop());
        aSequence.second().accept(this);
        sequenceNode.add((MutableTreeNode)this.nodeStack.pop());
        aSequence.last().accept(this);
        sequenceNode.add((MutableTreeNode)this.nodeStack.pop());
        this.nodeStack.push(sequenceNode);
    }

    public void visitInterval(MetaInterval anInterval) {
        DefaultMutableTreeNode intervalNode = new DefaultMutableTreeNode(anInterval, true);
        anInterval.first().accept(this);
        intervalNode.add((MutableTreeNode)this.nodeStack.pop());
        anInterval.last().accept(this);
        intervalNode.add((MutableTreeNode)this.nodeStack.pop());
        this.nodeStack.push(intervalNode);
    }

    public void visitArrayAccess(MetaArrayAccess anArrayAccess) {
        DefaultMutableTreeNode arrayNode = new DefaultMutableTreeNode(anArrayAccess, true);
        Iterator it = anArrayAccess.indices();
        while (it.hasNext()) {
            MetaElement index = (MetaElement)it.next();
            if (index != null) {
                index.accept(this);
                arrayNode.add((MutableTreeNode)this.nodeStack.pop());
                continue;
            }
            arrayNode.add(new DefaultMutableTreeNode("ALLE", true));
        }
        this.nodeStack.push(arrayNode);
    }

    public void visitStructureAccess(MetaStructureAccess aStructureAccess) {
        DefaultMutableTreeNode strucNode = new DefaultMutableTreeNode(aStructureAccess, true);
        aStructureAccess.structureAccess().accept(this);
        strucNode.add((MutableTreeNode)this.nodeStack.pop());
        aStructureAccess.selectedElement().accept(this);
        strucNode.add((MutableTreeNode)this.nodeStack.pop());
        this.nodeStack.push(strucNode);
    }

    public void visitMaterialAccess(MetaMaterialAccess anAccess) {
        DefaultMutableTreeNode stmntNode = new DefaultMutableTreeNode(anAccess, true);
        anAccess.material().accept(this);
        stmntNode.add((MutableTreeNode)this.nodeStack.pop());
        DefaultMutableTreeNode fieldsNode = new DefaultMutableTreeNode("Fields", true);
        Iterator it = anAccess.selectedFields();
        while (it.hasNext()) {
            ((MetaElement)it.next()).accept(this);
            fieldsNode.add((MutableTreeNode)this.nodeStack.pop());
        }
        stmntNode.add(fieldsNode);
        DefaultMutableTreeNode condNode = new DefaultMutableTreeNode("Conditions", true);
        it = anAccess.selectionConditions();
        while (it.hasNext()) {
            ((MetaElement)it.next()).accept(this);
            condNode.add((MutableTreeNode)this.nodeStack.pop());
        }
        stmntNode.add(condNode);
        this.nodeStack.push(stmntNode);
    }

    public void visitStatementSequence(MetaStatementSequence aSequence) {
        DefaultMutableTreeNode sequenceNode = new DefaultMutableTreeNode(aSequence, true);
        Iterator it = aSequence.statements();
        while (it.hasNext()) {
            ((MetaElement)it.next()).accept(this);
            sequenceNode.add((MutableTreeNode)this.nodeStack.pop());
        }
        this.nodeStack.push(sequenceNode);
    }

    public void visitSingleAssignment(MetaSingleAssignment anAssignment) {
        anAssignment.leftValue().accept(this);
        DefaultMutableTreeNode lValue = (DefaultMutableTreeNode)this.nodeStack.pop();
        anAssignment.rightValue().accept(this);
        DefaultMutableTreeNode rValue = (DefaultMutableTreeNode)this.nodeStack.pop();
        DefaultMutableTreeNode stmntNode = new DefaultMutableTreeNode(anAssignment, true);
        stmntNode.add(lValue);
        stmntNode.add(rValue);
        this.nodeStack.push(stmntNode);
    }

    public void visitMultiAssignment(MetaMultiAssignment anAssignment) {
        DefaultMutableTreeNode stmntNode = new DefaultMutableTreeNode(anAssignment, true);
        DefaultMutableTreeNode lvNode = new DefaultMutableTreeNode("left_values", true);
        stmntNode.add(lvNode);
        Iterator it = anAssignment.leftValues();
        while (it.hasNext()) {
            ((MetaElement)it.next()).accept(this);
            lvNode.add((MutableTreeNode)this.nodeStack.pop());
        }
        anAssignment.rightValue().accept(this);
        stmntNode.add((MutableTreeNode)this.nodeStack.pop());
        this.nodeStack.push(stmntNode);
    }

    public void visitConditionalStatement(MetaConditionalStatement aStatement) {
        DefaultMutableTreeNode stmntNode = new DefaultMutableTreeNode(aStatement, true);
        aStatement.condition().accept(this);
        stmntNode.add((MutableTreeNode)this.nodeStack.pop());
        aStatement.ifTrue().accept(this);
        stmntNode.add((MutableTreeNode)this.nodeStack.pop());
        aStatement.ifFalse().accept(this);
        stmntNode.add((MutableTreeNode)this.nodeStack.pop());
        this.nodeStack.push(stmntNode);
    }

    public void visitForNextLoop(MetaForNextLoop aStatement) {
        DefaultMutableTreeNode stmntNode = new DefaultMutableTreeNode(aStatement, true);
        aStatement.startAssignment().accept(this);
        stmntNode.add((MutableTreeNode)this.nodeStack.pop());
        aStatement.endCondition().accept(this);
        stmntNode.add((MutableTreeNode)this.nodeStack.pop());
        aStatement.stepExpression().accept(this);
        stmntNode.add((MutableTreeNode)this.nodeStack.pop());
        aStatement.loopBody().accept(this);
        stmntNode.add((MutableTreeNode)this.nodeStack.pop());
        this.nodeStack.push(stmntNode);
    }

    public void visitForEachLoop(MetaForEachLoop aStatement) {
        DefaultMutableTreeNode stmntNode = this.buildForEachNode(aStatement);
        aStatement.loopBody().accept(this);
        stmntNode.add((MutableTreeNode)this.nodeStack.pop());
        this.nodeStack.push(stmntNode);
    }

    public void visitForEachCheck(MetaForEachCheck aStatement) {
        DefaultMutableTreeNode stmntNode = this.buildForEachNode(aStatement);
        aStatement.condition().accept(this);
        stmntNode.add((MutableTreeNode)this.nodeStack.pop());
        this.nodeStack.push(stmntNode);
    }

    public void visitWhileLoop(MetaWhileLoop aStatement) {
        DefaultMutableTreeNode stmntNode = new DefaultMutableTreeNode(aStatement, true);
        aStatement.condition().accept(this);
        stmntNode.add((MutableTreeNode)this.nodeStack.pop());
        aStatement.loopBody().accept(this);
        stmntNode.add((MutableTreeNode)this.nodeStack.pop());
        this.nodeStack.push(stmntNode);
    }

    public void visitBreakStatement(MetaBreakStatement aStatement) {
        DefaultMutableTreeNode stmntNode = new DefaultMutableTreeNode(aStatement, true);
        this.nodeStack.push(stmntNode);
    }

    public void visitPrintStatement(MetaPrintStatement aStatement) {
        DefaultMutableTreeNode stmntNode = new DefaultMutableTreeNode(aStatement, true);
        Iterator it = aStatement.toPrint();
        while (it.hasNext()) {
            ((MetaElement)it.next()).accept(this);
            stmntNode.add((MutableTreeNode)this.nodeStack.pop());
        }
        if (aStatement.leftValue() != null) {
            aStatement.leftValue().accept(this);
            stmntNode.add((MutableTreeNode)this.nodeStack.pop());
        }
        this.nodeStack.push(stmntNode);
    }

    public void visitErrorStatement(MetaErrorStatement aStatement) {
        DefaultMutableTreeNode stmntNode = new DefaultMutableTreeNode(aStatement, false);
        this.nodeStack.push(stmntNode);
    }

    public void visitPruefeStatement(MetaPruefeStatement aStatement) {
        DefaultMutableTreeNode stmntNode = new DefaultMutableTreeNode(aStatement, true);
        aStatement.function().accept(this);
        stmntNode.add((MutableTreeNode)this.nodeStack.pop());
        this.nodeStack.push(stmntNode);
    }

    public void visitAblaufStatement(MetaAblaufStatement aStatement) {
        DefaultMutableTreeNode stmntNode = new DefaultMutableTreeNode(aStatement, true);
        aStatement.function().accept(this);
        stmntNode.add((MutableTreeNode)this.nodeStack.pop());
        Iterator it = aStatement.parameters();
        while (it.hasNext()) {
            ((MetaElement)it.next()).accept(this);
            stmntNode.add((MutableTreeNode)this.nodeStack.pop());
        }
        this.nodeStack.push(stmntNode);
    }

    public void visitCheckFeldStatement(MetaCheckFeldStatement aStatement) {
        DefaultMutableTreeNode stmntNode = new DefaultMutableTreeNode(aStatement, true);
        aStatement.field().accept(this);
        stmntNode.add((MutableTreeNode)this.nodeStack.pop());
        this.nodeStack.push(stmntNode);
    }

    public void visitReturnStatement(MetaReturnStatement aStatement) {
        DefaultMutableTreeNode stmntNode = new DefaultMutableTreeNode(aStatement, true);
        aStatement.returnValue().accept(this);
        stmntNode.add((MutableTreeNode)this.nodeStack.pop());
        this.nodeStack.push(stmntNode);
    }

    public void visitFunctionCall(MetaFunctionCall aStatement) {
        DefaultMutableTreeNode stmntNode = new DefaultMutableTreeNode(aStatement, true);
        aStatement.function().accept(this);
        stmntNode.add((MutableTreeNode)this.nodeStack.pop());
        Iterator it = aStatement.parameters();
        while (it.hasNext()) {
            ((MetaElement)it.next()).accept(this);
            stmntNode.add((MutableTreeNode)this.nodeStack.pop());
        }
        this.nodeStack.push(stmntNode);
    }

    public void visitProgram(MetaProgram aProgram) {
        DefaultMutableTreeNode program = new DefaultMutableTreeNode(aProgram, true);
        aProgram.statements().accept(this);
        program.add((DefaultMutableTreeNode)this.nodeStack.pop());
        this.nodeStack.push(program);
    }

    public void visitVarDeclaration(MetaVarDeclaration aDeclaration) {
        DefaultMutableTreeNode declNode = new DefaultMutableTreeNode(aDeclaration, true);
        Iterator ids = aDeclaration.identifiers();
        while (ids.hasNext()) {
            ((MetaElement)ids.next()).accept(this);
            declNode.add((DefaultMutableTreeNode)this.nodeStack.pop());
        }
        this.nodeStack.push(declNode);
    }

    public void visitMathOperator(MetaMathOperator anOperator) {
        DefaultMutableTreeNode opNode = new DefaultMutableTreeNode(anOperator, true);
        anOperator.firstOperand().accept(this);
        opNode.add((MutableTreeNode)this.nodeStack.pop());
        anOperator.secondOperand().accept(this);
        opNode.add((MutableTreeNode)this.nodeStack.pop());
        this.nodeStack.push(opNode);
    }

    public void visitSignOperator(MetaSignOperator anOperator) {
        DefaultMutableTreeNode opNode = new DefaultMutableTreeNode(anOperator, true);
        anOperator.operand().accept(this);
        opNode.add((MutableTreeNode)this.nodeStack.pop());
        this.nodeStack.push(opNode);
    }

    public void visitUnaryBoolOperator(MetaUnaryBoolOperator anOperator) {
        DefaultMutableTreeNode opNode = new DefaultMutableTreeNode(anOperator, true);
        anOperator.operand().accept(this);
        opNode.add((MutableTreeNode)this.nodeStack.pop());
        this.nodeStack.push(opNode);
    }

    public void visitBoolean(MetaBoolean aBoolean) {
        DefaultMutableTreeNode boolNode = new DefaultMutableTreeNode(aBoolean, false);
        this.nodeStack.push(boolNode);
    }

    public void visitBooleanOperator(MetaBooleanOperator anOperator) {
        DefaultMutableTreeNode opNode = new DefaultMutableTreeNode(anOperator, true);
        anOperator.firstOperand().accept(this);
        opNode.add((MutableTreeNode)this.nodeStack.pop());
        anOperator.secondOperand().accept(this);
        opNode.add((MutableTreeNode)this.nodeStack.pop());
        this.nodeStack.push(opNode);
    }

    public void visitTestingOperator(MetaTestingOperator anOperator) {
        DefaultMutableTreeNode opNode = new DefaultMutableTreeNode(anOperator, true);
        anOperator.firstOperand().accept(this);
        opNode.add((MutableTreeNode)this.nodeStack.pop());
        anOperator.secondOperand().accept(this);
        opNode.add((MutableTreeNode)this.nodeStack.pop());
        this.nodeStack.push(opNode);
    }

    public void visitSizeOfOperator(MetaSizeOfOperator anOperator) {
        DefaultMutableTreeNode opNode = new DefaultMutableTreeNode(anOperator, true);
        anOperator.operand().accept(this);
        opNode.add((MutableTreeNode)this.nodeStack.pop());
        this.nodeStack.push(opNode);
    }

    public void visitIndexOfOperator(MetaIndexOfOperator anOperator) {
        DefaultMutableTreeNode opNode = new DefaultMutableTreeNode(anOperator, true);
        anOperator.operand().accept(this);
        opNode.add((MutableTreeNode)this.nodeStack.pop());
        this.nodeStack.push(opNode);
    }

    public void visitMapStatement(MetaMapStatement aStatement) {
        DefaultMutableTreeNode stmntNode = new DefaultMutableTreeNode(aStatement, false);
        this.nodeStack.push(stmntNode);
    }

    public void visitTypeCheck(MetaTypeCheck typeCheck) {
        DefaultMutableTreeNode tcNode = new DefaultMutableTreeNode(typeCheck, true);
        typeCheck.value().accept(this);
        tcNode.add((MutableTreeNode)this.nodeStack.pop());
        if (typeCheck.maske() != null) {
            typeCheck.maske().accept(this);
            tcNode.add((MutableTreeNode)this.nodeStack.pop());
        }
        tcNode.add(new DefaultMutableTreeNode(new Integer(typeCheck.type()), false));
        this.nodeStack.push(tcNode);
    }

    public void visitWithOperator(MetaWithOperator anOperator) {
        DefaultMutableTreeNode opNode = new DefaultMutableTreeNode(anOperator, true);
        anOperator.operand().accept(this);
        opNode.add((MutableTreeNode)this.nodeStack.pop());
        this.nodeStack.push(opNode);
    }

    public void visitSizeTestingOperator(MetaSizeTestingOperator anOperator) {
        DefaultMutableTreeNode opNode = new DefaultMutableTreeNode(anOperator, true);
        anOperator.firstOperand().accept(this);
        opNode.add((MutableTreeNode)this.nodeStack.pop());
        anOperator.secondOperand().accept(this);
        opNode.add((MutableTreeNode)this.nodeStack.pop());
        this.nodeStack.push(opNode);
    }

    public void visitHierarchicalOperator(MetaHierarchicalOperator anOperator) {
        DefaultMutableTreeNode opNode = new DefaultMutableTreeNode(anOperator, true);
        anOperator.operand().accept(this);
        opNode.add((MutableTreeNode)this.nodeStack.pop());
        this.nodeStack.push(opNode);
    }

    public void visitContextOperator(MetaContextOperator anOperator) {
        DefaultMutableTreeNode opNode = new DefaultMutableTreeNode(anOperator, true);
        anOperator.operand().accept(this);
        opNode.add((MutableTreeNode)this.nodeStack.pop());
        this.nodeStack.push(opNode);
    }

    public void visitHierarchicalForEachLoop(MetaHierarchicalForEachLoop aStatement) {
        DefaultMutableTreeNode stmntNode = new DefaultMutableTreeNode(aStatement, true);
        aStatement.value().accept(this);
        stmntNode.add((MutableTreeNode)this.nodeStack.pop());
        aStatement.loopBody().accept(this);
        stmntNode.add((MutableTreeNode)this.nodeStack.pop());
        this.nodeStack.push(stmntNode);
    }

    private DefaultMutableTreeNode buildForEachNode(MetaForEachStatement aStatement) {
        DefaultMutableTreeNode stmntNode = new DefaultMutableTreeNode(aStatement, true);
        DefaultMutableTreeNode varNode = new DefaultMutableTreeNode("variables", true);
        stmntNode.add(varNode);
        Iterator it = aStatement.variables();
        while (it.hasNext()) {
            ((MetaElement)it.next()).accept(this);
            stmntNode.add((MutableTreeNode)this.nodeStack.pop());
        }
        aStatement.value().accept(this);
        stmntNode.add((MutableTreeNode)this.nodeStack.pop());
        if (aStatement.restrictions().size() > 0) {
            DefaultMutableTreeNode restrictions = new DefaultMutableTreeNode("restrictions", true);
            stmntNode.add(restrictions);
            it = aStatement.restrictions().iterator();
            while (it.hasNext()) {
                MetaRange range = (MetaRange)it.next();
                if (range != null) {
                    range.accept(this);
                    restrictions.add((MutableTreeNode)this.nodeStack.pop());
                    continue;
                }
                restrictions.add(new DefaultMutableTreeNode("all", false));
            }
        }
        return stmntNode;
    }
}

