/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.test;

import de.statspez.pleditor.generator.codegen.doku.PruefungStat;
import de.statspez.pleditor.generator.codegen.mapping.MappingProgramCodeGenerator;
import de.statspez.pleditor.generator.codegen.support.DSBStructureBuilder;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.generated.MetaPlausibilisierung;
import de.statspez.pleditor.generator.parser.IntermediateLanguageParser;
import java.io.FileReader;
import junit.framework.TestCase;

public class MappingGeneratorTest
extends TestCase {
    public static final String TEST_FILE = "E:/temp/Plausi_Warenmengen_test.xml";
    private MetaPlausibilisierung plausi = null;

    public static void main(String[] args) {
        System.out.println(new Double("1234d"));
        System.out.println(new Double("1234a"));
    }

    public void test_01_plausi() {
        MappingGeneratorTest.assertTrue((boolean)(this.plausi instanceof MetaCustomPlausibilisierung));
        DSBStructureBuilder dsbStructureBuilder = new DSBStructureBuilder();
        this.plausi.accept(dsbStructureBuilder);
        MappingProgramCodeGenerator mpaGen = new MappingProgramCodeGenerator();
        String code = mpaGen.createMappingProgram(this.plausi, 100);
        System.out.println("------------------------------------------------------");
        System.out.println(" Mapping RAW -> TB ");
        System.out.println("------------------------------------------------------");
        System.out.println(code);
        System.out.println("------------------------------------------------------");
        String code2 = mpaGen.createMappingProgram(this.plausi, 101);
        System.out.println("------------------------------------------------------");
        System.out.println(" Mapping TB -> RAW ");
        System.out.println("------------------------------------------------------");
        System.out.println(code2);
        System.out.println("------------------------------------------------------");
        String code3 = mpaGen.createMappingProgram(this.plausi, 102);
        System.out.println("------------------------------------------------------");
        System.out.println(" Mapping DSB -> TB ");
        System.out.println("------------------------------------------------------");
        System.out.println(code3);
        System.out.println("------------------------------------------------------");
        String code4 = mpaGen.createMappingProgram(this.plausi, 103);
        System.out.println("------------------------------------------------------");
        System.out.println(" Mapping TB -> DSB ");
        System.out.println("------------------------------------------------------");
        System.out.println(code4);
        System.out.println("------------------------------------------------------");
        MappingGeneratorTest.assertSame((Object)((MetaCustomPlausibilisierung)this.plausi).rootThemenbereich(), (Object)this.plausi.getFromThemenbereiche(0));
    }

    public void test_02_plausi() {
        PruefungStat pruefungStat = new PruefungStat();
        String bedingung = "WENN\nZK_31_Abschnitt_V.C0055 = 1\n UND\n(\n\"auch Abschnitt W ist nicht auszuf\u00fcllen, wenn das Urteil nicht rechtskr\u00e4ftig ist (vgl. Anordnung S. 23)\"\nZK_31_Abschnitt_W.C0056 /= LEER\n ODER\nZK_31_Abschnitt_X.C0057 /= LEER\n ODER\nZK_31_Abschnitt_X.C0058 /= LEER\n ODER\nZK_31_Abschnitt_Y.C0059 /= LEER\n ODER\nZK_31_Abschnitt_Z.C0060 /= LEER\n ODER\nZK_31_Abschnitt_ZA.C0061 /= LEER\n ODER\nZK_31_Abschnitt_ZB.C0062 /= LEER\n ODER\nZK_31_Abschnitt_ZB.C0063 /= LEER\n ODER\nZK_31_Abschnitt_ZC.C0064 /= LEER\n ODER\nZK_31_Abschnitt_ZC.C0065 /= LEER) \nDANN\n\nFEHLER\nENDE";
        String[] str = pruefungStat.splitConditionalStatement(bedingung);
        System.out.println(str[0]);
        System.out.println(str[1]);
        MappingGeneratorTest.assertTrue((String)"Beingung und Anweisung nicht getrennt.", (str.length != 2 ? 1 : 0) != 0);
    }

    protected void setUp() throws Exception {
        super.setUp();
        IntermediateLanguageParser parser = new IntermediateLanguageParser();
        FileReader fin = new FileReader(TEST_FILE);
        this.plausi = (MetaPlausibilisierung)parser.parse(fin);
        fin.close();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public MappingGeneratorTest(String arg0) {
        super(arg0);
    }
}

