/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.runtime.test;

import de.statspez.pleditor.generator.runtime.plausi.PlausiFactory;
import de.statspez.pleditor.generator.runtime.plausi.PlausiInterface;
import de.statspez.pleditor.generator.runtime.test.PlausiTest;
import de.statspez.pleditor.generator.runtime.test.PlausiTestCase;
import de.statspez.pleditor.generator.runtime.test.PlausiTestResult;
import java.util.Iterator;

public class PlausiTestExecutor {
    public PlausiTestResult execute(PlausiInterface plausi, PlausiTest test) {
        PlausiTestResult result = new PlausiTestResult(test);
        long currentMillis = System.currentTimeMillis();
        Iterator iter = test.getTestCases();
        while (iter.hasNext()) {
            ((PlausiTestCase)iter.next()).execute(plausi, result);
        }
        result.setDuration(System.currentTimeMillis() - currentMillis);
        return result;
    }

    public PlausiTestResult execute(PlausiInterface plausi, PlausiTest test, PlausiTestCase testCase) {
        PlausiTestResult result = new PlausiTestResult(test);
        long currentMillis = System.currentTimeMillis();
        testCase.execute(plausi, result);
        result.setDuration(System.currentTimeMillis() - currentMillis);
        return result;
    }

    public static void main(String[] args) {
        int exitCode;
        block21: {
            String plausiName = null;
            String plausiPackage = null;
            String plausiClassNameSuffix = null;
            String plausiTestFileName = null;
            String plausiTestCaseName = null;
            if (args != null && args.length > 0) {
                int i = 0;
                while (i < args.length - 1) {
                    if (args[i].equalsIgnoreCase("-n")) {
                        plausiName = args[++i];
                    } else if (args[i].equalsIgnoreCase("-p")) {
                        plausiPackage = args[++i];
                    } else if (args[i].equalsIgnoreCase("-s")) {
                        plausiClassNameSuffix = args[++i];
                    } else if (args[i].equalsIgnoreCase("-t")) {
                        plausiTestFileName = args[++i];
                    } else if (args[i].equalsIgnoreCase("-c")) {
                        plausiTestCaseName = args[++i];
                    }
                    ++i;
                }
            }
            if (plausiName != null && plausiName.length() > 0 && plausiTestFileName != null && plausiTestFileName.length() > 0) {
                PlausiInterface plausi;
                PlausiFactory plausiFactory = new PlausiFactory();
                if (plausiPackage != null && plausiPackage.length() > 0) {
                    plausiFactory.setPlausiPackage(plausiPackage);
                }
                if ((plausi = plausiFactory.createPlausi(plausiName, plausiClassNameSuffix)) != null) {
                    try {
                        PlausiTest test = new PlausiTest(plausiTestFileName);
                        if (plausiTestCaseName != null && plausiTestCaseName.length() > 0) {
                            PlausiTestCase testCase = test.getTestCase(plausiTestCaseName);
                            if (testCase != null) {
                                System.out.print(new PlausiTestExecutor().execute(plausi, test, testCase));
                                exitCode = 0;
                            } else {
                                System.err.println("Der Testfall <" + plausiTestCaseName + "> wurde im Plausi-Test <" + plausiTestFileName + "> nicht gefunden.");
                                exitCode = -1;
                            }
                            break block21;
                        }
                        System.out.print(new PlausiTestExecutor().execute(plausi, test));
                        exitCode = 0;
                    }
                    catch (Exception e) {
                        System.err.println("Der Plausi-Test <" + plausiTestFileName + "> konnte nicht geladen werden.");
                        e.printStackTrace();
                        exitCode = -1;
                    }
                } else {
                    System.err.println("Die Plausi <" + plausiName + "> konnte nicht geladen werden.");
                    exitCode = -1;
                }
            } else {
                System.err.println("Falsche oder fehlende Aufrufparameter.");
                System.err.println("Aufruf: PlausiTestExecutor -n <Name der PL> -t <Testdatei> [-p <Package> -s <Suffix beim Klassennamen>] [-c <Testfall>]");
                exitCode = -1;
            }
        }
        System.exit(exitCode);
    }
}

