/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.runtime.test;

import de.statspez.pleditor.generator.codegen.java.StringHelper;
import de.statspez.pleditor.generator.interpreter.InterpreterContext;
import de.statspez.pleditor.generator.interpreter.PlausiClassificationFactory;
import de.statspez.pleditor.generator.interpreter.PlausiMaterialNameResolver;
import de.statspez.pleditor.generator.interpreter.PlausiProgramFactory;
import de.statspez.pleditor.generator.interpreter.ProgramDescriptor;
import de.statspez.pleditor.generator.interpreter.ProgramInterpreter;
import de.statspez.pleditor.generator.interpreter.SimpleDataset;
import de.statspez.pleditor.generator.interpreter.TBFieldDescriptorFactory;
import de.statspez.pleditor.generator.meta.MetaCustomAblauf;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.generated.MetaStatspezObjekt;
import de.statspez.pleditor.generator.parser.Helper;
import de.statspez.pleditor.generator.runtime.plausi.PlausiFehler;
import de.statspez.pleditor.generator.runtime.plausi.PlausiInterface;
import de.statspez.pleditor.generator.runtime.plausi.PlausiKontext;
import de.statspez.pleditor.generator.runtime.test.FieldValues;
import de.statspez.pleditor.generator.runtime.test.MaterialValues;
import de.statspez.pleditor.generator.runtime.test.PlausiTestCase;
import de.statspez.pleditor.generator.runtime.test.PlausiTestCaseResult;
import de.statspez.pleditor.generator.runtime.test.PlausiTestResult;
import de.statspez.pleditor.generator.runtime.test.TestFailure;
import de.statspez.pleditor.generator.runtime.test.TestMaterialAccess;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;

public class FlowTestCase
extends PlausiTestCase {
    private String flow = null;
    private boolean featureCheckValueAccessAsString = false;
    private int errorLevel = 1;
    private FieldValues initValues = new FieldValues();
    private List inputValues = new ArrayList();
    private List outputValues = new ArrayList();
    private Map materialValues = new HashMap();
    private boolean checkOutputValues;

    public String getFlow() {
        return this.flow;
    }

    public void setFlow(String flow) {
        this.flow = flow;
    }

    public boolean isFeatureCheckValueAccessAsString() {
        return this.featureCheckValueAccessAsString;
    }

    public void setFeatureCheckValueAccessAsString(boolean featureCheckValueAccessAsString) {
        this.featureCheckValueAccessAsString = featureCheckValueAccessAsString;
    }

    public int getErrorLevel() {
        return this.errorLevel;
    }

    public void setErrorLevel(int errorLevel) {
        this.errorLevel = errorLevel;
    }

    public FieldValues getInitValue() {
        return this.initValues;
    }

    public void addInputValues(FieldValues inputValues) {
        this.inputValues.add(inputValues);
    }

    public Iterator getInputValues() {
        return this.inputValues.iterator();
    }

    public HashMap getInputValuesAsMap() {
        return this.convertListToMap(this.inputValues);
    }

    public void addOutputValues(FieldValues outputValues) {
        this.outputValues.add(outputValues);
    }

    public Iterator getOutputValues() {
        return this.outputValues.iterator();
    }

    public HashMap getOutputValuesAsMap() {
        return this.convertListToMap(this.outputValues);
    }

    public void addMaterialValues(MaterialValues materialValues) {
        this.materialValues.put(materialValues.getMaterialName(), materialValues);
    }

    public Map getMaterialValues() {
        return this.materialValues;
    }

    private HashMap convertListToMap(List list) {
        HashMap<String, String> result = new HashMap<String, String>();
        Iterator listIterator = list.iterator();
        while (listIterator.hasNext()) {
            FieldValues fieldValues = (FieldValues)listIterator.next();
            Iterator fieldKeyIterator = fieldValues.getFields();
            while (fieldKeyIterator.hasNext()) {
                String fieldKey = (String)fieldKeyIterator.next();
                result.put(fieldKey, fieldValues.getValue(fieldKey));
            }
        }
        return result;
    }

    public boolean isCheckOutputValues() {
        return this.checkOutputValues;
    }

    public void setCheckOutputValues(boolean checkOutputValues) {
        this.checkOutputValues = checkOutputValues;
    }

    public void execute(PlausiInterface plausi, PlausiTestResult result) {
        PlausiTestCaseResult testCaseResult = new PlausiTestCaseResult(this);
        try {
            try {
                PlausiKontext context = new PlausiKontext();
                HashMap<String, String> values = new HashMap<String, String>();
                context.setPlausiAblauf(this.getFlow());
                context.setFehlerGewichtSchranke(this.getErrorLevel());
                context.setReferenzDateien(new TestMaterialAccess(this.getMaterialValues()));
                if (this.isFeatureCheckValueAccessAsString()) {
                    context.setMerkmalsPruefungWertAbfrageStrategie(2);
                }
                Iterator iter = this.getInputValues();
                while (iter.hasNext()) {
                    FieldValues fieldValues = (FieldValues)iter.next();
                    Iterator fields = fieldValues.getFields();
                    while (fields.hasNext()) {
                        String field = (String)fields.next();
                        String fieldValue = fieldValues.getValue(field);
                        if (fieldValue == null || fieldValue.length() <= 0) continue;
                        values.put(field, fieldValue);
                    }
                }
                FieldValues initValues = this.getInitValue();
                if (initValues.getValuesCount() > 0) {
                    Object[] initValuesArray = new Object[initValues.getValuesCount()];
                    Iterator fields = initValues.getFields();
                    int i = 0;
                    while (fields.hasNext()) {
                        String field = (String)fields.next();
                        initValuesArray[i++] = initValues.getValue(field);
                    }
                    context.setInitWerte(initValuesArray);
                }
                SimpleDataset dataset = new SimpleDataset(values);
                dataset.setIndicesPrefix("[");
                dataset.setIndicesSuffix("]");
                plausi.gesamtPlausi(dataset, context);
                PlausiFehler[] errors = new PlausiFehler[context.getAnzahlFehler()];
                int i = 0;
                while (i < context.getAnzahlFehler()) {
                    errors[i] = context.getFehler(i);
                    ++i;
                }
                testCaseResult.handlePlausiResult(errors, "Java");
                if (this.isCheckOutputValues()) {
                    this.checkOutputValues(values, null, testCaseResult, "Java");
                }
            }
            catch (Exception ex) {
                testCaseResult.addFailure(new TestFailure(this.getName(), "Java", 5, ex));
                result.addTestCaseResult(testCaseResult);
            }
        }
        finally {
            result.addTestCaseResult(testCaseResult);
        }
    }

    public void interprete(MetaCustomPlausibilisierung plausi, PlausiTestResult result) {
        PlausiTestCaseResult testCaseResult = new PlausiTestCaseResult(this);
        try {
            try {
                MetaStatspezObjekt metaObject = this.getMetaObject(plausi);
                MetaProgram metaProgram = Helper.metaStructureFor(this.getElementMessage(metaObject), this.getProgramCode(metaObject));
                InterpreterContext context = new InterpreterContext();
                context.setClassificationFactory(new PlausiClassificationFactory(plausi));
                context.setMaterialNameResolver(new PlausiMaterialNameResolver(plausi));
                MetaCustomAblauf metaAblauf = (MetaCustomAblauf)metaObject;
                TBFieldDescriptorFactory fieldDescriptorFactory = new TBFieldDescriptorFactory(metaAblauf.getThemenbereich());
                context.setFieldDescriptorFactory(fieldDescriptorFactory);
                context.setProgramFactory(new PlausiProgramFactory(plausi, metaAblauf.getThemenbereich(), fieldDescriptorFactory));
                PlausiKontext myPLContext = new PlausiKontext();
                myPLContext.setReferenzDateien(new TestMaterialAccess(this.getMaterialValues()));
                if (this.isFeatureCheckValueAccessAsString()) {
                    myPLContext.setMerkmalsPruefungWertAbfrageStrategie(2);
                }
                context.setPlausiKontext(myPLContext);
                HashMap<String, String> values = new HashMap<String, String>();
                Iterator fieldValuesIterator = this.getInputValues();
                while (fieldValuesIterator.hasNext()) {
                    FieldValues fieldValues = (FieldValues)fieldValuesIterator.next();
                    Iterator fieldIterator = fieldValues.getFields();
                    while (fieldIterator.hasNext()) {
                        String field = (String)fieldIterator.next();
                        String fieldValue = fieldValues.getValue(field);
                        if (fieldValue == null || fieldValue.length() <= 0) continue;
                        values.put(field, fieldValue);
                    }
                }
                SimpleDataset dataset = new SimpleDataset(values);
                dataset.setIndicesPrefix("[");
                dataset.setIndicesSuffix("]");
                context.setSatz(dataset);
                ProgramDescriptor programDescriptor = new ProgramDescriptor(metaProgram, null, metaObject);
                ProgramInterpreter programInterpreter = new ProgramInterpreter();
                programInterpreter.execute(programDescriptor, null, context);
                testCaseResult.handlePlausiResult(context.getPlausiErrors(), "Interpreter");
                if (this.isCheckOutputValues()) {
                    this.checkOutputValues(values, dataset.getPlVariables(), testCaseResult, "Interpreter");
                }
            }
            catch (Exception ex) {
                testCaseResult.addFailure(new TestFailure(this.getName(), "Interpreter", 5, ex));
                result.addTestCaseResult(testCaseResult);
            }
        }
        finally {
            result.addTestCaseResult(testCaseResult);
        }
    }

    public void performJavaScript(MetaCustomPlausibilisierung plausi, File javaScriptPlausiFile, PlausiTestResult result) {
        PlausiTestCaseResult testCaseResult = new PlausiTestCaseResult(this);
        try {
            try {
                ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
                ScriptEngine scriptEngine = scriptEngineManager.getEngineByName("JavaScript");
                InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("/de/statspez/pleditor/generator/codegen/js/runtime/plausilib.js"));
                try {
                    scriptEngine.eval(reader);
                }
                finally {
                    ((Reader)reader).close();
                }
                reader = new FileReader(javaScriptPlausiFile);
                try {
                    scriptEngine.eval(reader);
                }
                finally {
                    ((Reader)reader).close();
                }
                scriptEngine.eval("var values = new Array();");
                Iterator fieldValuesIterator = this.getInputValues();
                while (fieldValuesIterator.hasNext()) {
                    FieldValues fieldValues = (FieldValues)fieldValuesIterator.next();
                    Iterator fieldIterator = fieldValues.getFields();
                    while (fieldIterator.hasNext()) {
                        String field = (String)fieldIterator.next();
                        String fieldValue = fieldValues.getValue(field);
                        if (fieldValue == null || fieldValue.length() <= 0) continue;
                        scriptEngine.eval("values['" + field + "'] = '" + fieldValue + "';");
                    }
                }
                scriptEngine.eval("function getValue(field) {return values[field];}");
                scriptEngine.eval("function setValue(field, value) {values[field] = value;}");
                scriptEngine.eval("function getSizeOf(field) {var size = getValue(field + '#anzahl'); return size != null ? size : 0;}");
                scriptEngine.eval("function getIndicesAsString(indices) {return '[' + indices + ']';}");
                scriptEngine.eval("function trace(text) {println(text);}");
                String statement = "prg_" + StringHelper.getEscapedName(this.getFlow()) + "()";
                testCaseResult.handlePlausiResult(this.performJavaScriptPlausi(scriptEngine, statement), "JavaScript");
                if (this.isCheckOutputValues()) {
                    scriptEngine.eval("var fields = new Array();");
                    scriptEngine.eval("for (var field in values) {fields.push(field);}");
                    Number numOfValues = (Number)scriptEngine.eval("fields.length");
                    HashMap<String, Object> values = new HashMap<String, Object>();
                    int i = 0;
                    while (i < numOfValues.intValue()) {
                        String field = (String)scriptEngine.eval("fields[" + i + "]");
                        values.put(field, scriptEngine.eval("values['" + field + "']"));
                        ++i;
                    }
                    this.checkOutputValues(values, null, testCaseResult, "JavaScript");
                }
            }
            catch (Exception ex) {
                testCaseResult.addFailure(new TestFailure(this.getName(), "JavaScript", 5, ex));
                result.addTestCaseResult(testCaseResult);
            }
        }
        finally {
            result.addTestCaseResult(testCaseResult);
        }
    }

    private void checkOutputValues(Map outputMap, Set plVariables, PlausiTestCaseResult testCaseResult, String context) {
        HashMap expectedOutputMap = this.getOutputValuesAsMap();
        Iterator expectedOutputIterator = expectedOutputMap.keySet().iterator();
        while (expectedOutputIterator.hasNext()) {
            String key = (String)expectedOutputIterator.next();
            String value = outputMap.get(key) instanceof Number ? ((Long)outputMap.get(key)).toString() : (String)outputMap.get(key);
            String expectedValue = (String)expectedOutputMap.get(key);
            if (value != null) {
                outputMap.remove(key);
                if (value.equals(expectedValue)) continue;
                testCaseResult.addFailure(new TestFailure(this.getName(), context, 7, key, 10, expectedValue, value));
                continue;
            }
            testCaseResult.addFailure(new TestFailure(this.getName(), context, 6, key));
        }
        Iterator outputIterator = outputMap.keySet().iterator();
        while (outputIterator.hasNext()) {
            String key = (String)outputIterator.next();
            if (plVariables != null && plVariables.contains(key)) continue;
            testCaseResult.addFailure(new TestFailure(this.getName(), context, 5, key));
        }
    }
}

