/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.runtime;

import de.statspez.pleditor.generator.runtime.Array;
import de.statspez.pleditor.generator.runtime.ArrayIterator;
import de.statspez.pleditor.generator.runtime.DateValue;
import de.statspez.pleditor.generator.runtime.InconvertibleValue;
import de.statspez.pleditor.generator.runtime.InvalidValue;
import de.statspez.pleditor.generator.runtime.NumberValue;
import de.statspez.pleditor.generator.runtime.PlausiRuntimeContext;
import de.statspez.pleditor.generator.runtime.PlausiRuntimeIterator;
import de.statspez.pleditor.generator.runtime.Range;
import de.statspez.pleditor.generator.runtime.SingleElementArray;
import de.statspez.pleditor.generator.runtime.SingleValueIterator;
import de.statspez.pleditor.generator.runtime.StringValue;
import de.statspez.pleditor.generator.runtime.Value;
import de.statspez.pleditor.generator.runtime.ValueConversionException;

public class SupportLib {
    public static void copyArray(Array source, Array destination, PlausiRuntimeContext context) {
        PlausiRuntimeIterator sourceIterator = SupportLib.iteratorFor(source, context);
        PlausiRuntimeIterator destinationIterator = SupportLib.iteratorFor(destination, context);
        while (sourceIterator.hasNext() && destinationIterator.hasNext()) {
            destinationIterator.next();
            destinationIterator.lastVariable().set(context, (Value)sourceIterator.next());
        }
    }

    public static PlausiRuntimeIterator iteratorFor(Object rtObject, PlausiRuntimeContext context) {
        PlausiRuntimeIterator it = null;
        if (rtObject instanceof Array) {
            it = new ArrayIterator((Array)rtObject, context);
        } else if (rtObject instanceof Range) {
            it = ((Range)rtObject).iterator();
        } else if (rtObject instanceof Value) {
            it = new SingleValueIterator((Value)rtObject);
        } else {
            throw new RuntimeException("kein Iterator fuer Objekte vom Typ " + rtObject.getClass().getName());
        }
        return it;
    }

    public static ArrayIterator forceArrayIteratorFor(Object rtObject, PlausiRuntimeContext context) {
        if (rtObject instanceof Array) {
            return new ArrayIterator((Array)rtObject, context);
        }
        return new ArrayIterator(new SingleElementArray(rtObject), context);
    }

    public static boolean checkType(Value value, int type, PlausiRuntimeContext context) {
        return SupportLib.checkType(value, type, null, context);
    }

    public static boolean checkType(Value value, int type, String maske, PlausiRuntimeContext context) {
        if (value instanceof InconvertibleValue) {
            return false;
        }
        if (value instanceof InvalidValue) {
            return true;
        }
        boolean typeOk = false;
        try {
            switch (type) {
                case 4: {
                    value.asBoolean();
                    typeOk = true;
                    break;
                }
                case 2: {
                    NumberValue numberValue = value instanceof NumberValue ? (NumberValue)value : new NumberValue(value.asString());
                    typeOk = numberValue.isRealValueValid(maske);
                    break;
                }
                case 0: {
                    NumberValue numberValue = value instanceof NumberValue ? (NumberValue)value : new NumberValue(value.asString());
                    typeOk = numberValue.isIntegerValueValid(maske);
                    break;
                }
                case 5: 
                case 6: {
                    if (value instanceof DateValue) {
                        if (maske != null) {
                            DateValue dateValue = (DateValue)value;
                            typeOk = dateValue.isDateValueValid(maske);
                            break;
                        }
                        typeOk = true;
                        break;
                    }
                    if (value instanceof InvalidValue) {
                        typeOk = true;
                        break;
                    }
                    DateValue dateValue = new DateValue(value.asString(), maske);
                    typeOk = dateValue.isDateValueValid(maske);
                    break;
                }
                case 3: {
                    if (maske != null) {
                        StringValue stringValue = value instanceof StringValue ? (StringValue)value : new StringValue(value.asString());
                        typeOk = stringValue.isStringValueValid(maske);
                        break;
                    }
                    value.asString();
                    typeOk = true;
                    break;
                }
                case 8: {
                    value.asString();
                    typeOk = true;
                    break;
                }
                case 7: {
                    typeOk = true;
                }
            }
        }
        catch (ValueConversionException exc) {
            typeOk = false;
        }
        return typeOk;
    }
}

