/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.runtime;

import de.statspez.pleditor.generator.masken.AbstractMaske;
import de.statspez.pleditor.generator.masken.MaskenParserFaktory;
import de.statspez.pleditor.generator.masken.MaskenParserInterface;
import de.statspez.pleditor.generator.runtime.NumberValue;
import de.statspez.pleditor.generator.runtime.Value;
import de.statspez.pleditor.generator.runtime.ValueConversionException;

public class StringValue
extends Value {
    private String myValue = null;

    public StringValue(String value) {
        this.myValue = value;
    }

    public double asDouble() throws ValueConversionException {
        try {
            NumberValue numberValue = new NumberValue(this.asString());
            return numberValue.asDouble();
        }
        catch (Exception exc) {
            throw new ValueConversionException("Der Wert '" + this.asString() + "' kann nicht in eine Zahl konvertiert werden.", exc);
        }
    }

    public long asLong() throws ValueConversionException {
        try {
            NumberValue numberValue = new NumberValue(this.asString());
            return numberValue.asLong();
        }
        catch (Exception exc) {
            throw new ValueConversionException("Der Wert '" + this.asString() + "' kann nicht in eine Zahl konvertiert werden.", exc);
        }
    }

    public boolean asBoolean() throws ValueConversionException {
        if ("WAHR".equalsIgnoreCase(this.asString())) {
            return true;
        }
        if ("FALSCH".equalsIgnoreCase(this.asString())) {
            return false;
        }
        throw new ValueConversionException("Der Wert '" + this.asString() + "' kann nicht in einen Wahrheitswert konvertiert werden.");
    }

    public String asString() throws ValueConversionException {
        return this.myValue;
    }

    public boolean isStringValueValid(String mask) {
        boolean valid;
        try {
            MaskenParserInterface parser = MaskenParserFaktory.getInstance().getMaskenParserFuerTyp(6);
            AbstractMaske maske = parser.parse(mask);
            valid = maske.isWertGueltig(this.asString());
        }
        catch (Exception e) {
            valid = false;
        }
        return valid;
    }

    protected StringValue() {
        this.myValue = null;
    }

    protected int operatorLevel() {
        return 1;
    }

    protected boolean eqImpl(Value aValue) {
        return this.asString().equals(aValue.asString());
    }

    protected boolean ltImpl(Value aValue) {
        return this.asString().compareTo(aValue.asString()) < 0;
    }

    protected boolean leImpl(Value aValue) {
        return this.asString().compareTo(aValue.asString()) <= 0;
    }

    protected boolean gtImpl(Value aValue) {
        return this.asString().compareTo(aValue.asString()) > 0;
    }

    protected boolean geImpl(Value aValue) {
        return this.asString().compareTo(aValue.asString()) >= 0;
    }

    protected boolean neImpl(Value aValue) {
        return !this.asString().equals(aValue.asString());
    }

    protected boolean containsImpl(Value aValue) {
        return this.eq(aValue);
    }
}

