/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.runtime;

import de.statspez.pleditor.generator.runtime.FeatureVariable;
import de.statspez.pleditor.generator.runtime.InconvertibleValue;
import de.statspez.pleditor.generator.runtime.InvalidValue;
import de.statspez.pleditor.generator.runtime.NumberValue;
import de.statspez.pleditor.generator.runtime.PlausiRuntimeContext;
import de.statspez.pleditor.generator.runtime.Value;
import de.statspez.pleditor.generator.runtime.Variable;
import de.statspez.pleditor.generator.runtime.plausi.FeldDeskriptorInterface;
import de.statspez.pleditor.generator.runtime.plausi.SatzInterface;
import de.statspez.pleditor.generator.runtime.plausi.WertNichtTypgerechtException;
import java.util.Stack;

public class MerkmalCheckFeatureVariable
implements Variable {
    private FeatureVariable variable;

    public MerkmalCheckFeatureVariable(FeatureVariable variable) {
        this.variable = variable;
    }

    public Value get(PlausiRuntimeContext context) {
        Value value;
        if (2 == context.getPlausiKontext().getMerkmalsPruefungWertAbfrageStrategie() && (this.variable.getFeldDeskriptor().getFeldTyp() == 0 || 2 == this.variable.getFeldDeskriptor().getFeldTyp())) {
            if (context.getPlausi().getPlausiSystemVersion() < 3.0) {
                if (context.getPlausi().currentSectionContext() != null) {
                    context.getPlausi().currentSectionContext().markFieldAccess(this.variable);
                }
            } else if (context.currentSectionContext() != null) {
                context.currentSectionContext().markFieldAccess(this.variable);
            }
            try {
                Stack<FeldDeskriptorInterface> hierachy = new Stack<FeldDeskriptorInterface>();
                FeldDeskriptorInterface current = this.variable.getVorgaenger();
                while (current != null) {
                    hierachy.push(current);
                    current = current.getVorgaenger();
                }
                SatzInterface subSatz = context.getSatz();
                while (!hierachy.empty()) {
                    current = (FeldDeskriptorInterface)hierachy.pop();
                    subSatz = subSatz.getSubSatz(current);
                }
                if (subSatz.hatWert(this.variable)) {
                    value = new NumberValue(subSatz.getString(this.variable));
                }
                value = InvalidValue.instance();
            }
            catch (WertNichtTypgerechtException e) {
                value = new InconvertibleValue(e.getMessage());
            }
            catch (Exception e) {
                throw new RuntimeException("Das Feld " + this.variable.getFeldNameTB() + " kann nicht gelesen werden", e);
            }
        } else {
            value = this.variable.get(context);
        }
        return value;
    }

    public void set(PlausiRuntimeContext context, Value value) {
        this.variable.set(context, value);
    }

    public String toString(PlausiRuntimeContext context) {
        return this.variable.toString(context);
    }

    public Variable copy(PlausiRuntimeContext context) {
        return this.variable.copy(context);
    }
}

