/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.runtime;

import de.statspez.pleditor.generator.runtime.IteratorIterator;
import de.statspez.pleditor.generator.runtime.MaterialValue;
import de.statspez.pleditor.generator.runtime.MaterialValueSet;
import de.statspez.pleditor.generator.runtime.NilValue;
import de.statspez.pleditor.generator.runtime.PlausiRuntimeContext;
import de.statspez.pleditor.generator.runtime.PlausiRuntimeIterator;
import de.statspez.pleditor.generator.runtime.Range;
import de.statspez.pleditor.generator.runtime.Value;
import de.statspez.pleditor.generator.runtime.ValueConversionException;
import de.statspez.pleditor.generator.runtime.plausi.FeldDeskriptorInterface;
import de.statspez.pleditor.generator.runtime.plausi.MaterialDeskriptorInterface;
import de.statspez.pleditor.generator.runtime.plausi.ReferenzDateiInterface;
import de.statspez.pleditor.generator.runtime.plausi.SatzFilter;
import de.statspez.pleditor.generator.runtime.plausi.SatzInterface;

public class Material
extends Range {
    private MaterialDeskriptorInterface material = null;
    private Value firstValue = null;
    private FeldDeskriptorInterface[] fields;
    private SatzFilter satzFilter = null;
    private PlausiRuntimeContext context = null;

    public Material(MaterialDeskriptorInterface material, FeldDeskriptorInterface[] fields, SatzFilter.FilterBedingung[] selectionConditions, PlausiRuntimeContext context) {
        this.material = material;
        this.fields = fields;
        this.context = context;
        this.satzFilter = new SatzFilter();
        this.satzFilter.setFilterBedingungen(selectionConditions);
    }

    public PlausiRuntimeIterator iterator() {
        try {
            ReferenzDateiInterface refDatIfc = this.context.getPlausiKontext().getReferenzDateien();
            SatzInterface[] saetze = refDatIfc.gibSaetzeGefiltert(this.fields, this.satzFilter, this.material);
            IteratorIterator it = new IteratorIterator();
            int i = 0;
            while (i < saetze.length) {
                Value[] satzWerte = new Value[this.fields.length];
                int j = 0;
                while (j < this.fields.length) {
                    satzWerte[j] = new MaterialValue(this.fields[j], saetze[i]);
                    ++j;
                }
                it.addIterator(new MaterialValueSet(satzWerte).iterator());
                ++i;
            }
            this.firstValue = null;
            return it;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            throw new RuntimeException("Auf das Material " + this.material.getMaterialName() + " kann nicht zugegriffen werden.", exc);
        }
    }

    public double asDouble() throws ValueConversionException {
        return this.firstValue().asDouble();
    }

    public long asLong() throws ValueConversionException {
        return this.firstValue().asLong();
    }

    public boolean asBoolean() throws ValueConversionException {
        return this.firstValue().asBoolean();
    }

    public String asString() throws ValueConversionException {
        return this.firstValue().asString();
    }

    public Value firstValue() {
        if (this.firstValue == null) {
            PlausiRuntimeIterator iter = this.iterator();
            if (iter != null && iter.hasNext()) {
                this.firstValue = (Value)iter.next();
            }
            if (this.firstValue == null) {
                this.firstValue = NilValue.instance();
            }
        }
        return this.firstValue;
    }

    protected boolean containsImpl(Value aValue) {
        try {
            int valueCount = 0;
            Value[] values = new Value[this.fields.length];
            if (!(aValue instanceof Range)) {
                values[0] = aValue;
                valueCount = 1;
            } else {
                PlausiRuntimeIterator it = ((Range)aValue).iterator();
                while (it.hasNext() && valueCount < values.length) {
                    values[valueCount] = (Value)it.next();
                    ++valueCount;
                }
            }
            if (valueCount != values.length) {
                throw new RuntimeException(String.valueOf(Integer.toString(values.length)) + " Wert erwartet aber nur " + Integer.toString(valueCount) + " erhalten.");
            }
            ReferenzDateiInterface refDatIfc = this.context.getPlausiKontext().getReferenzDateien();
            return refDatIfc.wertKombinationGueltig(values, this.fields, this.satzFilter, this.material);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            throw new RuntimeException("Auf das Material " + this.material.getMaterialName() + " kann nicht zugegriffen werden.", exc);
        }
    }
}

