/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.parser;

import de.statspez.pleditor.generator.meta.MetaCustomVariable;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.parser.Helper;
import de.statspez.pleditor.generator.parser.ILParseException;
import de.statspez.pleditor.generator.parser.Resolver;
import de.statspez.pleditor.generator.parser.SubParser;
import de.statspez.pleditor.generator.parser.SuperParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class VariablenParser
extends SubParser {
    private MetaCustomVariable currentVar = null;

    public VariablenParser(SuperParser sParser, Resolver resolver) {
        super(sParser, resolver);
    }

    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if ("http://www.werum.de/pl-editor".equalsIgnoreCase(namespaceURI) && "variable".equalsIgnoreCase(tag)) {
            return true;
        }
        return this.isEnabled();
    }

    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("variable".equalsIgnoreCase(localName)) {
            this.enable();
            this.currentVar = new MetaCustomVariable();
        }
        this.handleAttributes(namespaceURI, localName, qName, atts);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("variable".equalsIgnoreCase(localName)) {
            this.disableAndNotify();
        } else if (!this.handleTag(namespaceURI, localName, qName) && !"http://www.destatis.de/schema/datml-ssp/1.0".equalsIgnoreCase(namespaceURI)) {
            throw ILParseException.unknownTagException(localName);
        }
    }

    public MetaElement object() {
        return this.currentVar;
    }

    private void handleAttributes(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("variable".equalsIgnoreCase(localName)) {
            String persistent;
            String name = atts.getValue("name");
            if (name == null) {
                throw new ILParseException("Fuer die Variable ist kein Name definiert!");
            }
            this.currentVar.setName(name.trim());
            String type = atts.getValue("type");
            if (type == null) {
                throw new ILParseException("Fuer die Variable " + name + " ist kein Typ definiert!");
            }
            this.currentVar.setTyp(Helper.typeByName(type.trim()));
            String length = atts.getValue("length");
            if (length == null) {
                this.currentVar.setLaenge(0L);
            } else {
                this.currentVar.setLaenge(Long.parseLong(length.trim()));
            }
            String dimensions = atts.getValue("dimensions");
            if (dimensions != null) {
                this.currentVar.setListe(true);
                this.currentVar.setDimensions(Helper.parseDimensionSpec(dimensions));
                this.currentVar.setDimension(dimensions);
            }
            if ((persistent = atts.getValue("persistent")) == null) {
                this.currentVar.setPersistent(false);
            } else {
                this.currentVar.setPersistent(Helper.toBoolean(persistent.trim()));
            }
        }
    }

    private boolean handleTag(String namespaceURI, String localName, String qName) throws SAXException {
        boolean handled = true;
        String chars = this.superParser().charData().toString().trim();
        if ("code".equalsIgnoreCase(localName)) {
            if (chars.length() > 0) {
                this.currentVar.setBelegung(chars);
                MetaProgram spez = Helper.metaStructureFor(chars);
                spez.setName("init__var__" + this.currentVar.getName());
                this.currentVar.setMetaBelegung(spez);
            }
        } else if (!"properties".equalsIgnoreCase(localName) && !"about".equalsIgnoreCase(localName)) {
            if ("description".equalsIgnoreCase(localName)) {
                chars = this.superParser().charData().toString();
                this.currentVar.setBeschreibung(chars);
            } else {
                handled = false;
            }
        }
        return handled;
    }
}

