/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.parser;

import de.statspez.pleditor.generator.common.AbstractMessage;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.parser.ILParseException;
import de.statspez.pleditor.generator.parser.ParserChain;
import de.statspez.pleditor.generator.parser.Resolver;
import de.statspez.pleditor.generator.parser.SubParser;
import de.statspez.pleditor.generator.parser.SuperParser;
import de.statspez.pleditor.generator.parser.TimeZoneOffsetParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class TimeParser
extends SubParser
implements SuperParser {
    private MetaElement currentElement = null;
    private ParserChain parserChain = new ParserChain();
    private TimeZoneOffsetParser timeZoneOffsetParser = new TimeZoneOffsetParser(this, this.resolver());
    private int hours = 0;
    private int minutes = 0;
    private int seconds = 0;
    private String timeZoneOffset = null;
    private String timeZoneName = null;
    private int fraktionSeconds = 0;

    public TimeParser(SuperParser sParser, Resolver resolver) {
        super(sParser, resolver);
        this.parserChain.addParser(this.timeZoneOffsetParser);
    }

    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if ("http://www.destatis.de/schema/datml-ssp/1.0".equalsIgnoreCase(namespaceURI) && "time".equalsIgnoreCase(tag)) {
            return true;
        }
        return this.isEnabled();
    }

    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("time".equalsIgnoreCase(localName)) {
            this.enable();
        } else if (!this.parserChain.startElement(namespaceURI, localName, qName, atts) && !this.canHandleTag(namespaceURI, localName)) {
            throw ILParseException.unknownTagException(localName);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("time".equalsIgnoreCase(localName)) {
            this.disableAndNotify();
        } else if (!this.parserChain.endElement(namespaceURI, localName, qName) && !this.handleTag(namespaceURI, localName, qName)) {
            throw ILParseException.unkownClosingTagException(localName);
        }
    }

    public MetaElement object() {
        return this.currentElement;
    }

    public String parentElement() {
        return this.superParser().parentElement();
    }

    public void notifyObjectAvailable(SubParser aParser) {
        if (this.timeZoneOffsetParser == aParser) {
            this.timeZoneOffset = this.timeZoneOffsetParser.getTimeZoneOffset();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean handleTag(String namespaceURI, String localName, String qName) throws SAXException {
        boolean handled = true;
        String chars = this.superParser().charData().toString().trim();
        if ("hours".equalsIgnoreCase(localName)) {
            try {
                if (chars.length() <= 0) return handled;
                this.hours = Integer.parseInt(chars);
                if (this.hours < 0) throw new ILParseException("Fehlerhafte Stundenangabe!");
                if (this.hours <= 24) return handled;
                throw new ILParseException("Fehlerhafte Stundenangabe!");
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                throw new ILParseException("Fehlerhafte Stundenangabe!");
            }
        }
        if ("minutes".equalsIgnoreCase(localName)) {
            try {
                if (chars.length() <= 0) return handled;
                this.minutes = Integer.parseInt(chars);
                if (this.minutes < 0) throw new ILParseException("Fehlerhafte Minutenangabe!");
                if (this.minutes <= 60) return handled;
                throw new ILParseException("Fehlerhafte Minutenangabe!");
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                throw new ILParseException("Fehlerhafte Minutenangabe!");
            }
        }
        if ("seconds".equalsIgnoreCase(localName)) {
            try {
                if (chars.length() <= 0) return handled;
                this.seconds = Integer.parseInt(chars);
                if (this.seconds < 0) throw new ILParseException("Fehlerhafte Sekundenangabe!");
                if (this.seconds <= 60) return handled;
                throw new ILParseException("Fehlerhafte Sekundenangabe!");
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                throw new ILParseException("Fehlerhafte Sekundenangabe!");
            }
        }
        if ("fractionSeconds".equalsIgnoreCase(localName)) {
            try {
                if (chars.length() <= 0) return handled;
                this.fraktionSeconds = Integer.parseInt(chars);
                return handled;
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                throw new ILParseException("Fehlerhafte 'FractionSeconds'- Angabe!");
            }
        } else {
            if (!"timeZoneName".equalsIgnoreCase(localName)) return false;
            this.timeZoneName = chars;
        }
        return handled;
    }

    private boolean canHandleTag(String namespaceURI, String localName) {
        return "hours".equalsIgnoreCase(localName) || "minutes".equalsIgnoreCase(localName) || "seconds".equalsIgnoreCase(localName) || "fractionSeconds".equalsIgnoreCase(localName) || "timeZoneName".equalsIgnoreCase(localName);
    }

    public StringBuffer charData() {
        return this.superParser().charData();
    }

    public void setCurrentElement(MetaElement objekt) {
        this.currentElement = objekt;
        this.timeZoneOffsetParser.setCurrentElement(this.currentElement);
    }

    public void error(AbstractMessage errorMessage) {
        this.superParser().error(errorMessage);
    }

    public int getHours() {
        return this.hours;
    }

    public int getFraktionSeconds() {
        return this.fraktionSeconds;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public String getTimeZoneName() {
        return this.timeZoneName;
    }

    public String getTimeZoneOffset() {
        return this.timeZoneOffset;
    }
}

