/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.parser;

import de.statspez.pleditor.generator.common.AbstractMessage;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.generated.MetaStatspezObjekt;
import de.statspez.pleditor.generator.parser.AboutParser;
import de.statspez.pleditor.generator.parser.ApplicationParser;
import de.statspez.pleditor.generator.parser.AuthorParser;
import de.statspez.pleditor.generator.parser.ContactParser;
import de.statspez.pleditor.generator.parser.DateParser;
import de.statspez.pleditor.generator.parser.ILParseException;
import de.statspez.pleditor.generator.parser.ParserChain;
import de.statspez.pleditor.generator.parser.Resolver;
import de.statspez.pleditor.generator.parser.StatusParser;
import de.statspez.pleditor.generator.parser.SubParser;
import de.statspez.pleditor.generator.parser.SuperParser;
import de.statspez.pleditor.generator.parser.TimeParser;
import java.util.Date;
import java.util.GregorianCalendar;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class PropertiesParser
extends SubParser
implements SuperParser {
    private MetaStatspezObjekt currentElement = null;
    private ParserChain parserChain = new ParserChain();
    private AboutParser aboutParser = null;
    private AuthorParser authorParser = null;
    private ContactParser contactParser = null;
    private DateParser dateParser = null;
    private TimeParser timeParser = null;
    private StatusParser statusParser = null;
    private ApplicationParser applicationParser = null;
    private boolean canEnabled = true;
    private int tag;
    private int jahr;
    private int monat;
    private int std;
    private int min;
    private int sec;

    public PropertiesParser(SuperParser sParser, Resolver resolver) {
        super(sParser, resolver);
        this.applicationParser = new ApplicationParser(this, resolver);
        this.parserChain.addParser(this.applicationParser);
        this.statusParser = new StatusParser(this, resolver);
        this.parserChain.addParser(this.statusParser);
        this.dateParser = new DateParser(this, resolver);
        this.parserChain.addParser(this.dateParser);
        this.aboutParser = new AboutParser(this, resolver);
        this.parserChain.addParser(this.aboutParser);
        this.authorParser = new AuthorParser(this, resolver);
        this.parserChain.addParser(this.authorParser);
        this.contactParser = new ContactParser(this, resolver);
        this.parserChain.addParser(this.contactParser);
        this.timeParser = new TimeParser(this, resolver);
        this.parserChain.addParser(this.timeParser);
    }

    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if ("http://www.destatis.de/schema/datml-ssp/1.0".equalsIgnoreCase(namespaceURI) && "properties".equalsIgnoreCase(tag)) {
            return this.canEnabled;
        }
        return this.isEnabled();
    }

    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("properties".equalsIgnoreCase(localName)) {
            this.enable();
            this.handleAttributes(namespaceURI, localName, qName, atts);
        } else if (!this.parserChain.startElement(namespaceURI, localName, qName, atts)) {
            if (this.canHandleTag(namespaceURI, localName)) {
                this.handleAttributes(namespaceURI, localName, qName, atts);
            } else {
                throw ILParseException.unknownTagException(localName);
            }
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("properties".equalsIgnoreCase(localName)) {
            try {
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.set(this.jahr, this.monat - 1, this.tag, this.std, this.min, this.sec);
                Date date = calendar.getTime();
                this.currentElement.setGenDate(date);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ILParseException("Datum ist fehlerhaft!");
            }
            this.canEnabled = false;
            this.disableAndNotify();
        } else if (!this.parserChain.endElement(namespaceURI, localName, qName) && !this.handleTag(namespaceURI, localName, qName)) {
            throw ILParseException.unkownClosingTagException(localName);
        }
    }

    public MetaElement object() {
        return this.currentElement;
    }

    private void handleAttributes(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("properties".equalsIgnoreCase(localName)) {
            String string = atts.getValue("id");
        } else if ("annotation".equalsIgnoreCase(localName)) {
            String string = atts.getValue("class");
        } else if ("copyright".equalsIgnoreCase(localName)) {
            String string = atts.getValue("id");
        }
    }

    private boolean handleTag(String namespaceURI, String localName, String qName) throws SAXException {
        boolean handled = true;
        if (!"copyright".equalsIgnoreCase(localName)) {
            if ("annotation".equalsIgnoreCase(localName)) {
                String chars = this.superParser().charData().toString();
                if (this.currentElement != null) {
                    this.currentElement.setKommentar(chars);
                }
            } else {
                handled = false;
            }
        }
        return handled;
    }

    private boolean canHandleTag(String namespaceURI, String localName) {
        return "copyright".equalsIgnoreCase(localName) || "annotation".equalsIgnoreCase(localName) || "properties".equalsIgnoreCase(localName);
    }

    public void notifyObjectAvailable(SubParser aParser) {
        if (aParser == this.dateParser) {
            this.jahr = this.dateParser.getYear();
            this.monat = this.dateParser.getMonth();
            this.tag = this.dateParser.getDay();
        } else if (aParser == this.timeParser) {
            this.std = this.timeParser.getHours();
            this.min = this.timeParser.getMinutes();
            this.sec = this.timeParser.getSeconds();
        }
    }

    public StringBuffer charData() {
        return this.superParser().charData();
    }

    public String parentElement() {
        return this.superParser().parentElement();
    }

    public void setCurrentElement(MetaStatspezObjekt objekt) {
        this.currentElement = objekt;
        this.aboutParser.setCurrentElement(this.currentElement);
        this.authorParser.setCurrentElement(this.currentElement);
        this.contactParser.setCurrentElement(this.currentElement);
        this.dateParser.setCurrentElement(this.currentElement);
        this.timeParser.setCurrentElement(this.currentElement);
        this.statusParser.setCurrentElement(this.currentElement);
        this.applicationParser.setCurrentElement(this.currentElement);
        this.canEnabled = true;
    }

    public void error(AbstractMessage errorMessage) {
        this.superParser().error(errorMessage);
    }
}

