/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.parser;

import de.statspez.pleditor.generator.common.AbstractMessage;
import de.statspez.pleditor.generator.meta.MetaCustomMapping;
import de.statspez.pleditor.generator.meta.MetaCustomMappingElement;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.parser.ILParseException;
import de.statspez.pleditor.generator.parser.MappingElementParser;
import de.statspez.pleditor.generator.parser.ObjectContextParser;
import de.statspez.pleditor.generator.parser.ParserChain;
import de.statspez.pleditor.generator.parser.PropertiesParser;
import de.statspez.pleditor.generator.parser.Resolver;
import de.statspez.pleditor.generator.parser.SubParser;
import de.statspez.pleditor.generator.parser.SuperParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class MappingParser
extends SubParser
implements SuperParser {
    private MetaCustomMapping currentMapping = null;
    private ParserChain parserChain = new ParserChain();
    private PropertiesParser propertiesParser = null;
    private ObjectContextParser objectContextParser = null;
    private MappingElementParser mappingElementParser = null;
    private boolean useIDAsRef = true;
    private boolean useIDAsRef_gesetzt = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public MappingParser(SuperParser sParser, Resolver resolver) {
        super(sParser, resolver);
        this.propertiesParser = new PropertiesParser(this, resolver);
        this.parserChain.addParser(this.propertiesParser);
        this.objectContextParser = new ObjectContextParser(this, resolver);
        this.parserChain.addParser(this.objectContextParser);
        this.mappingElementParser = new MappingElementParser(this, resolver);
        this.parserChain.addParser(this.mappingElementParser);
    }

    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if ("http://www.werum.de/pl-editor".equalsIgnoreCase(namespaceURI) && "mapping".equalsIgnoreCase(tag)) {
            return true;
        }
        return this.isEnabled();
    }

    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("mapping".equalsIgnoreCase(localName)) {
            this.enable();
            this.currentMapping = new MetaCustomMapping();
            this.propertiesParser.setCurrentElement(this.currentMapping);
            this.objectContextParser.setCurrentElement(this.currentMapping);
        } else if (!this.parserChain.startElement(namespaceURI, localName, qName, atts)) {
            throw ILParseException.unknownTagException(localName);
        }
        this.handleAttributes(namespaceURI, localName, qName, atts);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("mapping".equalsIgnoreCase(localName)) {
            this.disableAndNotify();
        } else if (!this.parserChain.endElement(namespaceURI, localName, qName)) {
            throw ILParseException.unkownClosingTagException(localName);
        }
    }

    public MetaElement object() {
        return this.currentMapping;
    }

    public void notifyObjectAvailable(SubParser aParser) {
        if (this.mappingElementParser == aParser) {
            MetaCustomMappingElement el = (MetaCustomMappingElement)aParser.object();
            if (!this.useIDAsRef_gesetzt) {
                this.useIDAsRef = el.isUseIDasRef();
                this.useIDAsRef_gesetzt = true;
            }
            if (this.useIDAsRef == el.isUseIDasRef()) {
                this.currentMapping.addToMappingliste(el);
            } else {
                System.out.println("Fehler: MappingElement passt nicht hinsichtlich der ID zur Gruppe. MappingElement " + el.getTBFeldListeAlsName() + "->" + el.getDsbFeldAlsName() + " wird verworven ");
            }
        }
    }

    public StringBuffer charData() {
        return this.superParser().charData();
    }

    public String parentElement() {
        return this.superParser().parentElement();
    }

    private void handleAttributes(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("mapping".equalsIgnoreCase(localName)) {
            String state;
            String name = atts.getValue("name");
            if (name == null) {
                throw new ILParseException("Fuer die Mapping ist kein Name definiert!");
            }
            this.currentMapping.setName(name.trim());
            String str = atts.getValue("id");
            if (str != null && str.trim().length() > 0 && this.resolver().isUseIDasRef()) {
                this.currentMapping.setId(str.trim());
            } else {
                this.currentMapping.setId(name);
            }
            String source = atts.getValue("source");
            String source_id = atts.getValue("source-id");
            String key = null;
            if (source_id != null && source_id.trim().length() > 0 && this.resolver().isUseIDasRef()) {
                key = source_id;
            } else if (source != null && source.trim().length() > 0) {
                key = source;
            }
            if (key != null) {
                Resolver resolver = this.resolver();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("de.statspez.pleditor.generator.meta.MetaCustomThemenbereich");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                resolver.registerForResolve(this.currentMapping, key, source, clazz);
            }
            String target = atts.getValue("target");
            String target_id = atts.getValue("target-id");
            key = null;
            String typ = atts.getValue("type");
            Class<?> refClass = null;
            if ("virtual".equals(typ)) {
                this.currentMapping.setVirtual(true);
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("de.statspez.pleditor.generator.meta.generated.MetaRawDataSet");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                refClass = clazz;
            } else {
                this.currentMapping.setVirtual(false);
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("de.statspez.pleditor.generator.meta.generated.MetaDsbObjekt");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                refClass = clazz;
            }
            if (target_id != null && target_id.trim().length() > 0 && this.resolver().isUseIDasRef()) {
                key = target_id;
            } else if (target != null && target.trim().length() > 0) {
                key = target;
            }
            if (key != null) {
                this.resolver().registerForResolve(this.currentMapping, key, target, refClass);
            }
            if ((state = atts.getValue("state")) != null && state.trim().equals("approved")) {
                this.currentMapping.setFreigabeStatus((short)1);
            }
        }
    }

    public void error(AbstractMessage errorMessage) {
        this.superParser().error(errorMessage);
    }
}

