/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.parser;

import de.statspez.pleditor.generator.common.AbstractMessage;
import de.statspez.pleditor.generator.meta.MetaCustomEinzelfeld;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.generated.MetaDsbComps;
import de.statspez.pleditor.generator.meta.generated.MetaDsbFeld;
import de.statspez.pleditor.generator.meta.generated.MetaEinzelfeld;
import de.statspez.pleditor.generator.parser.Dsb_Comment_Parser;
import de.statspez.pleditor.generator.parser.Dsb_FieldTypeParser;
import de.statspez.pleditor.generator.parser.ILParseException;
import de.statspez.pleditor.generator.parser.ParserChain;
import de.statspez.pleditor.generator.parser.Resolver;
import de.statspez.pleditor.generator.parser.SubParser;
import de.statspez.pleditor.generator.parser.SuperParser;
import java.util.Iterator;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class Dsb_GroupTypeParser
extends SubParser
implements SuperParser {
    private MetaEinzelfeld currentEf = null;
    private MetaDsbComps currentComps = null;
    private ParserChain parserChain = new ParserChain();
    private Dsb_FieldTypeParser feldParser;
    private Dsb_GroupTypeParser groupParser;
    private Dsb_Comment_Parser commentParser;
    private short stufe = 1;
    private int wiederholungen = -1;

    public Dsb_GroupTypeParser(SuperParser sParser, Resolver resolver) {
        super(sParser, resolver);
        this.feldParser = new Dsb_FieldTypeParser(this, resolver);
        this.feldParser.setStufe((short)(this.stufe + 1));
        this.parserChain.addParser(this.feldParser);
        this.commentParser = new Dsb_Comment_Parser(this, resolver);
        this.parserChain.addParser(this.commentParser);
    }

    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if ("http://www.destatis.de/schema/datml-ssp/1.0".equalsIgnoreCase(namespaceURI) && "groupType".equalsIgnoreCase(tag)) {
            return true;
        }
        return this.isEnabled();
    }

    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("groupType".equalsIgnoreCase(localName)) {
            if (this.isEnabled()) {
                if (this.groupParser == null) {
                    this.groupParser = new Dsb_GroupTypeParser(this, this.resolver());
                    this.groupParser.setStufe((short)(this.stufe + 1));
                    this.parserChain.addParser(this.groupParser);
                }
                if (!this.parserChain.startElement(namespaceURI, localName, qName, atts)) throw ILParseException.unknownTagException(localName);
                this.feldParser.setCanEnabled(false);
                this.commentParser.setCanEnabled(false);
                return;
            } else {
                this.enable();
                this.currentComps = new MetaDsbComps();
                this.currentEf = new MetaCustomEinzelfeld();
                this.currentEf.setStufenNr(this.stufe);
                this.currentComps.addToCompList(this.currentEf);
                this.handleAttributes(namespaceURI, localName, qName, atts);
            }
            return;
        } else {
            if (this.parserChain.startElement(namespaceURI, localName, qName, atts)) return;
            if (!this.canHandleTag(namespaceURI, localName)) throw ILParseException.unknownTagException(localName);
            this.handleAttributes(namespaceURI, localName, qName, atts);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (!this.parserChain.endElement(namespaceURI, localName, qName) && !this.handleTag(namespaceURI, localName, qName)) {
            throw ILParseException.unkownClosingTagException(localName);
        }
    }

    public MetaElement object() {
        return this.currentComps;
    }

    private void handleAttributes(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        String type = null;
        if ("groupType".equalsIgnoreCase(localName)) {
            String str = atts.getValue("name");
            if (str == null) {
                throw new ILParseException("Fuer groupType-Element ist kein Name definiert!");
            }
            this.currentEf.setName(str.trim());
            String id = atts.getValue("id");
            if (id != null && id.trim().length() > 0 && this.resolver().isUseIDasRef()) {
                this.currentEf.setId(id.trim());
            } else if (!this.resolver().isUseIDasRef()) {
                this.currentEf.setId(str);
            }
            str = atts.getValue("class");
            str = atts.getValue("occurrence");
            if (str == null) {
                throw new ILParseException("Fuer groupType-Element ist kein occurence-Attribut definiert!");
            }
            if (str.trim().length() == 0) {
                this.wiederholungen = 0;
            } else {
                try {
                    this.wiederholungen = Integer.parseInt(str.trim());
                }
                catch (NumberFormatException ex) {
                    throw new ILParseException("occurence-Attribut ist kein Zahl!");
                }
            }
            type = atts.getValue("type");
            if (type == null || type.trim().length() == 0) {
                str = this.wiederholungen == 1 ? "Str" : (this.wiederholungen == 500 ? "VKWG" : "Wfgr");
            } else if ("structur".equals(type)) {
                str = "Str";
            } else if ("group".equals(type)) {
                str = "Wfgr";
            } else if ("infinite-group".equals(type)) {
                str = "VKWG";
            }
            this.currentEf.setTyp(str);
        } else if ("location".equalsIgnoreCase(localName)) {
            int anz;
            String str = atts.getValue("absolute-offset");
            int von = 0;
            if (str != null) {
                try {
                    von = Integer.parseInt(str.trim());
                }
                catch (NumberFormatException nfe) {
                    throw new ILParseException("Von-Position ist keine Zahl!");
                }
                this.currentEf.setSatzVon(von);
            }
            if ((str = atts.getValue("length")) == null) {
                throw new ILParseException("Fuer die Gruppe ist keine Laenge definiert!");
            }
            try {
                anz = Integer.parseInt(str.trim());
                if (this.wiederholungen > 1 || this.wiederholungen == 1 && !"structur".equals(type)) {
                    this.currentEf.setTypIntern(this.wiederholungen + " * " + anz / this.wiederholungen);
                }
            }
            catch (NumberFormatException nfe) {
                throw new ILParseException("Laenge ist keine Zahl!");
            }
            this.currentEf.setSatzAnz(anz);
            this.currentEf.setSatzBis(von + anz - 1);
        } else if ("encoding".equalsIgnoreCase(localName)) {
            String str = atts.getValue("name");
            str = atts.getValue("class");
        }
    }

    private boolean handleTag(String namespaceURI, String localName, String qName) throws SAXException {
        boolean handled = true;
        String chars = this.superParser().charData().toString().trim();
        if ("annotation".equalsIgnoreCase(localName)) {
            this.currentEf.setInhalt(chars);
        } else if (!"location".equalsIgnoreCase(localName) && !"encoding".equalsIgnoreCase(localName)) {
            if ("groupType".equalsIgnoreCase(localName)) {
                this.disableAndNotify();
            } else {
                handled = false;
            }
        }
        return handled;
    }

    private boolean canHandleTag(String namespaceURI, String tag) {
        return "annotation".equalsIgnoreCase(tag) || "location".equalsIgnoreCase(tag) || "encoding".equalsIgnoreCase(tag);
    }

    public void notifyObjectAvailable(SubParser aParser) {
        if (aParser == this.feldParser) {
            MetaDsbFeld aFeld = (MetaDsbFeld)this.feldParser.object();
            this.currentComps.addToCompList(aFeld);
        } else if (aParser == this.groupParser) {
            MetaDsbComps aComps = (MetaDsbComps)this.groupParser.object();
            Iterator it = aComps.getCompList();
            while (it != null && it.hasNext()) {
                this.currentComps.addToCompList((MetaDsbFeld)it.next());
            }
            this.feldParser.setCanEnabled(true);
            this.commentParser.setCanEnabled(true);
        } else if (aParser == this.commentParser) {
            this.currentComps.addToCompList((MetaDsbFeld)this.commentParser.object());
        }
    }

    public StringBuffer charData() {
        return this.superParser().charData();
    }

    public String parentElement() {
        return this.superParser().parentElement();
    }

    public void setStufe(short s) {
        this.stufe = s;
        this.feldParser.setStufe((short)(s + 1));
    }

    public void error(AbstractMessage errorMessage) {
        this.superParser().error(errorMessage);
    }
}

