/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.parser;

import de.statspez.pleditor.generator.common.AbstractMessage;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.parser.ILParseException;
import de.statspez.pleditor.generator.parser.ParserChain;
import de.statspez.pleditor.generator.parser.Resolver;
import de.statspez.pleditor.generator.parser.SubParser;
import de.statspez.pleditor.generator.parser.SuperParser;
import de.statspez.pleditor.generator.parser.TimeParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DateTimeParser
extends SubParser
implements SuperParser {
    private MetaElement currentElement = null;
    private ParserChain parserChain = new ParserChain();
    private TimeParser timeParser = null;
    private String tag = null;
    StringBuffer buf = null;

    public DateTimeParser(SuperParser sParser, Resolver resolver) {
        super(sParser, resolver);
        this.timeParser = new TimeParser(this, resolver);
        this.parserChain.addParser(this.timeParser);
    }

    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if (this.tag != null && "http://www.destatis.de/schema/datml-ssp/1.0".equalsIgnoreCase(namespaceURI) && tag.equalsIgnoreCase(this.tag)) {
            return true;
        }
        return this.isEnabled();
    }

    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (this.tag == null) {
            throw new ILParseException("Es ist nicht angegeben was fuer Tag geparst werden soll.");
        }
        if (this.tag.equalsIgnoreCase(localName)) {
            this.enable();
            this.buf = new StringBuffer();
        } else if (!this.parserChain.startElement(namespaceURI, localName, qName, atts) && !this.canHandleTag(namespaceURI, localName)) {
            throw ILParseException.unknownTagException(localName);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.tag.equalsIgnoreCase(localName)) {
            this.disableAndNotify();
        } else if (!this.parserChain.endElement(namespaceURI, localName, qName) && !this.handleTag(namespaceURI, localName, qName)) {
            throw ILParseException.unkownClosingTagException(localName);
        }
    }

    public StringBuffer charData() {
        return this.superParser().charData();
    }

    public MetaElement object() {
        return this.currentElement;
    }

    public void notifyObjectAvailable(SubParser aParser) {
        if (this.timeParser == aParser) {
            this.buf.append(String.valueOf(this.timeParser.getHours()) + ":" + this.timeParser.getMinutes() + ":" + this.timeParser.getSeconds() + ":");
        }
    }

    public String parentElement() {
        return this.superParser().parentElement();
    }

    private boolean canHandleTag(String namespaceURI, String localName) {
        return "year".equalsIgnoreCase(localName) || "halfOfYear".equalsIgnoreCase(localName) || "quarterOfYear".equalsIgnoreCase(localName) || "month".equalsIgnoreCase(localName) || "day".equalsIgnoreCase(localName) || "UTCTime".equalsIgnoreCase(localName) || "dayOfYear".equalsIgnoreCase(localName) || "weekOfYear".equalsIgnoreCase(localName) || "dayOfWeek".equalsIgnoreCase(localName) || "hours".equalsIgnoreCase(localName) || "minutes".equalsIgnoreCase(localName) || "seconds".equalsIgnoreCase(localName) || "fractionSeconds".equalsIgnoreCase(localName);
    }

    public void setCurrentElement(MetaElement objekt) {
        this.currentElement = objekt;
        this.timeParser.setCurrentElement(this.currentElement);
    }

    private boolean handleTag(String namespaceURI, String localName, String qName) {
        String chars = this.superParser().charData().toString().trim();
        if ("year".equalsIgnoreCase(localName)) {
            this.buf.append(chars);
            return true;
        }
        if ("halfOfYear".equalsIgnoreCase(localName) || "quarterOfYear".equalsIgnoreCase(localName) || "month".equalsIgnoreCase(localName) || "day".equalsIgnoreCase(localName) || "UTCTime".equalsIgnoreCase(localName) || "dayOfYear".equalsIgnoreCase(localName) || "weekOfYear".equalsIgnoreCase(localName) || "dayOfWeek".equalsIgnoreCase(localName) || "hours".equalsIgnoreCase(localName) || "minutes".equalsIgnoreCase(localName) || "seconds".equalsIgnoreCase(localName) || "fractionSeconds".equalsIgnoreCase(localName)) {
            this.buf.append(chars);
            return true;
        }
        return false;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String string) {
        this.tag = string;
    }

    public String gibDateTimeValue() {
        return this.buf.toString();
    }

    public void error(AbstractMessage errorMessage) {
        this.superParser().error(errorMessage);
    }
}

