/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.parser;

import de.statspez.pleditor.generator.common.AbstractMessage;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.generated.MetaDsbComps;
import de.statspez.pleditor.generator.meta.generated.MetaDsbObjekt;
import de.statspez.pleditor.generator.meta.generated.MetaSatzart;
import de.statspez.pleditor.generator.parser.ContextParser;
import de.statspez.pleditor.generator.parser.Dsb_RecordHeaderTypeParser;
import de.statspez.pleditor.generator.parser.Dsb_RecordSelectorsParser;
import de.statspez.pleditor.generator.parser.Dsb_RecordTypeParser;
import de.statspez.pleditor.generator.parser.ILParseException;
import de.statspez.pleditor.generator.parser.ObjectContextParser;
import de.statspez.pleditor.generator.parser.ParserChain;
import de.statspez.pleditor.generator.parser.PropertiesParser;
import de.statspez.pleditor.generator.parser.Resolver;
import de.statspez.pleditor.generator.parser.SubParser;
import de.statspez.pleditor.generator.parser.SuperParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DataSetTypeParser
extends SubParser
implements SuperParser {
    private MetaDsbObjekt currentDsb = null;
    private ParserChain parserChain = new ParserChain();
    private Dsb_RecordTypeParser recordParser = null;
    private Dsb_RecordHeaderTypeParser headerParser = null;
    private PropertiesParser propertiesParser = null;
    private ObjectContextParser objectContextParser = null;
    private Dsb_RecordSelectorsParser recordSelectorsParser = null;
    private ContextParser contextParser = null;
    private boolean mitSatzarten = false;

    public DataSetTypeParser(SuperParser sParser, Resolver resolver) {
        super(sParser, resolver);
        this.contextParser = new ContextParser(this, resolver);
        this.parserChain.addParser(this.contextParser);
        this.propertiesParser = new PropertiesParser(this, resolver);
        this.parserChain.addParser(this.propertiesParser);
        this.objectContextParser = new ObjectContextParser(this, resolver);
        this.parserChain.addParser(this.objectContextParser);
        this.recordParser = new Dsb_RecordTypeParser(this, resolver);
        this.parserChain.addParser(this.recordParser);
        this.headerParser = new Dsb_RecordHeaderTypeParser(this, resolver);
        this.parserChain.addParser(this.headerParser);
        this.recordSelectorsParser = new Dsb_RecordSelectorsParser(this, resolver);
        this.parserChain.addParser(this.recordSelectorsParser);
    }

    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if ("http://www.destatis.de/schema/datml-ssp/1.0".equalsIgnoreCase(namespaceURI) && "dataSetType".equalsIgnoreCase(tag)) {
            return true;
        }
        return this.isEnabled();
    }

    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("dataSetType".equalsIgnoreCase(localName)) {
            this.enable();
            this.mitSatzarten = false;
            this.recordParser.setSatzartFlag(this.mitSatzarten);
            this.currentDsb = new MetaDsbObjekt();
            this.currentDsb.setComps(new MetaDsbComps());
            this.setDsbOfSubParsers(this.currentDsb);
            this.handleAttributes(namespaceURI, localName, qName, atts);
        } else {
            if ("recordHeaderType".equalsIgnoreCase(localName)) {
                this.mitSatzarten = true;
                this.recordParser.setSatzartFlag(this.mitSatzarten);
                this.currentDsb.setAspBit((short)1);
            }
            if (!this.parserChain.startElement(namespaceURI, localName, qName, atts)) {
                if (this.canHandleTag(namespaceURI, localName)) {
                    this.handleAttributes(namespaceURI, localName, qName, atts);
                } else {
                    throw ILParseException.unknownTagException(localName);
                }
            }
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("dataSetType".equalsIgnoreCase(localName)) {
            this.disableAndNotify();
        } else if (!this.parserChain.endElement(namespaceURI, localName, qName) && !this.handleTag(namespaceURI, localName, qName)) {
            throw ILParseException.unkownClosingTagException(localName);
        }
    }

    public MetaElement object() {
        return this.currentDsb;
    }

    public void notifyObjectAvailable(SubParser aParser) {
        if (aParser == this.recordParser && this.recordParser.isSatzartFlag()) {
            MetaSatzart sa = (MetaSatzart)this.recordParser.object();
            this.currentDsb.getComps().addToSatzList(sa);
            if (this.currentDsb.getSatzlaenge() < sa.getSatzlaenge()) {
                this.currentDsb.setSatzlaenge(sa.getSatzlaenge());
            }
        }
    }

    public StringBuffer charData() {
        return this.superParser().charData();
    }

    public String parentElement() {
        return this.superParser().parentElement();
    }

    private void handleAttributes(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("dataSetType".equalsIgnoreCase(localName)) {
            String name = atts.getValue("name");
            if (name == null) {
                throw new ILParseException("Fuer die Datensatzbeschreibung ist kein Name definiert!");
            }
            this.currentDsb.setName(name.trim());
            String str = atts.getValue("class");
            str = atts.getValue("id");
            if (str != null && str.trim().length() > 0 && this.resolver().isUseIDasRef()) {
                this.currentDsb.setId(str.trim());
            } else {
                this.currentDsb.setId(name);
            }
            String state = atts.getValue("state");
            if (state != null && state.trim().equals("approved")) {
                this.currentDsb.setFreigabeStatus((short)1);
            }
        } else if ("encoding".equalsIgnoreCase(localName)) {
            String str = atts.getValue("name");
            str = atts.getValue("class");
        } else if ("annotation".equalsIgnoreCase(localName)) {
            String string = atts.getValue("class");
        }
    }

    private boolean handleTag(String namespaceURI, String localName, String qName) {
        boolean handled = false;
        String chars = this.superParser().charData().toString().trim();
        if ("encoding".equalsIgnoreCase(localName)) {
            handled = true;
        } else if ("annotation".equalsIgnoreCase(localName)) {
            handled = true;
        } else if ("technicalProperties".equalsIgnoreCase(localName)) {
            handled = true;
        } else if ("useProperties".equalsIgnoreCase(localName)) {
            handled = true;
        } else if ("aspName".equalsIgnoreCase(localName)) {
            this.currentDsb.setAspName(chars);
            handled = true;
        } else if ("index".equalsIgnoreCase(localName)) {
            this.currentDsb.setIndex(chars);
            handled = true;
        } else if ("fileType".equalsIgnoreCase(localName)) {
            boolean zahl = false;
            try {
                this.currentDsb.setSatztyp((short)Integer.parseInt(chars));
            }
            catch (Exception e) {
                this.currentDsb.setSatztyp((short)0);
                e.printStackTrace();
            }
            handled = true;
        } else if ("dataType".equalsIgnoreCase(localName)) {
            try {
                this.currentDsb.setDatentyp((short)Integer.parseInt(chars));
            }
            catch (Exception e) {
                this.currentDsb.setDatentyp((short)1);
                e.printStackTrace();
            }
            handled = true;
        } else if ("recordFormat".equalsIgnoreCase(localName)) {
            try {
                this.currentDsb.setSatzformat((short)Integer.parseInt(chars));
            }
            catch (Exception e) {
                this.currentDsb.setSatzformat((short)1);
                e.printStackTrace();
            }
            handled = true;
        } else if ("internalState".equalsIgnoreCase(localName)) {
            try {
                this.currentDsb.setDsbStatus((short)Integer.parseInt(chars));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            handled = true;
        } else if ("fieldTyps".equalsIgnoreCase(localName)) {
            try {
                this.currentDsb.setDsbTypen((short)Integer.parseInt(chars));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            handled = true;
        } else if ("author".equalsIgnoreCase(localName)) {
            this.currentDsb.setBearbeiter(chars);
            handled = true;
        } else if ("currentName".equalsIgnoreCase(localName)) {
            this.currentDsb.setDsName(chars);
            handled = true;
        } else if ("firstName".equalsIgnoreCase(localName)) {
            this.currentDsb.setErsteller(chars);
            handled = true;
        } else if ("region".equalsIgnoreCase(localName)) {
            this.currentDsb.setLand(chars);
            handled = true;
        } else if ("referencePeriod".equalsIgnoreCase(localName)) {
            this.currentDsb.setZeitraum(chars);
            handled = true;
        } else if ("state".equalsIgnoreCase(localName)) {
            this.currentDsb.setStand(chars);
            handled = true;
        } else if ("jobDescription".equalsIgnoreCase(localName)) {
            this.currentDsb.setAufgabe(chars);
            handled = true;
        } else if ("sort".equalsIgnoreCase(localName)) {
            this.currentDsb.setSort(chars);
            handled = true;
        }
        return handled;
    }

    private void setDsbOfSubParsers(MetaDsbObjekt _dsb) {
        this.recordParser.setCurrentDsb(_dsb);
        this.headerParser.setCurrentDsb(_dsb);
        this.propertiesParser.setCurrentElement(_dsb);
        this.objectContextParser.setCurrentElement(_dsb);
        this.recordSelectorsParser.setCurrentDsb(_dsb);
    }

    private boolean canHandleTag(String namespaceURI, String tag) {
        return "http://www.destatis.de/schema/datml-ssp/1.0".equalsIgnoreCase(namespaceURI) && ("encoding".equalsIgnoreCase(tag) || "annotation".equalsIgnoreCase(tag) || "dataSetType".equalsIgnoreCase(tag) || "technicalProperties".equalsIgnoreCase(tag) || "useProperties".equalsIgnoreCase(tag) || "aspName".equalsIgnoreCase(tag) || "index".equalsIgnoreCase(tag) || "fileType".equalsIgnoreCase(tag) || "dataType".equalsIgnoreCase(tag) || "internalState".equalsIgnoreCase(tag) || "fieldTyps".equalsIgnoreCase(tag) || "author".equalsIgnoreCase(tag) || "currentName".equalsIgnoreCase(tag) || "firstName".equalsIgnoreCase(tag) || "region".equalsIgnoreCase(tag) || "referencePeriod".equalsIgnoreCase(tag) || "state".equalsIgnoreCase(tag) || "jobDescription".equalsIgnoreCase(tag) || "recordFormat".equalsIgnoreCase(tag) || "sort".equalsIgnoreCase(tag));
    }

    public void error(AbstractMessage errorMessage) {
        this.superParser().error(errorMessage);
    }
}

