/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.parser;

import de.statspez.pleditor.generator.common.AbstractMessage;
import de.statspez.pleditor.generator.meta.MetaCustomAuspraegung;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.generated.MetaAuspraegung;
import de.statspez.pleditor.generator.meta.generated.MetaAuspraegungsgruppe;
import de.statspez.pleditor.generator.meta.generated.MetaAuspraegungsgruppeComps;
import de.statspez.pleditor.generator.parser.AuspraegungParser;
import de.statspez.pleditor.generator.parser.ILParseException;
import de.statspez.pleditor.generator.parser.ObjectContextParser;
import de.statspez.pleditor.generator.parser.ParserChain;
import de.statspez.pleditor.generator.parser.PropertiesParser;
import de.statspez.pleditor.generator.parser.Resolver;
import de.statspez.pleditor.generator.parser.SubParser;
import de.statspez.pleditor.generator.parser.SuperParser;
import java.util.Iterator;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AuspraegungsgruppeParser
extends SubParser
implements SuperParser {
    private MetaAuspraegungsgruppe currentAg = null;
    private ParserChain parserChain = new ParserChain();
    private PropertiesParser propertiesParser = null;
    private ObjectContextParser objectContextParser = null;
    private AuspraegungParser auspraegungParser;

    public AuspraegungsgruppeParser(SuperParser sParser, Resolver resolver) {
        super(sParser, resolver);
        this.propertiesParser = new PropertiesParser(this, resolver);
        this.parserChain.addParser(this.propertiesParser);
        this.objectContextParser = new ObjectContextParser(this, resolver);
        this.parserChain.addParser(this.objectContextParser);
        this.auspraegungParser = new AuspraegungParser(this, resolver);
        this.parserChain.addParser(this.auspraegungParser);
    }

    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if ("http://www.werum.de/pl-editor".equalsIgnoreCase(namespaceURI) && "classification".equalsIgnoreCase(tag)) {
            return true;
        }
        return this.isEnabled();
    }

    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("classification".equalsIgnoreCase(localName)) {
            this.enable();
            this.currentAg = new MetaAuspraegungsgruppe();
            this.currentAg.setAuspraegungsComps(new MetaAuspraegungsgruppeComps());
            this.propertiesParser.setCurrentElement(this.currentAg);
            this.objectContextParser.setCurrentElement(this.currentAg);
        } else if (!this.parserChain.startElement(namespaceURI, localName, qName, atts)) {
            throw ILParseException.unknownTagException(localName);
        }
        this.handleAttributes(namespaceURI, localName, qName, atts);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("classification".equalsIgnoreCase(localName)) {
            this.setGroupInChildren(this.currentAg.getAuspraegungsComps().getAuspraegungen());
            this.disableAndNotify();
        } else if (!this.parserChain.endElement(namespaceURI, localName, qName) && !this.handleTag(namespaceURI, localName, qName)) {
            throw ILParseException.unknownTagException(localName);
        }
    }

    public MetaElement object() {
        return this.currentAg;
    }

    public void notifyObjectAvailable(SubParser aParser) {
        if (aParser == this.auspraegungParser) {
            MetaAuspraegung aAuspraegung = (MetaAuspraegung)this.auspraegungParser.object();
            this.currentAg.getAuspraegungsComps().addToAuspraegungen(aAuspraegung);
        }
    }

    public StringBuffer charData() {
        return this.superParser().charData();
    }

    public String parentElement() {
        return this.superParser().parentElement();
    }

    private void handleAttributes(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("classification".equalsIgnoreCase(localName)) {
            String name = atts.getValue("name");
            if (name == null) {
                throw new ILParseException("Fuer die Auspraegungsgruppe ist kein Name definiert!");
            }
            this.currentAg.setName(name.trim());
            String str = atts.getValue("id");
            if (str != null && str.trim().length() > 0 && this.resolver().isUseIDasRef()) {
                this.currentAg.setId(str.trim());
            } else {
                this.currentAg.setId(name);
            }
            String state = atts.getValue("state");
            if (state != null && state.trim().equals("approved")) {
                this.currentAg.setFreigabeStatus((short)1);
            }
        }
    }

    private boolean handleTag(String namespaceURI, String localName, String qName) {
        return false;
    }

    private void setGroupInChildren(Iterator it) {
        while (it.hasNext()) {
            MetaCustomAuspraegung classi = (MetaCustomAuspraegung)it.next();
            classi.setGroup(this.currentAg);
            if (classi.getGroup().getAuspraegungsComps().sizeOfAuspraegungen() <= 0) continue;
            this.setGroupInChildren(classi.getAuspraegungen());
        }
    }

    public void error(AbstractMessage errorMessage) {
        this.superParser().error(errorMessage);
    }
}

