/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.interpreter;

import de.statspez.pleditor.generator.codegen.support.CodegenUtil;
import de.statspez.pleditor.generator.interpreter.ClassificationFactory;
import de.statspez.pleditor.generator.interpreter.Console;
import de.statspez.pleditor.generator.interpreter.DefaultClassificationFactory;
import de.statspez.pleditor.generator.interpreter.DefaultProgramFactory;
import de.statspez.pleditor.generator.interpreter.FieldDescriptorFactory;
import de.statspez.pleditor.generator.interpreter.InterpreterListener;
import de.statspez.pleditor.generator.interpreter.InterpreterPlausi;
import de.statspez.pleditor.generator.interpreter.MaterialNameResolver;
import de.statspez.pleditor.generator.interpreter.ProgramDescriptor;
import de.statspez.pleditor.generator.interpreter.ProgramFactory;
import de.statspez.pleditor.generator.interpreter.ProgramInterpreter;
import de.statspez.pleditor.generator.interpreter.ProgramStackInfo;
import de.statspez.pleditor.generator.interpreter.SimpleMaterialNameResolver;
import de.statspez.pleditor.generator.interpreter.StringFieldDescriptiorFactory;
import de.statspez.pleditor.generator.meta.MetaCustomMerkmal;
import de.statspez.pleditor.generator.meta.MetaCustomPruefung;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.generated.MetaPLPruefung;
import de.statspez.pleditor.generator.meta.generated.MetaStatspezObjekt;
import de.statspez.pleditor.generator.runtime.ClassificationGroup;
import de.statspez.pleditor.generator.runtime.FeldDeskriptor;
import de.statspez.pleditor.generator.runtime.FeldDeskriptorExt;
import de.statspez.pleditor.generator.runtime.FeldDeskriptorImpl;
import de.statspez.pleditor.generator.runtime.Material;
import de.statspez.pleditor.generator.runtime.NilValue;
import de.statspez.pleditor.generator.runtime.PlausiRuntimeContext;
import de.statspez.pleditor.generator.runtime.Value;
import de.statspez.pleditor.generator.runtime.ValueFactory;
import de.statspez.pleditor.generator.runtime.plausi.FeldDeskriptorInterface;
import de.statspez.pleditor.generator.runtime.plausi.PlausiFehler;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class InterpreterContext
extends PlausiRuntimeContext {
    private static final String KEY_PREFIX = "##";
    private static final String SCOPE_TYPE_KEY = "##SCOPE_TYPE";
    private static final String SCOPE_TYPE_ROOT = "ROOT";
    private static final String SCOPE_TYPE_PROGRAM = "PROGRAM";
    private static final String SCOPE_TYPE_BLOCK = "BLOCK";
    private static final String CURRENT_STRUCTURE_KEY = "##CURRENT_STRUCTURE";
    private static final String CURRENT_PROGRAM_DESCRIPTOR_KEY = "##CURRENT_PROGRAM_DESCRIPTOR";
    private static final String CURRENT_LINE_KEY = "##CURRENT_LINE";
    private static final String CURRENT_REF_FIELDS_KEY = "##CURRENT_REF_FIELDS";
    private FieldDescriptorFactory fieldDescriptorFactory = new StringFieldDescriptiorFactory();
    private ProgramFactory programFactory = new DefaultProgramFactory();
    private ClassificationFactory classificationFactory = new DefaultClassificationFactory();
    private Map materialFieldDescriptorFactories = new HashMap();
    private ValueFactory privateValueFactory = ValueFactory.instance();
    private Stack scopeStack = new Stack();
    private List plausiErrors = new ArrayList();
    private int currentScopeLevel = 0;
    private Console console;
    private List listeners;
    private MaterialNameResolver materialNameResolver = null;

    public InterpreterContext() {
        super(new InterpreterPlausi());
        this.scopeStack.add(this.createScope(SCOPE_TYPE_ROOT));
        this.setConsole(System.out);
        this.listeners = new ArrayList();
        this.materialNameResolver = new SimpleMaterialNameResolver();
    }

    public void setFieldDescriptorFactory(FieldDescriptorFactory fieldDescriptorFactory) {
        this.fieldDescriptorFactory = fieldDescriptorFactory;
    }

    public FieldDescriptorFactory getFieldDescriptorFactory() {
        return this.fieldDescriptorFactory;
    }

    public MaterialNameResolver getMaterialNameResolver() {
        return this.materialNameResolver;
    }

    public void setMaterialNameResolver(MaterialNameResolver materialNameResolver) {
        this.materialNameResolver = materialNameResolver;
    }

    public void setProgramFactory(ProgramFactory programFactory) {
        this.programFactory = programFactory;
    }

    public ProgramFactory getProgramFactory() {
        return this.programFactory;
    }

    public void setClassificationFactory(ClassificationFactory classificationFactory) {
        this.classificationFactory = classificationFactory;
    }

    public ClassificationFactory getClassificationFactory() {
        return this.classificationFactory;
    }

    public boolean isClassificationRegistered(String reference) {
        return this.classificationFactory.isClassificationRegistered(reference);
    }

    public void registerClassificationGroup(String name, ClassificationGroup classificationGroup) {
        this.classificationFactory.registerClassificationGroup(name, classificationGroup);
    }

    public void setMaterialFeldDescriptorFactory(String material, FieldDescriptorFactory fieldDescriptorFactory) {
        this.materialFieldDescriptorFactories.put(material, fieldDescriptorFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldDescriptorFactory getMaterialFieldDescriptorFactory(String material) {
        FieldDescriptorFactory materialDescriptorFactory = (FieldDescriptorFactory)this.materialFieldDescriptorFactories.get(material);
        if (materialDescriptorFactory == null) {
            Map map = this.materialFieldDescriptorFactories;
            synchronized (map) {
                if (materialDescriptorFactory == null) {
                    materialDescriptorFactory = new StringFieldDescriptiorFactory();
                    this.materialFieldDescriptorFactories.put(material, materialDescriptorFactory);
                }
            }
        }
        return materialDescriptorFactory;
    }

    public void addListener(InterpreterListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(InterpreterListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public ValueFactory valueFactory() {
        return this.privateValueFactory;
    }

    public void enterProgram(FeldDeskriptorImpl currentStrucure) {
        this.enterProgram(currentStrucure, null);
    }

    public void enterProgram(FeldDeskriptorImpl currentStrucure, ProgramDescriptor programDescriptor) {
        ++this.currentScopeLevel;
        HashMap scope = this.createScope(SCOPE_TYPE_PROGRAM);
        if (currentStrucure != null) {
            scope.put(CURRENT_STRUCTURE_KEY, currentStrucure);
        }
        if (programDescriptor != null) {
            scope.put(CURRENT_PROGRAM_DESCRIPTOR_KEY, programDescriptor);
        }
        this.scopeStack.push(scope);
        if (programDescriptor != null) {
            if (programDescriptor.getParameters() != null && programDescriptor.handleParametersAsLocalVars()) {
                String[] parameters = programDescriptor.getParameters();
                int i = 0;
                while (i < parameters.length) {
                    this.declareVariable(parameters[i]);
                    ++i;
                }
            }
            if (programDescriptor.getPlausiElement() != null && programDescriptor.getPlausiElement() instanceof MetaPLPruefung) {
                scope.put(CURRENT_REF_FIELDS_KEY, new ArrayList());
            }
        }
    }

    public void enterBlock() {
        ++this.currentScopeLevel;
        this.scopeStack.push(this.createScope(SCOPE_TYPE_BLOCK));
    }

    public void leaveScope() {
        --this.currentScopeLevel;
        this.scopeStack.pop();
    }

    public FeldDeskriptorImpl getCurrentStructure() {
        FeldDeskriptorImpl currentStructure = null;
        int i = this.scopeStack.size() - 1;
        while (i >= 0) {
            HashMap scope = (HashMap)this.scopeStack.get(i);
            if (scope.get(SCOPE_TYPE_KEY) == SCOPE_TYPE_PROGRAM && scope.containsKey(CURRENT_STRUCTURE_KEY)) {
                currentStructure = (FeldDeskriptorImpl)scope.get(CURRENT_STRUCTURE_KEY);
                break;
            }
            --i;
        }
        return currentStructure;
    }

    public ProgramDescriptor getCurrentProgramDescriptor() {
        ProgramDescriptor currentProgramDescriptor = null;
        int i = this.scopeStack.size() - 1;
        while (i >= 0) {
            HashMap scope = (HashMap)this.scopeStack.get(i);
            if (scope.get(SCOPE_TYPE_KEY) == SCOPE_TYPE_PROGRAM && scope.containsKey(CURRENT_PROGRAM_DESCRIPTOR_KEY)) {
                currentProgramDescriptor = (ProgramDescriptor)scope.get(CURRENT_PROGRAM_DESCRIPTOR_KEY);
                break;
            }
            --i;
        }
        return currentProgramDescriptor;
    }

    public Integer getCurrentLine() {
        Integer currentLine = null;
        int i = this.scopeStack.size() - 1;
        while (i >= 0) {
            HashMap scope = (HashMap)this.scopeStack.get(i);
            if (scope.containsKey(CURRENT_LINE_KEY)) {
                currentLine = (Integer)scope.get(CURRENT_LINE_KEY);
                break;
            }
            if (scope.get(SCOPE_TYPE_KEY) == SCOPE_TYPE_PROGRAM) break;
            --i;
        }
        return currentLine;
    }

    public ProgramStackInfo[] getCurrentStack() {
        ArrayList<ProgramStackInfo> stack = new ArrayList<ProgramStackInfo>();
        Integer line = null;
        int i = this.scopeStack.size() - 1;
        while (i >= 0) {
            HashMap scope = (HashMap)this.scopeStack.get(i);
            if (line == null && scope.containsKey(CURRENT_LINE_KEY)) {
                line = (Integer)scope.get(CURRENT_LINE_KEY);
            }
            if (scope.get(SCOPE_TYPE_KEY) == SCOPE_TYPE_PROGRAM) {
                FeldDeskriptorImpl structure = null;
                int j = i;
                while (j >= 0) {
                    HashMap subScope = (HashMap)this.scopeStack.get(j);
                    if (subScope.get(SCOPE_TYPE_KEY) == SCOPE_TYPE_PROGRAM && subScope.containsKey(CURRENT_STRUCTURE_KEY)) {
                        structure = (FeldDeskriptorImpl)subScope.get(CURRENT_STRUCTURE_KEY);
                    }
                    --j;
                }
                ProgramDescriptor programDescriptor = scope.containsKey(CURRENT_PROGRAM_DESCRIPTOR_KEY) ? (ProgramDescriptor)scope.get(CURRENT_PROGRAM_DESCRIPTOR_KEY) : null;
                stack.add(new ProgramStackInfo(structure, programDescriptor, line));
                line = null;
            }
            --i;
        }
        return stack.toArray(new ProgramStackInfo[stack.size()]);
    }

    public List getCurrentRefFields() {
        List currentRefFields = null;
        int i = this.scopeStack.size() - 1;
        while (i >= 0) {
            HashMap scope = (HashMap)this.scopeStack.get(i);
            if (scope.containsKey(CURRENT_REF_FIELDS_KEY)) {
                currentRefFields = (List)scope.get(CURRENT_REF_FIELDS_KEY);
                break;
            }
            --i;
        }
        return currentRefFields;
    }

    public PlausiFehler[] getPlausiErrors() {
        return this.plausiErrors.toArray(new PlausiFehler[this.plausiErrors.size()]);
    }

    public void declareVariable(String name) {
        this.declareVariable(name, null);
    }

    public void declareVariable(String name, int[] indicies) {
        if (this.isVariableDeclared(name)) {
            throw new RuntimeException("Die Variable " + name + " ist in diesem G\u00fcltigkeitsbereich bereits definiert.");
        }
        HashMap values = this.getCurrentScope();
        values.put(name, NilValue.instance());
        if (indicies != null && indicies.length > 0) {
            int i = 0;
            while (i < indicies.length) {
                values.put(String.valueOf(name) + "[" + indicies[i] + "]", NilValue.instance());
                ++i;
            }
        }
    }

    public boolean isVariableDeclared(String name) {
        return this.findScopeFromVariable(name) != null;
    }

    public String[] getDeclaredVarialbles() {
        ArrayList<String> declaredVariables = new ArrayList<String>();
        int i = 0;
        while (i < this.scopeStack.size()) {
            HashMap scope = (HashMap)this.scopeStack.get(i);
            Iterator keys = scope.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                if (key.startsWith(KEY_PREFIX)) continue;
                declaredVariables.add(key);
            }
            ++i;
        }
        return declaredVariables.toArray(new String[declaredVariables.size()]);
    }

    public void setVariableValue(String name, Value value) {
        this.setVariableValue(name, null, value);
    }

    public void setVariableValue(String name, int[] indicies, Value value) {
        HashMap values = this.findScopeFromVariable(name);
        if (values == null) {
            throw new RuntimeException("Die Variable " + name + " ist in diesem G\u00fcltigkeitsbereich nicht definiert.");
        }
        StringBuffer key = new StringBuffer(name);
        if (indicies != null && indicies.length > 0) {
            int i = 0;
            while (i < indicies.length) {
                key.append("[");
                key.append(indicies[i]);
                key.append("]");
                ++i;
            }
        }
        boolean setVariable = true;
        if (value != null && value instanceof Material) {
            Material materialValue = (Material)value;
            Value firstValue = materialValue.firstValue();
            boolean bl = setVariable = firstValue != null && !(materialValue.firstValue() instanceof NilValue);
        }
        if (setVariable) {
            values.put(key.toString(), value);
        }
    }

    public Value getVariableValue(String name) {
        return this.getVariableValue(name, null);
    }

    public Value getVariableValue(String name, int[] indicies) {
        HashMap values = this.findScopeFromVariable(name);
        if (values == null) {
            throw new RuntimeException("Die Variable " + name + " ist in diesem G\u00fcltigkeitsbereich nicht definiert.");
        }
        StringBuffer key = new StringBuffer(name);
        if (indicies != null && indicies.length > 0) {
            int j = 0;
            while (j < indicies.length) {
                key.append("[");
                key.append(indicies[j]);
                key.append("]");
                ++j;
            }
        }
        return (Value)values.get(key.toString());
    }

    public void incrementVariableValue(String name, long increment) {
        this.incrementVariableValue(name, null, increment);
    }

    public void incrementVariableValue(String name, int[] indicies, long increment) {
        Value value = this.getVariableValue(name, indicies);
        this.setVariableValue(name, indicies, this.valueFactory().valueFor(value.asDouble() + (double)increment));
    }

    public void setConsole(final PrintStream console) {
        this.setConsole(new Console(){

            public void println() {
                console.println();
            }

            public void print(Value value) {
                console.print(value);
            }
        });
    }

    public void setConsole(final BufferedWriter writer) {
        this.setConsole(new Console(){

            public void println() {
                try {
                    writer.newLine();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            public void print(Value value) {
                try {
                    writer.write(value != null ? value.toString() : "null");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public void setConsole(Console console) {
        this.console = console;
    }

    public Console getConsole() {
        return this.console;
    }

    public void setCurrentLine(int line) {
        HashMap currentScope = this.getCurrentScope();
        if (currentScope != null) {
            currentScope.put(CURRENT_LINE_KEY, new Integer(line));
        }
        if (!this.listeners.isEmpty()) {
            Iterator iter = this.listeners.iterator();
            while (iter.hasNext()) {
                ((InterpreterListener)iter.next()).lineReached(line);
            }
        }
    }

    public void noteReferencedField(FeldDeskriptorInterface field) {
        if (field != null) {
            List refFields;
            FeldDeskriptor fieldDescriptor;
            boolean simpleField = true;
            if (field instanceof FeldDeskriptorImpl && (fieldDescriptor = ((FeldDeskriptorImpl)field).getFeldDeskriptor()) != null) {
                FeldDeskriptorExt fieldDescriptorExt;
                if (fieldDescriptor.getFeldTyp() == 7) {
                    simpleField = false;
                } else if (fieldDescriptor instanceof FeldDeskriptorExt && (fieldDescriptorExt = (FeldDeskriptorExt)fieldDescriptor).getFeldBezeichnung() != null && fieldDescriptorExt.getFeldBezeichnung().equals("###PL-VARIABLE###")) {
                    simpleField = false;
                }
            }
            if (simpleField && (refFields = this.getCurrentRefFields()) != null) {
                boolean containsField = false;
                String fieldName = this.getFieldName(field);
                Iterator iter = refFields.iterator();
                while (iter.hasNext()) {
                    FeldDeskriptorInterface refField = (FeldDeskriptorInterface)iter.next();
                    String refFieldName = this.getFieldName(refField);
                    if (!refFieldName.equals(fieldName)) continue;
                    containsField = true;
                    break;
                }
                if (!containsField) {
                    refFields.add(field);
                }
            }
        }
    }

    private String getFieldName(FeldDeskriptorInterface field) {
        StringBuffer result = new StringBuffer();
        if (field.getVorgaenger() != null) {
            result.append(this.getFieldName(field.getVorgaenger()));
            result.append('.');
        }
        result.append(field.getFeldNameTB());
        if (field.getIndizes() != null && field.getIndizes().length > 0) {
            int i = 0;
            while (i < field.getIndizes().length) {
                result.append('[');
                result.append(field.getIndizes()[i]);
                result.append(']');
                ++i;
            }
        }
        return result.toString();
    }

    public void notePlausiError(int errorNumber, Throwable e) {
        this.notePlausiError(null, errorNumber, e);
    }

    public void notePlausiError(FeldDeskriptorInterface field, int errorNumber, Throwable e) {
        ProgramDescriptor programDescriptor = this.getCurrentProgramDescriptor();
        FeldDeskriptorInterface refField = field;
        List refFields = this.getCurrentRefFields();
        if (refField == null && programDescriptor != null) {
            refField = programDescriptor.getRefField();
        }
        PlausiFehler error = new PlausiFehler();
        error.setFehlerInfoTyp(errorNumber);
        error.setReferenzFeld(refField);
        if (e != null) {
            error.setLaufzeitException(e);
            error.setLaufzeitFehlerAufgetreten(true);
        }
        if (programDescriptor != null && programDescriptor.getPlausiElement() != null) {
            StringBuffer errorId = new StringBuffer();
            if (refField != null) {
                FeldDeskriptorInterface currentField = refField;
                while (currentField != null) {
                    if (errorId.length() > 0) {
                        errorId.insert(0, '.');
                    }
                    if (currentField.getIndizes() != null) {
                        int i = currentField.getIndizes().length - 1;
                        while (i >= 0) {
                            errorId.insert(0, ']');
                            errorId.insert(0, currentField.getIndizes()[i]);
                            errorId.insert(0, '[');
                            --i;
                        }
                    }
                    errorId.insert(0, currentField.getFeldNameTB());
                    currentField = currentField.getVorgaenger();
                }
            }
            errorId.append('#');
            errorId.append(((MetaStatspezObjekt)programDescriptor.getPlausiElement()).getName());
            error.setFehlerId(errorId.toString());
            if (programDescriptor.getPlausiElement() instanceof MetaCustomMerkmal) {
                MetaCustomMerkmal merkmal = (MetaCustomMerkmal)programDescriptor.getPlausiElement();
                error.setFehlerSchluessel(merkmal.getName());
                error.setFehlerArt(1);
                error.setFehlerGewicht(9);
                error.setFehlertextKurz(this.resolveErrorMessage(merkmal.getFehlertextKurz(), merkmal.getFehlerTextKurzProgram()));
                error.setFehlertextLang(this.resolveErrorMessage(merkmal.getFehlertextLang(), merkmal.getFehlerTextLangProgram()));
                error.setFehlerKorrekturhinweis(this.resolveErrorMessage(merkmal.getKorrekturhinweis(), merkmal.getKorrekturhinweisProgram()));
                error.setWertebereich(CodegenUtil.getValueSpaceAsString(merkmal));
                error.setWertlaenge(merkmal.getLaenge());
                error.setMaske(merkmal.getMaske());
                error.setMerkmalsbezeichnung(merkmal.getBezeichnung());
                if (refField != null) {
                    error.setFelder(new FeldDeskriptorInterface[]{refField});
                }
            } else if (programDescriptor.getPlausiElement() instanceof MetaCustomPruefung) {
                MetaCustomPruefung pruefeung = (MetaCustomPruefung)programDescriptor.getPlausiElement();
                error.setFehlerSchluessel(pruefeung.getName());
                error.setFehlerArt(pruefeung.getPruefungsart());
                error.setFehlerGewicht(pruefeung.getFehlergewicht());
                error.setFehlertextKurz(this.resolveErrorMessage(pruefeung.getFehlertextKurz(), pruefeung.getFehlerTextKurzProgram()));
                error.setFehlertextLang(this.resolveErrorMessage(pruefeung.getFehlertextLang(), pruefeung.getFehlerTextLangProgram()));
                error.setFehlerKorrekturhinweis(this.resolveErrorMessage(pruefeung.getKorrekturhinweis(), pruefeung.getKorrekturhinweisProgram()));
                if (refFields != null) {
                    error.setFelder(refFields.toArray(new FeldDeskriptorInterface[refFields.size()]));
                }
            }
        }
        this.plausiErrors.add(error);
    }

    private HashMap createScope(String scopeType) {
        HashMap<String, String> scope = new HashMap<String, String>();
        scope.put(SCOPE_TYPE_KEY, scopeType);
        return scope;
    }

    private HashMap getCurrentScope() {
        return (HashMap)this.scopeStack.peek();
    }

    private HashMap findScopeFromVariable(String name) {
        HashMap scope = null;
        int i = this.scopeStack.size() - 1;
        while (i >= 0) {
            HashMap scopeTmp = (HashMap)this.scopeStack.get(i);
            if (scopeTmp.containsKey(name)) {
                scope = scopeTmp;
                break;
            }
            if (scopeTmp.get(SCOPE_TYPE_KEY) == SCOPE_TYPE_PROGRAM) {
                i = 1;
            }
            --i;
        }
        return scope;
    }

    private String resolveErrorMessage(String defaultMessage, MetaProgram messageProgram) {
        String result = defaultMessage;
        if (messageProgram != null) {
            Console prevConsole = this.console;
            try {
                final StringBuffer message = new StringBuffer();
                this.setConsole(new Console(){

                    public void println() {
                        message.append('\n');
                    }

                    public void print(Value value) {
                        message.append(value.asString());
                    }
                });
                ProgramInterpreter interpreter = new ProgramInterpreter();
                try {
                    interpreter.executeInnerProgram(messageProgram, this);
                    result = message.toString();
                    if (result.endsWith("\n")) {
                        result = result.substring(0, result.length() - 1);
                    }
                }
                catch (Throwable throwable) {}
            }
            finally {
                this.setConsole(prevConsole);
            }
        }
        return result;
    }
}

