/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.common;

import de.statspez.pleditor.generator.codegen.java.CodegenFacade;
import de.statspez.pleditor.generator.codegen.support.CodegenException;
import de.statspez.pleditor.generator.meta.generated.MetaPlausibilisierung;
import de.statspez.pleditor.generator.parser.ILParseException;
import de.statspez.pleditor.generator.parser.IntermediateLanguageParser;
import de.statspez.pleditor.generator.parser.speclanguage.SpecLangParseException;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.util.Arrays;

public class GeneratorInvocation {
    private static String ENABLE_DSB_MAPPING = "-dsbmapping";
    private static String ENABLE_RAW_MAPPING = "-rawmapping";

    public static void main(String[] args) throws Exception {
        boolean enableDsbMapping = false;
        boolean enableRawMapping = false;
        boolean optionError = false;
        int rawOptionPos = -1;
        int dsbOptionPos = -1;
        int i = 0;
        while (i < args.length && !optionError) {
            if (ENABLE_DSB_MAPPING.equals(args[i])) {
                enableDsbMapping = true;
                dsbOptionPos = i;
                if (i == 0) {
                    optionError = true;
                }
            }
            if (ENABLE_RAW_MAPPING.equals(args[i])) {
                enableRawMapping = true;
                rawOptionPos = i;
                if (i == 0) {
                    optionError = true;
                }
            }
            ++i;
        }
        if (!optionError && (enableDsbMapping || enableRawMapping)) {
            int optionsToRemove = 0;
            optionsToRemove += enableDsbMapping ? 1 : 0;
            if (args.length - (optionsToRemove += enableRawMapping ? 1 : 0) < 1) {
                optionError = true;
            } else {
                int[] positionToRemove = new int[optionsToRemove];
                int pos = 0;
                if (enableDsbMapping) {
                    positionToRemove[pos] = dsbOptionPos;
                    ++pos;
                }
                if (enableRawMapping) {
                    positionToRemove[pos] = rawOptionPos;
                }
                args = GeneratorInvocation.removeStringFromPositions(args, positionToRemove);
            }
        }
        if (args.length < 1 || args.length > 2 || optionError) {
            System.err.println("Es muessen die folgenden Parameter angegeben werden:");
            System.err.println("1. (erforderlich) Name der Eingabe-Datei oder des Pfades.");
            System.err.println("2. (optional) Verzeichnis, in dem die Ausgabe-Datei erzeugt");
            System.err.println("3. (optional) " + ENABLE_DSB_MAPPING + " Ob bei der Generierung das DSB-Mapping erzeugt werden soll");
            System.err.println("4. (optional) " + ENABLE_RAW_MAPPING + " Ob bei der Generierung das RAW-Mapping erzeugt werden soll");
            System.err.println("   werden soll. Wenn dieser Parameter nicht angegeben ist wird");
            System.err.println("   das aktuelle Verzeichnis verwendet.");
            System.err.println("   Falls f\u00fcr 1. ein Pfad vorgegeben wird, werden die enthaltenen");
            System.err.println("   Dateien mit dem Muster Plausi_*.xml verarbeitet.");
            System.exit(1);
        }
        File file = new File(args[0]);
        File targetPath = null;
        if (file.isFile()) {
            targetPath = args.length == 1 ? file.getParentFile() : new File(args[1]);
            GeneratorInvocation.generate(file, targetPath, enableDsbMapping, enableRawMapping);
        } else if (file.isDirectory()) {
            targetPath = args.length == 1 ? file : new File(args[1]);
            Object[] filesInDir = file.list(new FilenameFilter(){

                public boolean accept(File f, String s) {
                    return s.startsWith("Plausi_") && s.endsWith(".xml");
                }
            });
            if (filesInDir.length != 0) {
                Arrays.sort(filesInDir);
                int i2 = 0;
                while (i2 < filesInDir.length) {
                    GeneratorInvocation.generate(new File(file, (String)filesInDir[i2]), targetPath, enableDsbMapping, enableRawMapping);
                    ++i2;
                }
            } else {
                System.out.println("Keine EDT-DAteien in " + file + " gefunden ...");
            }
        }
    }

    private static String[] removeStringFromPositions(String[] array, int[] posi) {
        String[] returnVelue;
        if (array == null || posi == null) {
            returnVelue = null;
        } else if (array.length <= 1) {
            returnVelue = new String[]{};
        } else {
            returnVelue = new String[array.length - posi.length];
            int[] marks = new int[returnVelue.length];
            int markerpos = 0;
            int i = 0;
            while (i < array.length) {
                boolean add = true;
                int d = 0;
                while (d < posi.length) {
                    if (posi[d] == i) {
                        add = false;
                        break;
                    }
                    ++d;
                }
                if (add) {
                    marks[markerpos] = i;
                    ++markerpos;
                }
                ++i;
            }
            i = 0;
            while (i < marks.length) {
                returnVelue[i] = array[marks[i]];
                ++i;
            }
        }
        return returnVelue;
    }

    /*
     * Loose catch block
     */
    public static void generate(File file, File targetPath, boolean dsbCheck, boolean rawCheck) throws Exception {
        MetaPlausibilisierung plausi;
        block13: {
            plausi = null;
            FileReader in = new FileReader(file);
            try {
                System.out.println("Parsen der Eingabe-Datei " + file + " ...");
                IntermediateLanguageParser parser = new IntermediateLanguageParser();
                plausi = (MetaPlausibilisierung)parser.parse(in);
            }
            catch (ILParseException exc) {
                System.err.println("Beim Parsen der Eingabe-Datei " + file + " ist ein Fehler aufgetreten:");
                System.err.println(exc.getMessage());
                exc.printStackTrace();
                System.exit(1);
                in.close();
                break block13;
            }
            catch (SpecLangParseException exc) {
                System.err.println("Beim Parsen der Eingabe-Datei " + file + " ist ein Fehler aufgetreten:");
                System.err.println(exc.getMessage());
                System.err.println(exc.messagesAsText());
                System.exit(1);
                break block13;
            }
            catch (Throwable thr) {
                System.err.println("Beim Parsen der Eingabe-Datei " + file + " ist ein Fehler aufgetreten:");
                System.err.println(thr.getMessage());
                thr.printStackTrace();
                System.exit(1);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                in.close();
                break block13;
            }
            {
                finally {
                    in.close();
                }
            }
            in.close();
        }
        try {
            CodegenFacade generator = new CodegenFacade();
            generator.generate(plausi, targetPath.getAbsolutePath(), dsbCheck, rawCheck);
        }
        catch (CodegenException exc) {
            System.err.println("Bei der Code-Erzeugung von " + file + " sind Fehler/Warnungen aufgetreten:");
            System.err.println(exc.getMessage());
            System.err.println(exc.errorsAsText());
            System.err.println(exc.warningsAsText());
            if (exc.hasErrors()) {
                System.exit(1);
            }
        }
        catch (Throwable thr) {
            thr.printStackTrace();
            System.exit(1);
        }
    }
}

