/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.support;

import de.statspez.pleditor.generator.meta.AbstractElementVisitor;
import de.statspez.pleditor.generator.meta.MetaNumber;
import de.statspez.pleditor.generator.meta.MetaString;
import de.statspez.pleditor.generator.meta.MetaValue;
import java.util.HashMap;
import java.util.Vector;

public class LiteralManager {
    private HashMap literals = new HashMap();
    private Vector values = new Vector();
    private LiteralNameCreator lmc = new LiteralNameCreator();
    private boolean segmentLiterals;
    private int maxLiteralsInSegment;
    private SegmentPrefixGiver spg;
    private Vector segments;
    private Vector segmentPrefixes;

    public LiteralManager() {
        this(false, -1, null);
    }

    public LiteralManager(boolean segmentLiterals, int maxLiteralsInSegment, SegmentPrefixGiver spg) {
        this.segmentLiterals = segmentLiterals;
        this.maxLiteralsInSegment = maxLiteralsInSegment;
        this.spg = spg;
        this.segments = new Vector();
        this.segmentPrefixes = new Vector();
    }

    public String defineLiteral(MetaValue value) {
        String lname = this.createNameFor(value);
        Vector<MetaValue> currentValues = this.getCurrentValues();
        if (this.segmentLiterals) {
            if (currentValues.size() == this.maxLiteralsInSegment) {
                currentValues = new Vector<MetaValue>();
                this.segments.add(currentValues);
                this.segmentPrefixes.add(this.spg.getNextSegmentPrefix());
            }
            if (currentValues != this.values) {
                lname = this.segmentPrefixes.lastElement() + lname;
            }
        }
        currentValues.add(value);
        this.literals.put(value, lname);
        return lname;
    }

    public boolean literalDefinedFor(MetaValue value) {
        return this.literals.containsKey(value);
    }

    public String literalFor(MetaValue value) {
        if (!this.literals.containsKey(value)) {
            throw new IllegalArgumentException("no literal defined for value " + value.toString());
        }
        return (String)this.literals.get(value);
    }

    public MetaValue[] values() {
        return this.values.toArray(new MetaValue[0]);
    }

    public int numOfSegments() {
        return this.segments.size();
    }

    public MetaValue[] valuesForSegment(int i) {
        return this.getValuesForSegment(i).toArray(new MetaValue[0]);
    }

    public String prefixForSegment(int i) {
        return (String)this.segmentPrefixes.get(i);
    }

    private String createNameFor(MetaValue value) {
        value.accept(this.lmc);
        return this.lmc.name;
    }

    private Vector getCurrentValues() {
        if (this.segments.size() == 0) {
            return this.values;
        }
        return (Vector)this.segments.lastElement();
    }

    private Vector getValuesForSegment(int i) {
        return (Vector)this.segments.get(i);
    }

    private class LiteralNameCreator
    extends AbstractElementVisitor {
        private static final String NUMBER_PREFIX = "__NUM_LIT_";
        private static final String STRING_PREFIX = "__STR_LIT_";
        private int numberCount = 0;
        private int stringCount = 0;
        public String name = null;

        private LiteralNameCreator() {
        }

        public void visitNumber(MetaNumber aNumber) {
            ++this.numberCount;
            this.name = NUMBER_PREFIX + Integer.toString(this.numberCount);
        }

        public void visitString(MetaString aString) {
            ++this.stringCount;
            this.name = STRING_PREFIX + Integer.toString(this.stringCount);
        }
    }

    public static interface SegmentPrefixGiver {
        public String getNextSegmentPrefix();
    }
}

