/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.mapping.structure;

import de.statspez.pleditor.generator.codegen.mapping.MappingUtil;
import de.statspez.pleditor.generator.codegen.mapping.structure.DefaultMappingElement;
import de.statspez.pleditor.generator.codegen.mapping.structure.DsbFieldHierarchy;
import de.statspez.pleditor.generator.codegen.mapping.structure.Mapping;
import de.statspez.pleditor.generator.codegen.mapping.structure.RawFieldHierarchy;
import de.statspez.pleditor.generator.codegen.mapping.structure.TbFieldHierarchy;
import de.statspez.pleditor.generator.codegen.support.Traverser;
import de.statspez.pleditor.generator.meta.MetaCustomMapping;
import de.statspez.pleditor.generator.meta.MetaCustomMappingElement;
import de.statspez.pleditor.generator.meta.MetaCustomRawField;
import de.statspez.pleditor.generator.meta.MetaCustomRawFieldGroup;
import de.statspez.pleditor.generator.meta.MetaCustomTBFeld;
import de.statspez.pleditor.generator.meta.MetaCustomThemenbereich;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.generated.MetaMapping;
import de.statspez.pleditor.generator.meta.generated.MetaMappingElement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MappingMeta
extends Mapping {
    private MetaCustomMapping mapping;
    private List mappingElementList;
    private DsbFieldHierarchy dsbFieldHierarchy;
    private List sourceStructureNames;
    private List targetStructureNames;
    private final int direction;

    public MappingMeta(int direction, MetaCustomMapping aMapping) {
        this.direction = direction;
        this.mapping = aMapping;
        this.mappingElementList = new ArrayList();
        TbFieldHierarchy tbFieldHierarchy = new TbFieldHierarchy();
        tbFieldHierarchy.init(aMapping.getThemenbereich());
        if (direction == 102 || direction == 103) {
            this.dsbFieldHierarchy = new DsbFieldHierarchy();
            this.dsbFieldHierarchy.init(aMapping.getDSB());
            if (direction == 103) {
                this.targetStructureNames = this.dsbFieldHierarchy.getStructureFieldNames();
                this.sourceStructureNames = tbFieldHierarchy.getStructureFieldNames();
            } else {
                this.targetStructureNames = tbFieldHierarchy.getStructureFieldNames();
                this.sourceStructureNames = this.dsbFieldHierarchy.getStructureFieldNames();
            }
        }
        if (direction == 100 || direction == 101) {
            RawFieldHierarchy rawFieldHierarchy = new RawFieldHierarchy();
            rawFieldHierarchy.init(aMapping.getRawDataSet());
            if (direction == 101) {
                this.targetStructureNames = rawFieldHierarchy.getStructureFieldNames();
                this.sourceStructureNames = tbFieldHierarchy.getStructureFieldNames();
            } else {
                this.targetStructureNames = tbFieldHierarchy.getStructureFieldNames();
                this.sourceStructureNames = rawFieldHierarchy.getStructureFieldNames();
            }
        }
        this.mapping.accept(new MappingTraverser());
    }

    public List getMappingElementList() {
        return this.mappingElementList;
    }

    protected int getDirection() {
        return this.direction;
    }

    public String getHierarchyAsString(MetaCustomMappingElement mappingElement, boolean isSource) {
        String hierarchy = "";
        if (this.getDirection() == 101 && !isSource || this.getDirection() == 100 && isSource) {
            if (mappingElement.getFeldRaw() != null) {
                if (mappingElement.getFeldRaw() instanceof MetaCustomRawField) {
                    hierarchy = ((MetaCustomRawField)mappingElement.getFeldRaw()).hierarchyAsString();
                } else if (mappingElement.getFeldRaw() instanceof MetaCustomRawFieldGroup) {
                    hierarchy = ((MetaCustomRawFieldGroup)mappingElement.getFeldRaw()).hierarchyAsString();
                }
            } else if (mappingElement.getRawSet() != null) {
                hierarchy = mappingElement.getRawSet().getName();
            }
        } else if (this.getDirection() == 103 && !isSource || this.getDirection() == 102 && isSource) {
            if (mappingElement.getFeldDSB() != null) {
                hierarchy = this.dsbFieldHierarchy.getHierarchieFor(mappingElement.getFeldDSB());
            } else if (mappingElement.getFeldSatzart() != null) {
                hierarchy = this.dsbFieldHierarchy.getHierarchieFor(mappingElement.getFeldSatzart());
            }
        } else {
            hierarchy = mappingElement.getTBFeldListeAlsName();
        }
        if (hierarchy != null) {
            hierarchy = MappingUtil.encodeName(hierarchy);
        }
        return hierarchy;
    }

    public List getSourceStructureHierarchyNames() {
        return this.sourceStructureNames;
    }

    public List getTargetStructureHierarchyNames() {
        return this.targetStructureNames;
    }

    private class MappingTraverser
    extends Traverser {
        private MappingTraverser() {
        }

        public void visitMapping(MetaMapping aMapping) {
            this.visitElements(aMapping.getMappingliste());
        }

        public void visitMappingElement(MetaMappingElement anElement) {
            MetaCustomMappingElement element = (MetaCustomMappingElement)anElement;
            String sourceHierarchy = MappingMeta.this.getHierarchyAsString(element, true);
            String targetHierarchy = MappingMeta.this.getHierarchyAsString(element, false);
            MetaProgram rule = null;
            int[] sourceDimensions = null;
            int[] targetDimensions = null;
            Iterator feldTBListe = element.getFeldTBListe();
            String[] tbHierarchy = null;
            String tbField = null;
            if (MappingMeta.this.getDirection() == 103 || MappingMeta.this.getDirection() == 101) {
                rule = element.getQuellRegelSpezifikation();
                tbHierarchy = sourceHierarchy.split("\\.");
            } else if (MappingMeta.this.getDirection() == 102 || MappingMeta.this.getDirection() == 100) {
                rule = element.getZielRegelSpezifikation();
                tbHierarchy = targetHierarchy.split("\\.");
            }
            if (tbHierarchy != null && tbHierarchy.length > 0) {
                tbField = tbHierarchy[tbHierarchy.length - 1];
            }
            if (tbField == null || tbField.length() == 0) {
                tbField = MappingMeta.this.getDirection() == 103 || MappingMeta.this.getDirection() == 101 ? sourceHierarchy : targetHierarchy;
            }
            int[] dimension = null;
            if (tbField != null) {
                while (feldTBListe.hasNext() && dimension == null) {
                    MetaCustomTBFeld tb;
                    Object next = feldTBListe.next();
                    if (!(next instanceof MetaCustomTBFeld) || !(tb = (MetaCustomTBFeld)next).getName().equals(tbField) || tb.getKlasse() instanceof MetaCustomThemenbereich) continue;
                    dimension = ((MetaCustomTBFeld)next).dimensions();
                }
            }
            if (MappingMeta.this.getDirection() == 103 || MappingMeta.this.getDirection() == 101) {
                sourceDimensions = dimension;
            } else {
                targetDimensions = dimension;
            }
            MappingMeta.this.mappingElementList.add(new DefaultMappingElement(sourceHierarchy, targetHierarchy, element.getMappingTyp(), rule, sourceDimensions, targetDimensions));
        }
    }
}

