/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.mapping;

import de.statspez.pleditor.generator.codegen.mapping.IndexVariableSupplier;
import de.statspez.pleditor.generator.codegen.pl.PrettyPrinter;
import de.statspez.pleditor.generator.meta.AbstractElementVisitor;
import de.statspez.pleditor.generator.meta.MetaArrayAccess;
import de.statspez.pleditor.generator.meta.MetaBoolean;
import de.statspez.pleditor.generator.meta.MetaBooleanOperator;
import de.statspez.pleditor.generator.meta.MetaConditionalStatement;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.MetaFieldAccess;
import de.statspez.pleditor.generator.meta.MetaForNextLoop;
import de.statspez.pleditor.generator.meta.MetaFunctionCall;
import de.statspez.pleditor.generator.meta.MetaIdentifier;
import de.statspez.pleditor.generator.meta.MetaIndexOfOperator;
import de.statspez.pleditor.generator.meta.MetaLiteralAccess;
import de.statspez.pleditor.generator.meta.MetaMapStatement;
import de.statspez.pleditor.generator.meta.MetaMathOperator;
import de.statspez.pleditor.generator.meta.MetaNoValue;
import de.statspez.pleditor.generator.meta.MetaNumber;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.MetaReturnStatement;
import de.statspez.pleditor.generator.meta.MetaSetStatement;
import de.statspez.pleditor.generator.meta.MetaSingleAssignment;
import de.statspez.pleditor.generator.meta.MetaSizeOfOperator;
import de.statspez.pleditor.generator.meta.MetaStatementSequence;
import de.statspez.pleditor.generator.meta.MetaString;
import de.statspez.pleditor.generator.meta.MetaStructureAccess;
import de.statspez.pleditor.generator.meta.MetaTestingOperator;
import de.statspez.pleditor.generator.meta.MetaUnaryBoolOperator;
import de.statspez.pleditor.generator.meta.MetaVarDeclaration;
import java.util.Iterator;
import java.util.Stack;

public class MappingRegelGenerator
extends PrettyPrinter {
    private static final String INDENT = "   ";
    private IndexVariableSupplier indexVariableSupplier;
    private StringBuffer preMappingCode;
    private StringBuffer postMappingCode;
    private String einrueckung;
    private boolean isMappenFound;

    public synchronized void generieren(MetaProgram program, IndexVariableSupplier _indexVariableSupplier, String indent) {
        this.isMappenFound = false;
        this.preMappingCode = new StringBuffer();
        this.postMappingCode = new StringBuffer();
        this.einrueckung = indent;
        this.indexVariableSupplier = _indexVariableSupplier;
        program.statements().accept(this);
    }

    public void print(String text) {
        this.schreiben(text);
    }

    private void schreiben(String string) {
        if (!this.isMappenFound) {
            this.preMappingCode.append(string);
        } else {
            this.postMappingCode.append(string);
        }
    }

    private void umbruch() {
        this.schreiben("\n");
    }

    private void einruecken() {
        this.schreiben(this.einrueckung);
    }

    private void blockBeginn() {
        this.umbruch();
        this.einrueckung = String.valueOf(this.einrueckung) + INDENT;
    }

    private void blockEnde() {
        this.einrueckung = this.einrueckung.substring(INDENT.length());
    }

    public void visitStatementSequence(MetaStatementSequence aSequence) {
        Iterator it = aSequence.statements();
        while (it.hasNext()) {
            MetaElement element = (MetaElement)it.next();
            element.accept(this);
        }
    }

    public void visitConditionalStatement(MetaConditionalStatement aStatement) {
        this.einruecken();
        this.schreiben("WENN");
        this.blockBeginn();
        this.einruecken();
        aStatement.condition().accept(this);
        this.umbruch();
        this.blockEnde();
        this.einruecken();
        this.schreiben("DANN");
        this.blockBeginn();
        aStatement.ifTrue().accept(this);
        this.blockEnde();
        if (aStatement.ifFalse().numberOfStatements() > 0) {
            this.einruecken();
            this.schreiben("SONST");
            this.blockBeginn();
            aStatement.ifFalse().accept(this);
            this.blockEnde();
        }
        this.umbruch();
        this.einruecken();
        this.schreiben("ENDE");
        this.umbruch();
    }

    public void visitForNextLoop(MetaForNextLoop aStatement) {
        this.einruecken();
        this.schreiben("WIEDERHOLE FUER ");
        aStatement.startAssignment().accept(this);
        this.schreiben(" BIS ");
        aStatement.endCondition().accept(this);
        if (aStatement.stepExpression() != null) {
            this.schreiben(" SCHRITTWEITE ");
            aStatement.stepExpression().accept(this);
        }
        this.blockBeginn();
        aStatement.loopBody().accept(this);
        this.blockEnde();
        this.einruecken();
        this.schreiben("ENDE");
        this.umbruch();
    }

    public void visitSizeOfOperator(MetaSizeOfOperator anOperator) {
        this.schreiben("ANZAHL VON ");
        anOperator.operand().accept(this);
    }

    public void visitSetStatement(MetaSetStatement aSetStatemnt) {
        if (aSetStatemnt.getType() == MetaSetStatement.APPEND) {
            this.schreiben("SATZ ANLEGEN");
        } else if (aSetStatemnt.getType() == MetaSetStatement.DELETE) {
            this.schreiben("SATZ LOESCHEN");
        }
        aSetStatemnt.getFactor().accept(this);
    }

    public void visitMapStatement(MetaMapStatement aStatement) {
        this.isMappenFound = true;
    }

    public void visitReturnStatement(MetaReturnStatement aStatement) {
    }

    public void visitFunctionCall(MetaFunctionCall aStatement) {
        if (aStatement.isStandalone()) {
            this.einruecken();
        }
        this.schreiben("FUNKTION ");
        aStatement.function().accept(this);
        this.schreiben("(");
        int i = 0;
        while (i < aStatement.numberOfParameters()) {
            aStatement.parameterAt(i).accept(this);
            if (i < aStatement.numberOfParameters() - 1) {
                this.schreiben(", ");
            }
            ++i;
        }
        this.schreiben(")");
        this.umbruch();
    }

    public void visitBooleanOperator(MetaBooleanOperator anOperator) {
        this.schreiben("(");
        anOperator.firstOperand().accept(this);
        this.schreiben(" ");
        switch (anOperator.type()) {
            case 1: {
                this.schreiben("UND");
                break;
            }
            case 2: {
                this.schreiben("ODER");
            }
        }
        this.schreiben(" ");
        anOperator.secondOperand().accept(this);
        this.schreiben(")");
    }

    public void visitUnaryBoolOperator(MetaUnaryBoolOperator anOperator) {
        this.schreiben("NICHT (");
        anOperator.operand().accept(this);
        this.schreiben(")");
    }

    public void visitTestingOperator(MetaTestingOperator anOperator) {
        this.schreiben("(");
        anOperator.firstOperand().accept(this);
        this.schreiben(" ");
        switch (anOperator.type()) {
            case 1: {
                this.schreiben("=");
                break;
            }
            case 4: {
                this.schreiben("/=");
                break;
            }
            case 3: {
                this.schreiben(">");
                break;
            }
            case 6: {
                this.schreiben(">=");
                break;
            }
            case 2: {
                this.schreiben("<");
                break;
            }
            case 5: {
                this.schreiben("<=");
                break;
            }
            case 7: {
                this.schreiben("IN");
            }
        }
        this.schreiben(" ");
        anOperator.secondOperand().accept(this);
        this.schreiben(")");
    }

    public void visitIndexOfOperator(MetaIndexOfOperator anOperator) {
    }

    public void visitSingleAssignment(MetaSingleAssignment anAssignment) {
        this.einruecken();
        anAssignment.leftValue().accept(new SetValueGenerator());
        this.schreiben(" := ");
        anAssignment.rightValue().accept(this);
        this.umbruch();
    }

    public void visitMathOperator(MetaMathOperator anOperator) {
        this.schreiben("(");
        anOperator.firstOperand().accept(this);
        this.schreiben(" ");
        switch (anOperator.type()) {
            case 1: {
                this.schreiben("+");
                break;
            }
            case 2: {
                this.schreiben("-");
                break;
            }
            case 4: {
                this.schreiben("*");
                break;
            }
            case 3: {
                this.schreiben("/");
            }
        }
        this.schreiben(" ");
        anOperator.secondOperand().accept(this);
        this.schreiben(")");
    }

    public void visitStructureAccess(MetaStructureAccess anAccess) {
        anAccess.accept(new GetValueGenerator());
    }

    public void visitArrayAccess(MetaArrayAccess anAccess) {
        anAccess.accept(new GetValueGenerator());
    }

    public void visitFieldAccess(MetaFieldAccess anAccess) {
        anAccess.accept(new GetValueGenerator());
    }

    public void visitIdentifier(MetaIdentifier anIdentifier) {
        this.schreiben(anIdentifier.value());
    }

    public void visitLiteralAccess(MetaLiteralAccess anAccess) {
        anAccess.accept(new GetValueGenerator());
    }

    public void visitVarDeclaration(MetaVarDeclaration aDeclaration) {
        this.einruecken();
        this.schreiben("VAR ");
        Iterator it = aDeclaration.identifiers();
        while (it != null && it.hasNext()) {
            MetaIdentifier identifier = (MetaIdentifier)it.next();
            this.schreiben(identifier.value());
            if (!it.hasNext()) continue;
            this.schreiben(", ");
        }
        this.umbruch();
    }

    public String getPostMappingCode() {
        return this.postMappingCode.toString();
    }

    public String getPreMappingCode() {
        return this.preMappingCode.toString();
    }

    private String strukturAlsString(Stack structure) {
        StringBuffer ns = new StringBuffer();
        Iterator it = structure.iterator();
        while (it.hasNext()) {
            ns.append((String)it.next());
            ns.append(".");
        }
        return ns.substring(0, ns.length() - 1);
    }

    private abstract class AbstractValueGenerator
    extends AbstractElementVisitor {
        Stack struktur = new Stack();

        private AbstractValueGenerator() {
        }

        public void visitStructureAccess(MetaStructureAccess anAccess) {
            anAccess.structureAccess().accept(this);
            MappingRegelGenerator.this.schreiben(".");
            anAccess.selectedElement().accept(this);
        }

        public void visitArrayAccess(MetaArrayAccess anAccess) {
            this.struktur.push(anAccess.accessedArray().value());
        }

        public void visitFieldAccess(MetaFieldAccess anAccess) {
            this.struktur.push(anAccess.accessedField().value());
            MappingRegelGenerator.this.schreiben(anAccess.accessedField().value());
        }
    }

    private class ArrayIndexGenerator
    extends AbstractElementVisitor {
        Stack aktuelleStruktur;
        boolean isSetValue;

        public ArrayIndexGenerator(Stack aktuelleStruktur, boolean isSetValue) {
            this.aktuelleStruktur = aktuelleStruktur;
            this.isSetValue = isSetValue;
        }

        public void visitFieldAccess(MetaFieldAccess anAccess) {
            if ("N".equals(anAccess.accessedField().value())) {
                if (this.isSetValue) {
                    MappingRegelGenerator.this.schreiben(MappingRegelGenerator.this.indexVariableSupplier.getTargetIndexVariable(MappingRegelGenerator.this.strukturAlsString(this.aktuelleStruktur)));
                } else {
                    MappingRegelGenerator.this.schreiben(MappingRegelGenerator.this.indexVariableSupplier.getSourceIndexVariable(MappingRegelGenerator.this.strukturAlsString(this.aktuelleStruktur)));
                }
            } else if (anAccess.accessedField().value() != null) {
                MappingRegelGenerator.this.schreiben(anAccess.accessedField().value());
            }
        }

        public void visitLiteralAccess(MetaLiteralAccess anAccess) {
            anAccess.accessedLiteral().accept(this);
        }

        public void visitNumber(MetaNumber aNumber) {
            MappingRegelGenerator.this.schreiben(aNumber.getMyStringValue());
        }

        public void visitIndexOfOperator(MetaIndexOfOperator anOperator) {
            if (this.aktuelleStruktur != null && !this.aktuelleStruktur.isEmpty()) {
                if (this.isSetValue) {
                    MappingRegelGenerator.this.schreiben(MappingRegelGenerator.this.indexVariableSupplier.getTargetIndexVariable(MappingRegelGenerator.this.strukturAlsString(this.aktuelleStruktur)));
                } else {
                    MappingRegelGenerator.this.schreiben(MappingRegelGenerator.this.indexVariableSupplier.getSourceIndexVariable(MappingRegelGenerator.this.strukturAlsString(this.aktuelleStruktur)));
                }
            }
        }
    }

    private class GetValueGenerator
    extends AbstractValueGenerator {
        private GetValueGenerator() {
        }

        public void visitArrayAccess(MetaArrayAccess anAccess) {
            super.visitArrayAccess(anAccess);
            MappingRegelGenerator.this.schreiben(anAccess.accessedArray().value());
            Iterator iterator = anAccess.indices();
            while (iterator != null && iterator.hasNext()) {
                MappingRegelGenerator.this.schreiben("[");
                ((MetaElement)iterator.next()).accept(new ArrayIndexGenerator(this.struktur, false));
                MappingRegelGenerator.this.schreiben("]");
            }
        }

        public void visitFieldAccess(MetaFieldAccess anAccess) {
            super.visitFieldAccess(anAccess);
            String index = MappingRegelGenerator.this.indexVariableSupplier.getSourceIndexVariable(MappingRegelGenerator.this.strukturAlsString(this.struktur));
            if (index != null && index.length() > 0) {
                MappingRegelGenerator.this.schreiben("[");
                MappingRegelGenerator.this.schreiben(index);
                MappingRegelGenerator.this.schreiben("]");
            }
        }

        public void visitLiteralAccess(MetaLiteralAccess anAccess) {
            anAccess.accessedLiteral().accept(this);
        }

        public void visitString(MetaString aString) {
            MappingRegelGenerator.this.schreiben("'");
            MappingRegelGenerator.this.schreiben(aString.value());
            MappingRegelGenerator.this.schreiben("'");
        }

        public void visitNumber(MetaNumber aNumber) {
            MappingRegelGenerator.this.schreiben(aNumber.getMyStringValue());
        }

        public void visitBoolean(MetaBoolean aBoolean) {
            if (aBoolean.value().booleanValue()) {
                MappingRegelGenerator.this.schreiben("WAHR");
            } else {
                MappingRegelGenerator.this.schreiben("FALSCH");
            }
        }

        public void visitNoValue(MetaNoValue aNoValue) {
            MappingRegelGenerator.this.schreiben("LEER");
        }
    }

    private class SetValueGenerator
    extends AbstractValueGenerator {
        private SetValueGenerator() {
        }

        public void visitArrayAccess(MetaArrayAccess anAccess) {
            super.visitArrayAccess(anAccess);
            MappingRegelGenerator.this.schreiben(anAccess.accessedArray().value());
            Iterator iterator = anAccess.indices();
            while (iterator != null && iterator.hasNext()) {
                MappingRegelGenerator.this.schreiben("[");
                ((MetaElement)iterator.next()).accept(new ArrayIndexGenerator(this.struktur, true));
                MappingRegelGenerator.this.schreiben("]");
            }
        }

        public void visitFieldAccess(MetaFieldAccess anAccess) {
            super.visitFieldAccess(anAccess);
            String index = MappingRegelGenerator.this.indexVariableSupplier.getTargetIndexVariable(MappingRegelGenerator.this.strukturAlsString(this.struktur));
            if (index != null && index.length() > 0) {
                MappingRegelGenerator.this.schreiben("[");
                MappingRegelGenerator.this.schreiben(index);
                MappingRegelGenerator.this.schreiben("]");
            }
        }
    }
}

