/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.js;

import de.statspez.pleditor.generator.codegen.java.StringHelper;
import de.statspez.pleditor.generator.codegen.js.CodegenContext;
import de.statspez.pleditor.generator.codegen.js.ErrorTextProgramCodeGenerator;
import de.statspez.pleditor.generator.codegen.js.JavaScriptCodeGenerator;
import de.statspez.pleditor.generator.codegen.js.ProgramCodeGenerator;
import de.statspez.pleditor.generator.codegen.support.Scope;
import de.statspez.pleditor.generator.common.ElementMessageContext;
import de.statspez.pleditor.generator.meta.MetaCustomAblauf;
import de.statspez.pleditor.generator.meta.MetaCustomFunktion;
import de.statspez.pleditor.generator.meta.MetaCustomPruefung;
import de.statspez.pleditor.generator.meta.MetaCustomThemenbereich;
import de.statspez.pleditor.generator.meta.generated.MetaPLAblauf;
import de.statspez.pleditor.generator.meta.generated.MetaPLFunktion;
import de.statspez.pleditor.generator.meta.generated.MetaPLPruefung;
import de.statspez.pleditor.generator.meta.generated.MetaTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import java.util.Iterator;

public class ThemenbereichCodeGenerator
extends JavaScriptCodeGenerator {
    private Scope scope;

    public synchronized void generate(CodegenContext context, MetaThemenbereich themenbereich, Scope tbScope) {
        this.setCodegenContext(context);
        this.scope = tbScope;
        themenbereich.accept(this);
        this.out.flush();
        this.checkForErrors();
    }

    public void visitThemenbereich(MetaThemenbereich tb) {
        if (((MetaCustomThemenbereich)tb).referencedByErhebung()) {
            this.visitElements(tb.getPruefungen());
            this.visitElements(tb.getAblaeufe());
            this.visitElements(tb.getFunktionen());
        }
    }

    public void visitPLPruefung(MetaPLPruefung aPruefung) {
        MetaCustomPruefung pruefung = (MetaCustomPruefung)aPruefung;
        ProgramCodeGenerator codeGen = new ProgramCodeGenerator();
        codeGen.setOutput(this.out);
        codeGen.setIndentLevel(this.indentLevel());
        codeGen.setErrorContext(new ElementMessageContext(1, pruefung.getId(), pruefung.getName()));
        this.context.putContextInfo("programPerformsPlausiKey", new Boolean(true));
        codeGen.generate(this.context, pruefung.getMetaSpezifikation(), this.scope);
        this.context.putContextInfo("programPerformsPlausiKey", null);
        ErrorTextProgramCodeGenerator errorTextCodeGen = null;
        if (pruefung.getFehlerTextKurzProgram() != null || pruefung.getFehlerTextLangProgram() != null || pruefung.getKorrekturhinweisProgram() != null) {
            errorTextCodeGen = new ErrorTextProgramCodeGenerator();
            errorTextCodeGen.setOutput(this.out);
            errorTextCodeGen.setIndentLevel(this.indentLevel());
        }
        this.indentNewLine();
        this.print("function ");
        this.print("err_");
        this.printContextAsPrefix();
        this.print(StringHelper.getEscapedName(pruefung.getName()));
        this.print("(");
        if (this.hasContext()) {
            this.print("ns");
        }
        this.print(")");
        this.openBlock();
        this.indentNewLine();
        this.print("var error = new PlausiError();");
        this.indentNewLine();
        this.print("error.type = ");
        this.print(aPruefung.getPruefungsart());
        this.print(";");
        this.indentNewLine();
        this.print("error.infoType = 0;");
        this.indentNewLine();
        this.print("error.message = ");
        if (pruefung.getFehlerTextKurzProgram() != null) {
            errorTextCodeGen.generate(this.context, pruefung.getFehlerTextKurzProgram(), this.scope);
        } else {
            this.print("\"");
            this.print(StringHelper.getEscapedStringValue(this.context.getTextResource().getFehlertextKurz(pruefung)));
            this.print("\"");
        }
        this.print(";");
        this.indentNewLine();
        this.print("error.description = ");
        if (pruefung.getFehlerTextLangProgram() != null) {
            errorTextCodeGen.generate(this.context, pruefung.getFehlerTextLangProgram(), this.scope);
        } else {
            this.print("\"");
            this.print(StringHelper.getEscapedStringValue(this.context.getTextResource().getFehlertextLang(pruefung)));
            this.print("\"");
        }
        this.print(";");
        this.indentNewLine();
        this.print("error.correctionAdvice = ");
        if (pruefung.getKorrekturhinweisProgram() != null) {
            errorTextCodeGen.generate(this.context, pruefung.getKorrekturhinweisProgram(), this.scope);
        } else {
            this.print("\"");
            this.print(StringHelper.getEscapedStringValue(this.context.getTextResource().getKorrekturhinweis(pruefung)));
            this.print("\"");
        }
        this.print(";");
        if (pruefung.sizeOfHauptBezugsfeld() > 0) {
            this.indentNewLine();
            this.print("error.field = ");
            if (this.hasContext()) {
                this.print("ns");
                this.print(" + ");
            }
            this.print("\"");
            if (this.hasContext()) {
                this.print(".");
            }
            Iterator iter = pruefung.getHauptBezugsfeld();
            while (iter.hasNext()) {
                MetaTBFeld field = (MetaTBFeld)iter.next();
                this.print(field.getName());
                if (!iter.hasNext()) continue;
                this.print(".");
            }
            this.print("\";");
            this.indentNewLine();
            this.print("error.id = error.field + \"#");
            this.print(pruefung.getName());
            this.print("\";");
        } else {
            this.indentNewLine();
            this.print("error.id = \"#");
            this.print(pruefung.getName());
            this.print("\";");
        }
        this.indentNewLine();
        this.print("error.referencedFields = referencedFields;");
        this.indentNewLine();
        this.print("referencedFields = null;");
        this.indentNewLine();
        this.print("return error;");
        this.closeBlock();
    }

    public void visitPLAblauf(MetaPLAblauf ablauf) {
        MetaCustomAblauf a = (MetaCustomAblauf)ablauf;
        this.indentNewLine();
        ProgramCodeGenerator prgGen = new ProgramCodeGenerator();
        prgGen.setOutput(this.out);
        prgGen.setIndentLevel(this.indentLevel());
        prgGen.setErrorContext(new ElementMessageContext(2, a.getId(), a.getName(), 6, a.getThemenbereich().getId(), a.getThemenbereich().getName()));
        this.context.putContextInfo("programPerformsPlausiKey", new Boolean(true));
        prgGen.generate(this.context, a.getMetaSpezifikation(), this.scope);
        this.context.putContextInfo("programPerformsPlausiKey", null);
    }

    public void visitPLFunktion(MetaPLFunktion funktion) {
        MetaCustomFunktion f = (MetaCustomFunktion)funktion;
        this.indentNewLine();
        ProgramCodeGenerator prgGen = new ProgramCodeGenerator();
        prgGen.setOutput(this.out);
        prgGen.setIndentLevel(this.indentLevel());
        int contextType = 4;
        if (f.getFunctionType() == 1) {
            contextType = 3;
        }
        prgGen.setErrorContext(new ElementMessageContext(contextType, f.getId(), f.getName(), 6, f.getThemenbereich().getId(), f.getThemenbereich().getName()));
        prgGen.generate(this.context, f.getMetaSpezifikation(), this.scope);
    }
}

