/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.js;

import de.statspez.pleditor.generator.codegen.java.StringHelper;
import de.statspez.pleditor.generator.codegen.js.ClassificationCodeGenerator;
import de.statspez.pleditor.generator.codegen.js.CodegenContext;
import de.statspez.pleditor.generator.codegen.js.ErrorTextProgramCodeGenerator;
import de.statspez.pleditor.generator.codegen.js.JavaScriptCodeGenerator;
import de.statspez.pleditor.generator.codegen.js.ProgramCodeGenerator;
import de.statspez.pleditor.generator.codegen.js.ThemenbereichCodeGenerator;
import de.statspez.pleditor.generator.codegen.support.CodegenUtil;
import de.statspez.pleditor.generator.codegen.support.Scope;
import de.statspez.pleditor.generator.common.ElementMessageContext;
import de.statspez.pleditor.generator.meta.MetaCustomFunktion;
import de.statspez.pleditor.generator.meta.MetaCustomMerkmal;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.generated.MetaAuspraegungsgruppe;
import de.statspez.pleditor.generator.meta.generated.MetaMerkmal;
import de.statspez.pleditor.generator.meta.generated.MetaPLAblauf;
import de.statspez.pleditor.generator.meta.generated.MetaPLFunktion;
import de.statspez.pleditor.generator.meta.generated.MetaPlausibilisierung;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import java.util.Iterator;

public class PlausiCodeGenerator
extends JavaScriptCodeGenerator {
    public synchronized void generate(CodegenContext context) {
        this.setCodegenContext(context);
        this.setOutputStream(context.getOutputStream());
        context.getPlausi().accept(this);
        this.out.flush();
        this.checkForErrors();
    }

    public void visitPlausibilisierung(MetaPlausibilisierung plausi) {
        this.visitElements(plausi.getAuspraegungsgruppen());
        this.visitElements(plausi.getMerkmale());
        this.visitElements(plausi.getFunktionen());
        this.visitElements(plausi.getThemenbereiche());
        MetaCustomPlausibilisierung customPlausi = (MetaCustomPlausibilisierung)plausi;
        this.indentNewLine();
        this.print("function plausi(flow)");
        this.openBlock();
        this.indentNewLine();
        this.print("var ");
        this.print("errmsg");
        this.print(" = new Array();");
        this.indentNewLine();
        Iterator iter = customPlausi.rootThemenbereich().getAblaeufe();
        while (iter.hasNext()) {
            MetaPLAblauf flow = (MetaPLAblauf)iter.next();
            this.print("if (flow == \"");
            this.print(StringHelper.getEscapedName(flow.getName()));
            this.print("\")");
            this.openBlock();
            flow.accept(this);
            this.closeBlock();
            if (!iter.hasNext()) continue;
            this.indentNewLine();
            this.print("else ");
        }
        if (customPlausi.standardAblauf() != null) {
            this.indentNewLine();
            this.print("else");
            this.openBlock();
            customPlausi.standardAblauf().accept(this);
            this.closeBlock();
        }
        this.indentNewLine();
        this.print("return ");
        this.print("errmsg");
        this.print(";");
        this.closeBlock();
    }

    public void visitThemenbereich(MetaThemenbereich themenbereich) {
        ThemenbereichCodeGenerator codeGen = new ThemenbereichCodeGenerator();
        codeGen.setOutput(this.out);
        codeGen.setIndentLevel(this.indentLevel());
        this.context.putContextInfo("contextKey", this.context.getContextNameFor(themenbereich));
        codeGen.generate(this.context, themenbereich, (Scope)this.context.getTopicScopes().get(themenbereich.getName()));
        this.context.putContextInfo("contextKey", null);
    }

    public void visitMerkmal(MetaMerkmal anObject) {
        MetaCustomMerkmal merkmal = (MetaCustomMerkmal)anObject;
        ProgramCodeGenerator codeGen = new ProgramCodeGenerator();
        codeGen.setOutput(this.out);
        codeGen.setIndentLevel(this.indentLevel());
        codeGen.setErrorContext(new ElementMessageContext(5, merkmal.getId(), merkmal.getName()));
        this.context.putContextInfo("programPerformsPlausiKey", new Boolean(true));
        this.context.putContextInfo("programChecksFieldKey", new Boolean(true));
        codeGen.generate(this.context, merkmal.getMetaSpezifikation(), this.context.getPlausiScope());
        this.context.putContextInfo("programPerformsPlausiKey", null);
        this.context.putContextInfo("programChecksFieldKey", null);
        ErrorTextProgramCodeGenerator errorTextCodeGen = null;
        if (merkmal.getFehlerTextKurzProgram() != null || merkmal.getFehlerTextLangProgram() != null || merkmal.getKorrekturhinweisProgram() != null) {
            errorTextCodeGen = new ErrorTextProgramCodeGenerator();
            errorTextCodeGen.setOutput(this.out);
            errorTextCodeGen.setIndentLevel(this.indentLevel());
        }
        this.indentNewLine();
        this.print("function ");
        this.print("err_");
        this.print("Merkmal_");
        this.print(StringHelper.getEscapedName(merkmal.getName()));
        this.print("(field, errorNum)");
        this.openBlock();
        this.indentNewLine();
        this.print("var error = new PlausiError();");
        this.indentNewLine();
        this.print("error.type = 1;");
        this.indentNewLine();
        this.print("error.infoType = errorNum;");
        this.indentNewLine();
        this.print("error.id = field + \"#");
        this.print(merkmal.getName());
        this.print("\";");
        this.indentNewLine();
        this.print("error.message = ");
        if (merkmal.getFehlerTextKurzProgram() != null) {
            errorTextCodeGen.generate(this.context, merkmal.getFehlerTextKurzProgram(), this.context.getPlausiScope());
        } else {
            this.print("\"");
            this.print(StringHelper.getEscapedStringValue(this.context.getTextResource().getFehlertextKurz(merkmal)));
            this.print("\"");
        }
        this.print(";");
        this.indentNewLine();
        this.print("error.description = ");
        if (merkmal.getFehlerTextLangProgram() != null) {
            errorTextCodeGen.generate(this.context, merkmal.getFehlerTextLangProgram(), this.context.getPlausiScope());
        } else {
            this.print("\"");
            this.print(StringHelper.getEscapedStringValue(this.context.getTextResource().getFehlertextLang(merkmal)));
            this.print("\"");
        }
        this.print(";");
        this.indentNewLine();
        this.print("error.correctionAdvice = ");
        if (merkmal.getKorrekturhinweisProgram() != null) {
            errorTextCodeGen.generate(this.context, merkmal.getKorrekturhinweisProgram(), this.context.getPlausiScope());
        } else {
            this.print("\"");
            this.print(StringHelper.getEscapedStringValue(this.context.getTextResource().getKorrekturhinweis(merkmal)));
            this.print("\"");
        }
        this.print(";");
        this.indentNewLine();
        this.print("error.field = field;");
        this.indentNewLine();
        this.print("error.fieldType = ");
        this.print(merkmal.getTyp());
        this.print(";");
        if (merkmal.getMaske() != null && merkmal.getMaske().length() > 0) {
            this.indentNewLine();
            this.print("error.fieldMask = \"");
            this.print(StringHelper.getEscapedStringValue(merkmal.getMaske()));
            this.print("\";");
        }
        this.indentNewLine();
        this.print("error.fieldLength = ");
        this.print("" + merkmal.getLaenge());
        this.print(";");
        String valueSpace = CodegenUtil.getValueSpaceAsString(merkmal);
        if (valueSpace != null && valueSpace.length() > 0) {
            this.indentNewLine();
            this.print("error.fieldValueSpace = \"");
            this.print(StringHelper.getEscapedStringValue(valueSpace));
            this.print("\";");
        }
        this.indentNewLine();
        this.print("error.referencedFields = referencedFields;");
        this.indentNewLine();
        this.print("referencedFields = null;");
        this.indentNewLine();
        this.print("return error;");
        this.closeBlock();
    }

    public void visitAuspraegungsgruppe(MetaAuspraegungsgruppe anObject) {
        ClassificationCodeGenerator codeGen = new ClassificationCodeGenerator();
        codeGen.setOutput(this.out);
        codeGen.setIndentLevel(this.indentLevel());
        codeGen.generate(this.context, anObject);
    }

    public void visitPLFunktion(MetaPLFunktion funktion) {
        MetaCustomFunktion f = (MetaCustomFunktion)funktion;
        this.indentNewLine();
        ProgramCodeGenerator prgGen = new ProgramCodeGenerator();
        prgGen.setOutput(this.out);
        prgGen.setIndentLevel(this.indentLevel());
        prgGen.setErrorContext(new ElementMessageContext(4, f.getId(), f.getName()));
        prgGen.generate(this.context, f.getMetaSpezifikation(), this.context.getPlausiScope());
    }

    public void visitPLAblauf(MetaPLAblauf anObject) {
        this.indentNewLine();
        this.print("errmsg");
        this.print(" = ");
        this.print("errmsg");
        this.print(".concat(");
        this.print("prg_");
        this.print(StringHelper.getEscapedName(anObject.getName()));
        this.print("());");
    }
}

