/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.java.mapping;

import de.statspez.pleditor.generator.codegen.java.CodegenContext;
import de.statspez.pleditor.generator.codegen.java.StringHelper;
import de.statspez.pleditor.generator.codegen.java.mapping.util.AttributesGenerator;
import de.statspez.pleditor.generator.codegen.java.mapping.util.ConstructorGenerator;
import de.statspez.pleditor.generator.codegen.java.mapping.util.MappingDataGenerator;
import de.statspez.pleditor.generator.codegen.java.mapping.util.RAWAttributesGenererator;
import de.statspez.pleditor.generator.codegen.java.mapping.util.RAWConstructorGenerator;
import de.statspez.pleditor.generator.meta.generated.MetaRawDataSet;
import de.statspez.pleditor.generator.meta.generated.MetaRawFieldGroup;
import de.statspez.pleditor.generator.meta.generated.MetaRawSet;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;

public class MappingRAWDataGenerator
extends MappingDataGenerator {
    public static final String PREFIX = "RAW_";
    private CodegenContext contex;
    private Set generatedClasses = new HashSet();
    private String className;

    public MappingRAWDataGenerator(CodegenContext contex) {
        this.className = PREFIX + StringHelper.getEscapedName(contex.getPlausiClassName());
        this.contex = contex;
    }

    public void generate(MetaRawDataSet anObject) {
        String filename = String.valueOf(this.className) + ".java";
        Writer writer = this.contex.createWriter(filename);
        try {
            this.setOutput(writer);
            this.createImports(this.contex.getPlausiPackage());
            this.createClassNotOpen(this.className, "TopicField", anObject, false);
            this.visitElements(anObject.getListOfRawSet());
            this.visitElements(anObject.getListOfRawField());
            this.closeBlock();
            this.flush();
        }
        finally {
            this.contex.destroyWriter(filename, writer);
        }
    }

    public void visitRawFieldGroup(MetaRawFieldGroup anObject) {
        if (!this.generatedClasses.contains(String.valueOf(this.structurePrefix) + anObject.getName())) {
            this.generatedClasses.add(String.valueOf(this.structurePrefix) + anObject.getName());
            this.visitElements(anObject.getListOfRawField());
            String name = String.valueOf(this.structurePrefix) + StringHelper.getEscapedName(anObject.getName());
            this.createClass(anObject, name, "TopicField");
        }
    }

    public void visitRawSet(MetaRawSet anObject) {
        if (!this.generatedClasses.contains(anObject.getName())) {
            this.generatedClasses.add(anObject.getName());
            String name = StringHelper.getEscapedName(anObject.getName());
            this.structurePrefix = String.valueOf(name) + "_";
            this.visitElements(anObject.getListOfRawField());
            this.createClass(anObject, name, "TopicField");
            this.structurePrefix = "";
        }
    }

    protected AttributesGenerator attributesGenerator(PrintWriter out) {
        return new RAWAttributesGenererator(out);
    }

    protected ConstructorGenerator constructorGenerator(PrintWriter out) {
        return new RAWConstructorGenerator(out);
    }

    protected String getPrefix() {
        return PREFIX;
    }
}

