/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.java;

import de.statspez.pleditor.generator.codegen.java.ProgramCodeGenerator;
import de.statspez.pleditor.generator.codegen.java.Settings;
import de.statspez.pleditor.generator.meta.MetaCustomFunktion;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.MetaProgramParameter;

public class ExternalProgramCodeGenerator
extends ProgramCodeGenerator {
    public void visitProgram(MetaProgram aProgram) {
        if (aProgram.isExternal() && aProgram.getExternalElement() instanceof MetaCustomFunktion) {
            MetaCustomFunktion externeFunktion = (MetaCustomFunktion)aProgram.getExternalElement();
            this.out.print("try");
            this.indentNewLine();
            this.out.print("{");
            this.increaseIndentLevel();
            this.indentNewLine();
            this.out.print("Value ___ext_erg = vf.valueFor((");
            this.out.print(Settings.NATIVE_TYPES[externeFunktion.getRueckgabeTyp()]);
            this.out.print(")invokeExternalFunction(context, \"" + externeFunktion.getName() + "\",new ValueInterface[]{");
            if (aProgram.numberOfParameters() > 0) {
                this.increaseIndentLevel();
                this.indentNewLine();
                int i = 0;
                while (i < aProgram.numberOfParameters()) {
                    if (i > 0) {
                        this.out.print(", ");
                    }
                    aProgram.parameterAt(i).accept(this);
                    ++i;
                }
                this.decreaseIndentLevel();
                this.indentNewLine();
            }
            this.out.print("}));");
            this.leaveCurrentSection();
            this.indentNewLine();
            this.out.print("return ___ext_erg;");
            this.decreaseIndentLevel();
            this.indentNewLine();
            this.out.print("}");
            this.indentNewLine();
            this.out.print("catch (Exception ex)");
            this.indentNewLine();
            this.out.print("{");
            this.indentNewLine();
            this.out.print("   context.getLogger().error(\"Fehler beim Ansprechen der externen Funktion: " + aProgram.name() + "\",ex);");
            this.indentNewLine();
            this.out.print("}");
            this.leaveCurrentSection();
            this.indentNewLine();
            this.out.print("return InvalidValue.instance();");
        }
    }

    public void visitProgramParameter(MetaProgramParameter aParam) {
        this.out.print(aParam.name().value());
        this.out.print(".get(context)");
    }
}

