/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.java;

import de.statspez.pleditor.generator.codegen.java.AbstractCodegenContext;
import de.statspez.pleditor.generator.meta.generated.MetaPlausibilisierung;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class DefaultCodegenContext
extends AbstractCodegenContext {
    private String outputDir;
    private boolean createPackageDirectories;
    private List generatedJavaFiles;

    public DefaultCodegenContext(MetaPlausibilisierung plausi, String outputDir) {
        this(plausi, outputDir, true);
    }

    public DefaultCodegenContext(MetaPlausibilisierung plausi, String outputDir, boolean createPackageDirectories) {
        super(plausi);
        this.outputDir = outputDir;
        this.createPackageDirectories = createPackageDirectories;
        this.generatedJavaFiles = new ArrayList();
    }

    public File[] getGeneratedJavaFiles() {
        return this.generatedJavaFiles.toArray(new File[this.generatedJavaFiles.size()]);
    }

    private File getCreatableFile(String filename) {
        String plausiPackage;
        StringBuffer absoluteFilename = new StringBuffer();
        if (this.outputDir != null && this.outputDir.length() > 0) {
            absoluteFilename.append(this.outputDir);
            if (!this.outputDir.endsWith("\\") && !this.outputDir.endsWith("/")) {
                absoluteFilename.append(System.getProperty("file.separator"));
            }
        }
        if (this.createPackageDirectories && (plausiPackage = this.getPlausiPackage()) != null && plausiPackage.length() > 0) {
            String[] packages = plausiPackage.split("\\.");
            int i = 0;
            while (i < packages.length) {
                absoluteFilename.append(packages[i]);
                absoluteFilename.append(System.getProperty("file.separator"));
                ++i;
            }
        }
        absoluteFilename.append(filename);
        File file = new File(absoluteFilename.toString());
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (file.getName().toLowerCase().endsWith(".java")) {
            this.generatedJavaFiles.add(file);
        }
        return file;
    }

    public Writer createWriter(String filename) {
        try {
            return new FileWriter(this.getCreatableFile(filename));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void destroyWriter(String filename, Writer writer) {
        try {
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public OutputStream createOutputStream(String filename) {
        try {
            return new FileOutputStream(this.getCreatableFile(filename));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void destroyOutputStream(String filename, OutputStream out) {
        try {
            out.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

