/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.doku;

import de.statspez.pleditor.generator.codegen.doku.DokuElement;
import de.statspez.pleditor.generator.codegen.doku.EinzelfeldStat;
import de.statspez.pleditor.generator.codegen.support.Traverser;
import de.statspez.pleditor.generator.meta.MetaArrayAccess;
import de.statspez.pleditor.generator.meta.MetaFieldAccess;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.MetaStructureAccess;
import de.statspez.pleditor.generator.meta.generated.MetaEinzelfeld;
import de.statspez.pleditor.generator.meta.generated.MetaTBFeld;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class TbFeldErsetzer
extends Traverser {
    private EinzelfeldStat einzelfeldStat;
    private List replaceItems;

    public TbFeldErsetzer(EinzelfeldStat einzelfeldStat) {
        this.einzelfeldStat = einzelfeldStat;
    }

    public String erstetzeTBFeldNamen(MetaProgram program, String programStr) {
        StringBuffer resultBuf = new StringBuffer();
        this.replaceItems = new ArrayList();
        program.accept(this);
        Collections.sort(this.replaceItems, new ReplaceItemComparator());
        BufferedReader reader = new BufferedReader(new StringReader(programStr));
        try {
            Iterator it = this.replaceItems.iterator();
            int lastPos = 0;
            int currLineNr = 1;
            String currLine = reader.readLine();
            while (it.hasNext()) {
                DokuElement de;
                ReplaceItem replaceItem = (ReplaceItem)it.next();
                while (replaceItem.getLine() > currLineNr) {
                    if (lastPos < currLine.length()) {
                        resultBuf.append(currLine.substring(lastPos, currLine.length()));
                    }
                    resultBuf.append('\n');
                    currLine = reader.readLine();
                    ++currLineNr;
                    lastPos = 0;
                }
                resultBuf.append(currLine.substring(lastPos, replaceItem.getColumn() - 1));
                lastPos = replaceItem.getColumn() - 1;
                MetaEinzelfeld mef = null;
                String efId = null;
                if (replaceItem.getFieldId() != null) {
                    efId = this.einzelfeldStat.getEfFromFieldId(replaceItem.getFieldId());
                }
                if (efId != null && efId.length() > 0 && (de = this.einzelfeldStat.getElement(efId)) != null) {
                    mef = (MetaEinzelfeld)de.getElement();
                }
                if (mef != null) {
                    resultBuf.append(mef.getName());
                } else {
                    resultBuf.append("!");
                    resultBuf.append(currLine.substring(lastPos, lastPos + replaceItem.getLength()));
                    resultBuf.append("!");
                }
                lastPos = replaceItem.getColumn() + replaceItem.getLength() - 1;
            }
            if (lastPos < currLine.length()) {
                resultBuf.append(currLine.substring(lastPos, currLine.length()));
            }
            while ((currLine = reader.readLine()) != null) {
                resultBuf.append('\n');
                resultBuf.append(currLine);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return resultBuf.toString();
    }

    public void visitStructureAccess(MetaStructureAccess aStructureAccess) {
        if (aStructureAccess.selectedElement().refersToOtherElement() && aStructureAccess.selectedElement().referredElement() instanceof MetaTBFeld) {
            int endColumn;
            String id = aStructureAccess.selectedElement().referredElement().getId();
            int line = aStructureAccess.structureAccess().startLine();
            int column = aStructureAccess.structureAccess().startColumn();
            if (aStructureAccess.selectedElement() instanceof MetaFieldAccess) {
                MetaFieldAccess aFieldAccess = (MetaFieldAccess)aStructureAccess.selectedElement();
                endColumn = aFieldAccess.accessedField().startColumn() + aFieldAccess.accessedField().value().length();
            } else {
                MetaArrayAccess anArrayAccess = (MetaArrayAccess)aStructureAccess.selectedElement();
                endColumn = anArrayAccess.accessedArray().startColumn() + anArrayAccess.accessedArray().value().length();
            }
            int length = endColumn - column;
            this.replaceItems.add(new ReplaceItem(line, column, length, id));
        }
    }

    public void visitFieldAccess(MetaFieldAccess aFieldAccess) {
        if (aFieldAccess.refersToOtherElement() && aFieldAccess.referredElement() instanceof MetaTBFeld) {
            String id = aFieldAccess.referredElement().getId();
            int line = aFieldAccess.accessedField().startLine();
            int column = aFieldAccess.accessedField().startColumn();
            int length = aFieldAccess.accessedField().value().length();
            this.replaceItems.add(new ReplaceItem(line, column, length, id));
        }
    }

    public void visitArrayAccess(MetaArrayAccess anArrayAccess) {
        if (anArrayAccess.refersToOtherElement() && anArrayAccess.referredElement() instanceof MetaTBFeld) {
            String id = anArrayAccess.referredElement().getId();
            int line = anArrayAccess.accessedArray().startLine();
            int column = anArrayAccess.accessedArray().startColumn();
            int length = anArrayAccess.accessedArray().value().length();
            this.replaceItems.add(new ReplaceItem(line, column, length, id));
        }
        super.visitArrayAccess(anArrayAccess);
    }

    private class ReplaceItem {
        private int column = -1;
        private int line = -1;
        private int length = -1;
        private String fieldId = null;

        public ReplaceItem(int line, int column, int length, String fieldId) {
            this.line = line;
            this.column = column;
            this.length = length;
            this.fieldId = fieldId;
        }

        public int getColumn() {
            return this.column;
        }

        public int getLength() {
            return this.length;
        }

        public int getLine() {
            return this.line;
        }

        public String getFieldId() {
            return this.fieldId;
        }

        public int hashCode() {
            return (String.valueOf(this.line + this.column) + this.fieldId).hashCode();
        }

        public String toString() {
            return String.valueOf(this.fieldId) + " (line: " + this.line + ", column: " + this.column + ", length: " + this.length + ")";
        }
    }

    private class ReplaceItemComparator
    implements Comparator {
        private ReplaceItemComparator() {
        }

        public int compare(Object o1, Object o2) {
            ReplaceItem replaceItem1 = (ReplaceItem)o1;
            ReplaceItem replaceItem2 = (ReplaceItem)o2;
            int result = replaceItem1.getLine() - replaceItem2.getLine();
            if (result == 0) {
                result = replaceItem1.getColumn() - replaceItem2.getColumn();
            }
            return result;
        }
    }
}

