/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.doku;

import de.statspez.pleditor.generator.codegen.doku.BaseStat;
import de.statspez.pleditor.generator.codegen.doku.DokuElement;
import de.statspez.pleditor.generator.meta.generated.MetaStatspezObjekt;
import de.statspez.pleditor.generator.parser.Tags;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractStat
extends BaseStat {
    protected HashSet locked = new HashSet();
    protected HashSet noChecks = new HashSet();
    protected HashSet referenced = new HashSet();
    protected HashSet withAnnotation = new HashSet();
    protected ArrayList lockedList = null;
    protected ArrayList noChecksList = null;
    protected ArrayList notReferencedList = null;
    protected ArrayList referencedList = null;
    protected ArrayList withAnnotationList = null;
    protected String basePackageName = null;
    protected ArrayList notInBasePackageList = null;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.statspez.pleditor.generator.codegen.doku.AbstractStat");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public abstract void add(MetaStatspezObjekt var1);

    public boolean addToLocked(String id) {
        if (!$assertionsDisabled && !this.idElementTable.containsKey(id)) {
            throw new AssertionError((Object)("Das Merkmal mit der ID " + id + " ist noch nicht erfasst worden."));
        }
        return this.locked.add(id);
    }

    public boolean addToNoChecks(String id) {
        if (!$assertionsDisabled && !this.idElementTable.containsKey(id)) {
            throw new AssertionError((Object)("Das Merkmal mit der ID " + id + " ist noch nicht erfasst worden."));
        }
        return this.noChecks.add(id);
    }

    public boolean addToReferenced(String id) {
        if (!$assertionsDisabled && !this.idElementTable.containsKey(id)) {
            throw new AssertionError((Object)("Das Merkmal mit der ID " + id + " ist noch nicht erfasst worden."));
        }
        return this.referenced.add(id);
    }

    public boolean addToWithAnnotation(String id) {
        if (!$assertionsDisabled && !this.idElementTable.containsKey(id)) {
            throw new AssertionError((Object)("Das Merkmal mit der ID " + id + " ist noch nicht erfasst worden."));
        }
        return this.withAnnotation.add(id);
    }

    public void deleteLists() {
        super.deleteLists();
        this.lockedList = null;
        this.withAnnotationList = null;
        this.referencedList = null;
        this.notReferencedList = null;
        this.noChecksList = null;
    }

    public String getBasePackageName() {
        return this.basePackageName;
    }

    public int getChecksCount() {
        return this.idElementTable.size() - this.noChecks.size();
    }

    public HashSet getLocked() {
        return this.locked;
    }

    public int getLockedCount() {
        return this.locked.size();
    }

    public List getLockedList() {
        if (this.lockedList == null) {
            return this.resolveIds(this.locked);
        }
        return this.lockedList;
    }

    public HashSet getNoChecks() {
        return this.noChecks;
    }

    public int getNoChecksCount() {
        return this.noChecks.size();
    }

    public List getNoChecksList() {
        if (this.noChecksList == null) {
            ArrayList<DokuElement> tmpList = new ArrayList<DokuElement>();
            Iterator it = this.noChecks.iterator();
            while (it.hasNext()) {
                tmpList.add(this.getElement((String)it.next()));
            }
            return tmpList;
        }
        return this.noChecksList;
    }

    public int getNotInBasePackageCount(String basePackageName) {
        return this.getNotInBasePackageList(basePackageName).size();
    }

    public ArrayList getNotInBasePackageList(String basePackageName) {
        if (!basePackageName.equals(this.basePackageName)) {
            this.basePackageName = basePackageName;
            this.notInBasePackageList = new ArrayList();
            Iterator it = this.getElementList().iterator();
            while (it.hasNext()) {
                DokuElement de = (DokuElement)it.next();
                String elementPackage = Tags.dekodierePunkten(de.getElement().getMetaObjectContext().getObjectPakage());
                if (elementPackage.startsWith(basePackageName)) continue;
                this.notInBasePackageList.add(de);
            }
        }
        return this.notInBasePackageList;
    }

    public HashSet getNotReferenced() {
        HashSet<String> notReferenced = new HashSet<String>();
        Iterator it = this.idElementTable.keySet().iterator();
        while (it.hasNext()) {
            String iD = (String)it.next();
            if (this.referenced.contains(iD)) continue;
            notReferenced.add(iD);
        }
        return notReferenced;
    }

    public int getNotReferencedCount() {
        return this.idElementTable.size() - this.referenced.size();
    }

    public List getNotReferencedList() {
        if (this.notReferencedList == null) {
            return this.resolveIds(this.getNotReferenced());
        }
        return this.notReferencedList;
    }

    public HashSet getReferenced() {
        return this.referenced;
    }

    public int getReferencedCount() {
        return this.referenced.size();
    }

    public List getReferencedList() {
        if (this.referencedList == null) {
            ArrayList<DokuElement> tmpList = new ArrayList<DokuElement>();
            Iterator it = this.referenced.iterator();
            while (it.hasNext()) {
                tmpList.add(this.getElement((String)it.next()));
            }
            return tmpList;
        }
        return this.referencedList;
    }

    public HashSet getWithAnnotation() {
        return this.withAnnotation;
    }

    public int getWithAnnotationCount() {
        return this.withAnnotation.size();
    }

    public ArrayList getWithAnnotationList() {
        return this.withAnnotationList;
    }

    public void initializeLists() {
        this.initializeLists(false);
    }

    public void initializeLists(boolean force) {
        super.initializeLists(force);
        if (this.lockedList == null || force) {
            this.lockedList = new ArrayList();
            this.lockedList.addAll(this.resolveIds(this.locked));
        }
        if (this.withAnnotationList == null || force) {
            this.withAnnotationList = new ArrayList();
            this.withAnnotationList.addAll(this.resolveIds(this.withAnnotation));
        }
        if (this.referencedList == null || force) {
            this.referencedList = new ArrayList();
            this.referencedList.addAll(this.resolveIds(this.referenced));
        }
        if (this.notReferencedList == null || force) {
            this.notReferencedList = new ArrayList();
            this.notReferencedList.addAll(this.resolveIds(this.getNotReferenced()));
        }
        if (this.noChecksList == null || force) {
            this.noChecksList = new ArrayList();
            this.noChecksList.addAll(this.resolveIds(this.noChecks));
        }
    }

    public void setReferenced(HashSet checks) {
        this.referenced = checks;
    }

    public void sortLists() {
        super.initializeLists();
        this.initializeLists();
        this.sortListsOnly();
    }

    public void sortListsOnly() {
        super.sortListsOnly();
        Collections.sort(this.lockedList);
        Collections.sort(this.withAnnotationList);
        Collections.sort(this.referencedList);
        Collections.sort(this.notReferencedList);
        Collections.sort(this.noChecksList);
    }
}

