/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.diff.dialog;

import de.statspez.pleditor.generator.codegen.diff.DiffConfig;
import de.statspez.pleditor.generator.codegen.diff.dialog.DiffConfigComponent;
import de.statspez.pleditor.generator.codegen.diff.dialog.DiffConfigUIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class DiffConfigElementsPanel
extends JPanel
implements DiffConfigComponent {
    private static final long serialVersionUID = 8648314860960510947L;
    private List checkBoxes;
    private boolean dataChanged = false;

    public DiffConfigElementsPanel() {
        super(new GridBagLayout());
        this.init();
    }

    public void setDataFromDiffConfig(DiffConfig diffConfig) {
        int index = 0;
        while (index < this.checkBoxes.size()) {
            JCheckBox checkBox;
            int level = DiffConfigUIUtil.getErrorLevel((checkBox = (JCheckBox)this.checkBoxes.get(index)).getName(), diffConfig);
            checkBox.setSelected(level != 2);
            ++index;
        }
        this.dataChanged = false;
    }

    public void setDataToDiffConfig(DiffConfig diffConfig) {
        int index = 0;
        while (index < this.checkBoxes.size()) {
            int levelNeu;
            JCheckBox checkBox = (JCheckBox)this.checkBoxes.get(index);
            String title = checkBox.getName();
            int levelAlt = DiffConfigUIUtil.getErrorLevel(title, diffConfig);
            int n = levelNeu = checkBox.isSelected() ? 0 : 2;
            if (levelAlt != 2 && levelNeu == 2) {
                DiffConfigUIUtil.setErrorLevel(title, 2, diffConfig);
            } else if (levelAlt == 2 && levelNeu != 2) {
                DiffConfigUIUtil.setErrorLevel(title, 0, diffConfig);
            }
            ++index;
        }
    }

    public boolean isDataChanged() {
        return this.dataChanged;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        int i = 0;
        while (i < this.checkBoxes.size()) {
            JCheckBox checkBox = (JCheckBox)this.checkBoxes.get(i);
            checkBox.setEnabled(enabled);
            ++i;
        }
    }

    private void init() {
        this.checkBoxes = new ArrayList();
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DiffConfigElementsPanel.this.dataChanged = true;
            }
        };
        String[] diffConfigPropertyNames = DiffConfigUIUtil.getDiffConfigElementPropertyNames(false);
        int i = 0;
        while (i < diffConfigPropertyNames.length) {
            String name = diffConfigPropertyNames[i];
            JCheckBox checkBox = new JCheckBox(name);
            checkBox.setName(name);
            checkBox.addActionListener(actionListener);
            this.checkBoxes.add(checkBox);
            ++i;
        }
        this.initLayout();
    }

    private void initLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        JPanel panel = this.createGroupPanel(DiffConfigUIUtil.getDiffConfigPropertyNamesForMerkmal());
        this.add((Component)panel, gbc);
        ++gbc.gridy;
        panel = this.createGroupPanel(DiffConfigUIUtil.getDiffConfigPropertyNamesForThemenbereich());
        this.add((Component)panel, gbc);
        ++gbc.gridy;
        panel = this.createGroupPanel(DiffConfigUIUtil.getDiffConfigPropertyNamesForTBFeld());
        this.add((Component)panel, gbc);
        ++gbc.gridy;
        panel = this.createGroupPanel(DiffConfigUIUtil.getDiffConfigPropertyNamesForAuspraegungsgruppe());
        this.add((Component)panel, gbc);
        ++gbc.gridx;
        gbc.gridy = 0;
        panel = this.createGroupPanel(DiffConfigUIUtil.getDiffConfigPropertyNamesForFunktion());
        this.add((Component)panel, gbc);
        ++gbc.gridy;
        panel = this.createGroupPanel(DiffConfigUIUtil.getDiffConfigPropertyNamesForEigenschaft());
        this.add((Component)panel, gbc);
        ++gbc.gridy;
        panel = this.createGroupPanel(DiffConfigUIUtil.getDiffConfigPropertyNamesForPruefung());
        this.add((Component)panel, gbc);
        ++gbc.gridy;
        panel = this.createGroupPanel(DiffConfigUIUtil.getDiffConfigPropertyNamesForAblauf());
        this.add((Component)panel, gbc);
        ++gbc.gridx;
        gbc.gridy = 0;
        panel = this.createGroupPanel(DiffConfigUIUtil.getDiffConfigPropertyNamesForInitwert());
        this.add((Component)panel, gbc);
        ++gbc.gridy;
        panel = this.createGroupPanel(DiffConfigUIUtil.getDiffConfigPropertyNamesForVariable());
        this.add((Component)panel, gbc);
        ++gbc.gridy;
        panel = this.createGroupPanel(DiffConfigUIUtil.getDiffConfigPropertyNamesForMaterialreferenz());
        this.add((Component)panel, gbc);
    }

    private JPanel createGroupPanel(String[] names) {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        JCheckBox checkBox = null;
        int i = 0;
        while (i < names.length) {
            if (i == names.length - 1) {
                gbc.insets.bottom = 10;
            }
            if ((checkBox = this.getCheckBoxForName(names[i])) != null) {
                panel.add((Component)checkBox, gbc);
                ++gbc.gridy;
            }
            ++i;
        }
        JPanel panel1 = new JPanel(new BorderLayout());
        panel1.add((Component)panel, "North");
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)panel1, "West");
        return panel2;
    }

    private JCheckBox getCheckBoxForName(String name) {
        JCheckBox checkBox = null;
        int i = 0;
        while (i < this.checkBoxes.size()) {
            checkBox = (JCheckBox)this.checkBoxes.get(i);
            if (checkBox.getName().equals(name)) break;
            checkBox = null;
            ++i;
        }
        return checkBox;
    }
}

