/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.analysis.complexity.ui.treetable;

import de.statspez.pleditor.generator.codegen.analysis.complexity.ui.treetable.TreeTableModel;
import de.statspez.pleditor.generator.codegen.analysis.complexity.ui.treetable.TreeTableModelAdapter;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;

public class TreeTable
extends JTable
implements MouseListener {
    private static final long serialVersionUID = 3926242008334802669L;
    private static Border focusBorder = UIManager.getBorder("Table.focusCellHighlightBorder");
    private TreeTableCellRenderer tableRenderer = new TreeTableCellRenderer(this);
    static /* synthetic */ Class class$0;

    public TreeTable() {
        this(new DefaultTreeTableModel());
    }

    public TreeTable(TreeTableModel treeTableModel) {
        this.setModel(treeTableModel);
        this.tableRenderer.getTree().setSelectionModel(new DefaultTreeSelectionModel(){
            {
                TreeTable.this.setSelectionModel(this.listSelectionModel);
            }
        });
        this.setDefaultRenderer(treeTableModel.getClass(), this.tableRenderer);
        this.addMouseListener(this);
    }

    public void setModel(TreeTableModel treeTableModel) {
        this.tableRenderer.setModel(treeTableModel);
        this.setModel(new TreeTableModelAdapter(treeTableModel, this.tableRenderer.getTree()));
    }

    public void setTreeCellRenderer(TreeCellRenderer renderer) {
        this.tableRenderer.getTree().setCellRenderer(renderer);
    }

    public JTree getTree() {
        return this.tableRenderer.getTree();
    }

    public TreeTableCellRenderer getTreeTableCellRenderer() {
        return this.tableRenderer;
    }

    public int getEditingRow() {
        Class<?> clazz = this.getColumnClass(this.editingColumn);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("de.statspez.pleditor.generator.codegen.analysis.complexity.ui.treetable.TreeTableModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz == clazz2 ? -1 : this.editingRow;
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() > 1) {
            int selectedRow = this.getSelectedRow();
            if (selectedRow >= 0 && this.getSelectedColumn() == 0) {
                if (this.tableRenderer.getTree().isExpanded(selectedRow)) {
                    this.tableRenderer.getTree().collapseRow(selectedRow);
                } else {
                    this.tableRenderer.getTree().expandRow(selectedRow);
                }
            }
            this.setRowSelectionInterval(selectedRow, selectedRow);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    private static class DefaultTreeTableModel
    extends DefaultTreeModel
    implements TreeTableModel {
        public DefaultTreeTableModel() {
            super(null);
        }

        public int getColumnCount() {
            return 1;
        }

        public String getColumnName(int column) {
            return "Tree";
        }

        public Object getValueAt(Object node, int column) {
            return node;
        }

        public Class getColumnClass(int column) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("de.statspez.pleditor.generator.codegen.analysis.complexity.ui.treetable.TreeTableModel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }

        public boolean isCellEditable(Object node, int column) {
            return false;
        }

        public void setValueAt(Object aValue, Object node, int column) {
        }
    }

    private class TreeTableCellRenderer
    extends JComponent
    implements TableCellRenderer,
    LayoutManager {
        protected int visibleRow;
        protected boolean hasFocus;
        private JTable treeTable;
        private JTree tree;
        private int rowHeight;

        public TreeTableCellRenderer(JTable treeTable2) {
            this.treeTable = treeTable2;
            this.tree = new JTree();
            this.tree.setShowsRootHandles(true);
            this.rowHeight = treeTable2.getRowHeight();
            this.setOpaque(false);
            this.setLayout(this);
            this.add(this.tree);
        }

        public TreeTableCellRenderer(JTable treeTable2, TreeModel model) {
            this(treeTable2);
            this.setModel(model);
        }

        public void setModel(TreeModel model) {
            this.tree.setModel(model);
        }

        public JTree getTree() {
            return this.tree;
        }

        public void setBounds(int x, int y, int w, int h) {
            super.setBounds(x, 0, w, this.treeTable.getModel().getRowCount() * this.tree.getRowHeight() + this.rowHeight);
        }

        public void paint(Graphics g) {
            int deltaX = this.visibleRow * this.tree.getRowHeight() + this.tree.getRowHeight() - this.treeTable.getRowHeight() / 2;
            g.translate(0, -deltaX);
            super.paint(g);
            g.translate(0, deltaX);
            if (this.hasFocus) {
                focusBorder.paintBorder(this.tree, g, 0, 0, this.getWidth(), this.rowHeight - this.treeTable.getIntercellSpacing().height);
            }
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean isFocused, int row, int column) {
            this.visibleRow = row;
            this.hasFocus = isFocused;
            this.rowHeight = table.getRowHeight(row);
            this.tree.setRowHeight(this.rowHeight * 2);
            if (isSelected) {
                this.tree.setBackground(table.getSelectionBackground());
            } else {
                this.tree.setBackground(table.getBackground());
            }
            return this;
        }

        public void removeLayoutComponent(Component comp) {
        }

        public void layoutContainer(Container parent) {
            this.tree.setBounds(0, this.rowHeight, parent.getWidth(), parent.getHeight());
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public Dimension minimumLayoutSize(Container parent) {
            return null;
        }

        public Dimension preferredLayoutSize(Container parent) {
            return null;
        }
    }
}

