/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.analysis.complexity.ui.program;

import de.statspez.pleditor.generator.codegen.analysis.CrossReferenceBuilder;
import de.statspez.pleditor.generator.codegen.analysis.complexity.ui.DisplayNames;
import de.statspez.pleditor.generator.codegen.analysis.complexity.ui.program.ProgramComplexityNode;
import de.statspez.pleditor.generator.codegen.support.GenericSymbolDescriptorFactory;
import de.statspez.pleditor.generator.codegen.support.Scope;
import de.statspez.pleditor.generator.codegen.support.TbScopeBuilder;
import de.statspez.pleditor.generator.meta.AbstractElementVisitor;
import de.statspez.pleditor.generator.meta.InternalFunctions;
import de.statspez.pleditor.generator.meta.MetaAblaufStatement;
import de.statspez.pleditor.generator.meta.MetaArrayAccess;
import de.statspez.pleditor.generator.meta.MetaBoolean;
import de.statspez.pleditor.generator.meta.MetaBooleanOperator;
import de.statspez.pleditor.generator.meta.MetaBreakStatement;
import de.statspez.pleditor.generator.meta.MetaCheckFeldStatement;
import de.statspez.pleditor.generator.meta.MetaClassificationReference;
import de.statspez.pleditor.generator.meta.MetaConditionalStatement;
import de.statspez.pleditor.generator.meta.MetaContextOperator;
import de.statspez.pleditor.generator.meta.MetaCustomAblauf;
import de.statspez.pleditor.generator.meta.MetaCustomAuspraegung;
import de.statspez.pleditor.generator.meta.MetaCustomFunktion;
import de.statspez.pleditor.generator.meta.MetaCustomMerkmal;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.MetaCustomPruefung;
import de.statspez.pleditor.generator.meta.MetaCustomTBFeld;
import de.statspez.pleditor.generator.meta.MetaCustomThemenbereich;
import de.statspez.pleditor.generator.meta.MetaDate;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.MetaElementVisitor;
import de.statspez.pleditor.generator.meta.MetaErrorStatement;
import de.statspez.pleditor.generator.meta.MetaFactor;
import de.statspez.pleditor.generator.meta.MetaFieldAccess;
import de.statspez.pleditor.generator.meta.MetaForEachCheck;
import de.statspez.pleditor.generator.meta.MetaForEachIndexOperator;
import de.statspez.pleditor.generator.meta.MetaForEachLoop;
import de.statspez.pleditor.generator.meta.MetaForNextLoop;
import de.statspez.pleditor.generator.meta.MetaFunctionCall;
import de.statspez.pleditor.generator.meta.MetaHierarchicalForEachLoop;
import de.statspez.pleditor.generator.meta.MetaHierarchicalOperator;
import de.statspez.pleditor.generator.meta.MetaIdentifier;
import de.statspez.pleditor.generator.meta.MetaIndexOfOperator;
import de.statspez.pleditor.generator.meta.MetaInterval;
import de.statspez.pleditor.generator.meta.MetaLiteralAccess;
import de.statspez.pleditor.generator.meta.MetaMapStatement;
import de.statspez.pleditor.generator.meta.MetaMaterialAccess;
import de.statspez.pleditor.generator.meta.MetaMathOperator;
import de.statspez.pleditor.generator.meta.MetaMultiAssignment;
import de.statspez.pleditor.generator.meta.MetaNoValue;
import de.statspez.pleditor.generator.meta.MetaNumber;
import de.statspez.pleditor.generator.meta.MetaPrintStatement;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.MetaProgramParameter;
import de.statspez.pleditor.generator.meta.MetaPruefeStatement;
import de.statspez.pleditor.generator.meta.MetaRangeSeries;
import de.statspez.pleditor.generator.meta.MetaReturnStatement;
import de.statspez.pleditor.generator.meta.MetaRightValue;
import de.statspez.pleditor.generator.meta.MetaSelfAccess;
import de.statspez.pleditor.generator.meta.MetaSequence;
import de.statspez.pleditor.generator.meta.MetaSetStatement;
import de.statspez.pleditor.generator.meta.MetaSignOperator;
import de.statspez.pleditor.generator.meta.MetaSingleAssignment;
import de.statspez.pleditor.generator.meta.MetaSingleValueRange;
import de.statspez.pleditor.generator.meta.MetaSizeOfOperator;
import de.statspez.pleditor.generator.meta.MetaSizeTestingOperator;
import de.statspez.pleditor.generator.meta.MetaStatementSequence;
import de.statspez.pleditor.generator.meta.MetaString;
import de.statspez.pleditor.generator.meta.MetaStructureAccess;
import de.statspez.pleditor.generator.meta.MetaTestingOperator;
import de.statspez.pleditor.generator.meta.MetaTypeCheck;
import de.statspez.pleditor.generator.meta.MetaUnaryBoolOperator;
import de.statspez.pleditor.generator.meta.MetaValueAccess;
import de.statspez.pleditor.generator.meta.MetaVarDeclaration;
import de.statspez.pleditor.generator.meta.MetaWhileLoop;
import de.statspez.pleditor.generator.meta.MetaWithOperator;
import de.statspez.pleditor.generator.meta.generated.MetaAuspraegung;
import de.statspez.pleditor.generator.meta.generated.MetaAuspraegungsgruppe;
import de.statspez.pleditor.generator.meta.generated.MetaAuspraegungsgruppeComps;
import de.statspez.pleditor.generator.meta.generated.MetaDsbComps;
import de.statspez.pleditor.generator.meta.generated.MetaDsbFeld;
import de.statspez.pleditor.generator.meta.generated.MetaDsbKommentar;
import de.statspez.pleditor.generator.meta.generated.MetaDsbMultiKommentar;
import de.statspez.pleditor.generator.meta.generated.MetaDsbObjekt;
import de.statspez.pleditor.generator.meta.generated.MetaDsbZeilenKommentar;
import de.statspez.pleditor.generator.meta.generated.MetaEinzelfeld;
import de.statspez.pleditor.generator.meta.generated.MetaMapping;
import de.statspez.pleditor.generator.meta.generated.MetaMappingElement;
import de.statspez.pleditor.generator.meta.generated.MetaMerkmal;
import de.statspez.pleditor.generator.meta.generated.MetaPLAblauf;
import de.statspez.pleditor.generator.meta.generated.MetaPLAuspraegung;
import de.statspez.pleditor.generator.meta.generated.MetaPLEigenschaft;
import de.statspez.pleditor.generator.meta.generated.MetaPLFunktion;
import de.statspez.pleditor.generator.meta.generated.MetaPLInitwert;
import de.statspez.pleditor.generator.meta.generated.MetaPLMaterial;
import de.statspez.pleditor.generator.meta.generated.MetaPLParameter;
import de.statspez.pleditor.generator.meta.generated.MetaPLPruefung;
import de.statspez.pleditor.generator.meta.generated.MetaPLVariable;
import de.statspez.pleditor.generator.meta.generated.MetaPlausibilisierung;
import de.statspez.pleditor.generator.meta.generated.MetaRawDataSet;
import de.statspez.pleditor.generator.meta.generated.MetaRawField;
import de.statspez.pleditor.generator.meta.generated.MetaRawFieldGroup;
import de.statspez.pleditor.generator.meta.generated.MetaRawSet;
import de.statspez.pleditor.generator.meta.generated.MetaRefAuspraegung;
import de.statspez.pleditor.generator.meta.generated.MetaSatzart;
import de.statspez.pleditor.generator.meta.generated.MetaStatspezKomponente;
import de.statspez.pleditor.generator.meta.generated.MetaStatspezObjekt;
import de.statspez.pleditor.generator.meta.generated.MetaTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaTBMaterialReferenz;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ProgramComplexityNodeBuilder {
    private static final Icon ICON_ABLAUF;
    private static final Icon ICON_FUNCTION;
    private static final Icon ICON_EIGENSCHAFT;
    private static final Icon ICON_MERKMAL;
    private static final Icon ICON_PLAUSI;
    private static final Icon ICON_PRUEFUNG;
    private static final Icon ICON_THEMENBEREICH;
    private static final Icon ICON_AUSPRAEGUNGSGRUPPE;
    private static final Icon ICON_AUSPRAEGUNG;
    private Resolver resolver;
    private DisplayNames displayNames;
    private ProgramComplexityNode rootNode;
    private Stack currentNode;
    private Stack inProgramm;
    private String prefixDannSonst;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.statspez.pleditor.generator.codegen.diff.DiffElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ICON_ABLAUF = new ImageIcon(clazz.getResource("/de/statspez/pleditor/generator/images/ablauf.gif"));
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("de.statspez.pleditor.generator.codegen.diff.DiffElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ICON_FUNCTION = new ImageIcon(clazz2.getResource("/de/statspez/pleditor/generator/images/funktion.gif"));
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("de.statspez.pleditor.generator.codegen.diff.DiffElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ICON_EIGENSCHAFT = new ImageIcon(clazz3.getResource("/de/statspez/pleditor/generator/images/eigenschaft.gif"));
        Class<?> clazz4 = class$0;
        if (clazz4 == null) {
            try {
                clazz4 = class$0 = Class.forName("de.statspez.pleditor.generator.codegen.diff.DiffElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ICON_MERKMAL = new ImageIcon(clazz4.getResource("/de/statspez/pleditor/generator/images/merkmal.gif"));
        ICON_PLAUSI = null;
        Class<?> clazz5 = class$0;
        if (clazz5 == null) {
            try {
                clazz5 = class$0 = Class.forName("de.statspez.pleditor.generator.codegen.diff.DiffElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ICON_PRUEFUNG = new ImageIcon(clazz5.getResource("/de/statspez/pleditor/generator/images/pruefung.gif"));
        Class<?> clazz6 = class$0;
        if (clazz6 == null) {
            try {
                clazz6 = class$0 = Class.forName("de.statspez.pleditor.generator.codegen.diff.DiffElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ICON_THEMENBEREICH = new ImageIcon(clazz6.getResource("/de/statspez/pleditor/generator/images/themenbereich.gif"));
        Class<?> clazz7 = class$0;
        if (clazz7 == null) {
            try {
                clazz7 = class$0 = Class.forName("de.statspez.pleditor.generator.codegen.diff.DiffElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ICON_AUSPRAEGUNGSGRUPPE = new ImageIcon(clazz7.getResource("/de/statspez/pleditor/generator/images/auspraegungsgruppe.gif"));
        Class<?> clazz8 = class$0;
        if (clazz8 == null) {
            try {
                clazz8 = class$0 = Class.forName("de.statspez.pleditor.generator.codegen.diff.DiffElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ICON_AUSPRAEGUNG = new ImageIcon(clazz8.getResource("/de/statspez/pleditor/generator/images/auspraegung.gif"));
    }

    public synchronized ProgramComplexityNode build(MetaCustomPlausibilisierung plausi) {
        TbScopeBuilder scopeBuilder = new TbScopeBuilder(new GenericSymbolDescriptorFactory());
        Hashtable tbScopes = new Hashtable();
        Scope scope = scopeBuilder.createScopes(plausi, tbScopes);
        CrossReferenceBuilder crossReferenceBuilder = new CrossReferenceBuilder();
        crossReferenceBuilder.buildCrossReference(plausi, scope, tbScopes);
        this.resolver = new Resolver();
        this.displayNames = new DisplayNames();
        this.resolver.setRootThemenbereich((MetaCustomThemenbereich)plausi.rootThemenbereich());
        plausi.accept(this.resolver);
        return (ProgramComplexityNode)this.currentNode.peek();
    }

    private void startLevel(String name, MetaElement element, boolean frequencyEnabled) {
        Icon icon = null;
        int startLine = element.startLine();
        int startColumn = element.startColumn();
        int endLine = element.endLine();
        int endColumn = element.endColumn();
        String classificationKode = null;
        this.startLevel(name, icon, element, startLine, startColumn, endLine, endColumn, classificationKode, frequencyEnabled);
    }

    private void startLevel(MetaElement element) {
        String name = null;
        Icon icon = null;
        int startLine = element.startLine();
        int startColumn = element.startColumn();
        int endLine = element.endLine();
        int endColumn = element.endColumn();
        String classificationKode = null;
        boolean frequencyEnabled = false;
        this.startLevel(name, icon, element, startLine, startColumn, endLine, endColumn, classificationKode, frequencyEnabled);
    }

    private void startLevel(String name, Icon icon, MetaElement element, boolean frequencyEnabled) {
        int startLine = element.startLine();
        int startColumn = element.startColumn();
        int endLine = element.endLine();
        int endColumn = element.endColumn();
        String classificationKode = null;
        this.startLevel(name, icon, element, startLine, startColumn, endLine, endColumn, classificationKode, frequencyEnabled);
    }

    private void startLevel(String name, Icon icon, MetaElement element, String classificationKode, boolean frequencyEnabled) {
        int startLine = element.startLine();
        int startColumn = element.startColumn();
        int endLine = element.endLine();
        int endColumn = element.endColumn();
        this.startLevel(name, icon, element, startLine, startColumn, endLine, endColumn, classificationKode, frequencyEnabled);
    }

    private void startLevel(MetaElement element, int startLine, int startColumn, int endLine, int endColumn) {
        String name = null;
        Icon icon = null;
        String classificationKode = null;
        boolean frequencyEnabled = false;
        this.startLevel(name, icon, element, startLine, startColumn, endLine, endColumn, classificationKode, frequencyEnabled);
    }

    private void startLevel(String name, Icon icon, MetaElement element, int startLine, int startColumn, int endLine, int endColumn, String classificationKode, boolean frequencyEnabled) {
        if (name == null) {
            name = this.displayNames.getDisplayName(element);
        }
        name = String.valueOf(name) + this.getHinweis(startLine, startColumn, endLine, endColumn);
        ProgramComplexityNode node = new ProgramComplexityNode((ProgramComplexityNode)this.currentNode.peek(), element, name, icon, classificationKode, frequencyEnabled);
        this.currentNode.push(node);
    }

    private void endLevel(MetaElement metaElement) {
        ProgramComplexityNode node = (ProgramComplexityNode)this.currentNode.pop();
        if (node.getElement() != metaElement) {
            throw new RuntimeException("Fehler!!!");
        }
    }

    private void startEndLevel(MetaElement element) {
        String name = null;
        Icon icon = null;
        this.startEndLevel(name, icon, element);
    }

    private void startEndLevel(String elName, Icon icon, MetaElement element) {
        int startLine = element.startLine();
        int startColumn = element.startColumn();
        int endLine = element.endLine();
        int endColumn = element.endColumn();
        boolean frequencyEnabled = false;
        String classificationKode = null;
        this.startLevel(elName, icon, element, startLine, startColumn, endLine, endColumn, classificationKode, frequencyEnabled);
        this.endLevel(element);
    }

    private String getHinweis(int startLine, int startColumn, int endLine, int endColumn) {
        if (startLine == -1) {
            return "";
        }
        int laenge = 30;
        String result = null;
        ProgramComplexityNode node = (ProgramComplexityNode)this.currentNode.peek();
        String plSpezifikation = null;
        while (node.getElement() != null) {
            if (node.getPLSpezification() != null) {
                plSpezifikation = node.getPLSpezification();
                break;
            }
            node = (ProgramComplexityNode)node.getParent();
        }
        if (plSpezifikation != null) {
            int beginnIndex = this.getSourcePosition(startLine, startColumn, plSpezifikation);
            int endIndex = this.getSourcePosition(endLine, endColumn, plSpezifikation);
            if (beginnIndex != -1 && endIndex != -1 && endIndex > beginnIndex) {
                result = plSpezifikation.substring(beginnIndex, endIndex + 1);
                int i = result.indexOf("\n");
                if (i != -1) {
                    result = result.substring(0, i);
                }
                if (result.length() > laenge) {
                    result = result.substring(0, laenge);
                }
                result = String.valueOf(result) + "...";
            }
        }
        result = result == null ? "" : " (" + result + ")";
        return result;
    }

    private int getSourcePosition(int line, int column, String source) {
        int currentPos = 0;
        int currentLine = 1;
        int currentCol = 1;
        while ((currentLine != line || currentCol != column) && currentPos < source.length()) {
            if (currentPos >= source.length()) continue;
            if (source.charAt(currentPos) == '\n') {
                ++currentLine;
                currentCol = 1;
            } else {
                ++currentCol;
            }
            ++currentPos;
        }
        if (currentPos >= source.length()) {
            currentPos = -1;
        }
        return currentPos;
    }

    private class FieldNamensExtractor
    extends AbstractElementVisitor {
        private StringBuffer name;

        private FieldNamensExtractor() {
        }

        public String getName(MetaCheckFeldStatement aStatement) {
            this.name = new StringBuffer();
            aStatement.field().accept(this);
            return this.name.toString();
        }

        public void visitFieldAccess(MetaFieldAccess aFieldAccess) {
            if (this.name.length() > 0) {
                this.name.append('.');
            }
            this.name.append(aFieldAccess.accessedField().value());
        }

        public void visitStructureAccess(MetaStructureAccess aStructureAccess) {
            aStructureAccess.structureAccess().accept(this);
            aStructureAccess.selectedElement().accept(this);
        }
    }

    private class Resolver
    implements MetaElementVisitor {
        private boolean frequencyEnabled;
        private MetaCustomThemenbereich rootThemenbereich;

        private Resolver() {
        }

        public void setRootThemenbereich(MetaCustomThemenbereich rootThemenbereich) {
            this.rootThemenbereich = rootThemenbereich;
        }

        public void visitFieldAccess(MetaFieldAccess aFieldAccess) {
            ProgramComplexityNodeBuilder.this.startEndLevel(aFieldAccess);
        }

        public void visitLiteralAccess(MetaLiteralAccess anAccess) {
            anAccess.accessedLiteral().accept(this);
        }

        public void visitClassificationReference(MetaClassificationReference aReference) {
            ProgramComplexityNodeBuilder.this.startLevel(aReference);
            MetaElement metaElement = aReference.referredElement();
            metaElement.accept(this);
            aReference.setFunctionalComplexity(metaElement.getFunctionalComplexity());
            ProgramComplexityNodeBuilder.this.endLevel(aReference);
        }

        public void visitAuspraegungsgruppe(MetaAuspraegungsgruppe anObject) {
            ProgramComplexityNodeBuilder.this.startLevel(anObject.getName(), ICON_AUSPRAEGUNGSGRUPPE, anObject, false);
            if (!this.inProgramm()) {
                MetaAuspraegungsgruppeComps comps = anObject.getAuspraegungsComps();
                comps.accept(this);
            }
            ProgramComplexityNodeBuilder.this.endLevel(anObject);
        }

        public void visitPLAuspraegung(MetaPLAuspraegung classification) {
            if (this.inProgramm()) {
                ProgramComplexityNodeBuilder.this.startLevel(classification.getName(), ICON_AUSPRAEGUNG, classification, false);
                ProgramComplexityNodeBuilder.this.endLevel(classification);
            } else {
                MetaCustomAuspraegung myClassi = (MetaCustomAuspraegung)classification;
                if (myClassi.sizeOfAuspraegungen() > 0) {
                    ProgramComplexityNodeBuilder.this.startLevel(classification.getName(), ICON_AUSPRAEGUNG, classification, false);
                    int i = 0;
                    while (i < classification.sizeOfAuspraegungen()) {
                        MetaAuspraegung metaAuspraegung = classification.getFromAuspraegungen(i);
                        metaAuspraegung.accept(this);
                        ++i;
                    }
                    ProgramComplexityNodeBuilder.this.endLevel(classification);
                } else {
                    String classificationKode = myClassi.getPlainClassificationKode();
                    ProgramComplexityNodeBuilder.this.startLevel(classification.getName(), ICON_AUSPRAEGUNG, classification, classificationKode, false);
                    MetaProgram metaProgram = myClassi.getKodeSpezifikation();
                    metaProgram.accept(this);
                    ProgramComplexityNodeBuilder.this.endLevel(classification);
                }
            }
        }

        public void visitRangeSeries(MetaRangeSeries aRangeSeries) {
            ProgramComplexityNodeBuilder.this.startLevel(aRangeSeries);
            Iterator it = aRangeSeries.ranges();
            while (it.hasNext()) {
                MetaElement tmp = (MetaElement)it.next();
                tmp.accept(this);
            }
            ProgramComplexityNodeBuilder.this.endLevel(aRangeSeries);
        }

        public void visitSingleValueRange(MetaSingleValueRange aRange) {
            MetaFactor value = aRange.value();
            this.visitMetaFaktor(value);
        }

        public void visitSequence(MetaSequence aSequence) {
            ProgramComplexityNodeBuilder.this.startLevel(aSequence);
            this.visitMetaFaktor(aSequence.first());
            this.visitMetaFaktor(aSequence.second());
            this.visitMetaFaktor(aSequence.last());
            ProgramComplexityNodeBuilder.this.endLevel(aSequence);
        }

        public void visitInterval(MetaInterval anInterval) {
            ProgramComplexityNodeBuilder.this.startLevel(anInterval);
            this.visitMetaFaktor(anInterval.first());
            this.visitMetaFaktor(anInterval.last());
            ProgramComplexityNodeBuilder.this.endLevel(anInterval);
        }

        public void visitArrayAccess(MetaArrayAccess anArrayAccess) {
            ProgramComplexityNodeBuilder.this.startLevel(anArrayAccess);
            Iterator it = anArrayAccess.indices();
            while (it.hasNext()) {
                MetaElement tmp = (MetaElement)it.next();
                if (tmp instanceof MetaFactor) {
                    this.visitMetaFaktor((MetaFactor)tmp);
                    continue;
                }
                tmp.accept(this);
            }
            ProgramComplexityNodeBuilder.this.endLevel(anArrayAccess);
        }

        public void visitStructureAccess(MetaStructureAccess aStructureAccess) {
            ProgramComplexityNodeBuilder.this.startLevel(aStructureAccess);
            aStructureAccess.structureAccess().accept(this);
            aStructureAccess.selectedElement().accept(this);
            ProgramComplexityNodeBuilder.this.endLevel(aStructureAccess);
        }

        public void visitMaterialAccess(MetaMaterialAccess anAccess) {
            MetaElement tmp;
            this.setFrequencyEnabled(true);
            ProgramComplexityNodeBuilder.this.startLevel(anAccess);
            this.setFrequencyEnabled(false);
            anAccess.material().accept(this);
            Iterator it = anAccess.selectedFields();
            while (it.hasNext()) {
                tmp = (MetaElement)it.next();
                tmp.accept(this);
            }
            it = anAccess.selectionConditions();
            while (it.hasNext()) {
                tmp = (MetaElement)it.next();
                tmp.accept(this);
            }
            ProgramComplexityNodeBuilder.this.endLevel(anAccess);
        }

        public void visitStatementSequence(MetaStatementSequence aSequence) {
            String name;
            if (ProgramComplexityNodeBuilder.this.prefixDannSonst != null) {
                name = String.valueOf(ProgramComplexityNodeBuilder.this.prefixDannSonst) + "-" + ProgramComplexityNodeBuilder.this.displayNames.getDisplayName(aSequence);
                ProgramComplexityNodeBuilder.this.prefixDannSonst = null;
            } else {
                name = null;
            }
            ProgramComplexityNodeBuilder.this.startLevel(name, aSequence, this.isFrequencyEnabled());
            this.setFrequencyEnabled(false);
            Iterator it = aSequence.statements();
            while (it.hasNext()) {
                MetaElement metaElement = (MetaElement)it.next();
                metaElement.accept(this);
            }
            ProgramComplexityNodeBuilder.this.endLevel(aSequence);
        }

        public void visitSingleAssignment(MetaSingleAssignment anAssignment) {
            ProgramComplexityNodeBuilder.this.startLevel(anAssignment);
            MetaValueAccess leftValue = anAssignment.leftValue();
            leftValue.accept(this);
            MetaRightValue rightValue = anAssignment.rightValue();
            this.visitMetaRightValue(rightValue);
            ProgramComplexityNodeBuilder.this.endLevel(anAssignment);
        }

        public void visitMultiAssignment(MetaMultiAssignment anAssignment) {
            ProgramComplexityNodeBuilder.this.startLevel(anAssignment);
            Iterator it = anAssignment.leftValues();
            while (it.hasNext()) {
                MetaElement tmp = (MetaElement)it.next();
                tmp.accept(this);
            }
            this.visitMetaRightValue(anAssignment.rightValue());
            ProgramComplexityNodeBuilder.this.endLevel(anAssignment);
        }

        public void visitConditionalStatement(MetaConditionalStatement aStatement) {
            MetaStatementSequence falseStatementSequence;
            ProgramComplexityNodeBuilder.this.startLevel(aStatement);
            this.visitMetaFaktor(aStatement.condition());
            MetaStatementSequence trueStatementSequence = aStatement.ifTrue();
            if (trueStatementSequence.numberOfStatements() > 0) {
                ProgramComplexityNodeBuilder.this.prefixDannSonst = "Dann";
                this.setFrequencyEnabled(true);
                trueStatementSequence.accept(this);
            }
            if ((falseStatementSequence = aStatement.ifFalse()).numberOfStatements() > 0) {
                ProgramComplexityNodeBuilder.this.prefixDannSonst = "Sonst";
                this.setFrequencyEnabled(true);
                falseStatementSequence.accept(this);
            }
            ProgramComplexityNodeBuilder.this.endLevel(aStatement);
        }

        public void visitForNextLoop(MetaForNextLoop aStatement) {
            ProgramComplexityNodeBuilder.this.startLevel(aStatement);
            aStatement.startAssignment().accept(this);
            this.visitMetaFaktor(aStatement.endCondition());
            this.visitMetaFaktor(aStatement.stepExpression());
            this.setFrequencyEnabled(true);
            aStatement.loopBody().accept(this);
            ProgramComplexityNodeBuilder.this.endLevel(aStatement);
        }

        public void visitForEachLoop(MetaForEachLoop aStatement) {
            ProgramComplexityNodeBuilder.this.startLevel(aStatement);
            Iterator it = aStatement.variables();
            while (it != null && it.hasNext()) {
                MetaElement metaElement = (MetaElement)it.next();
                metaElement.accept(this);
            }
            MetaFactor metaFactor = aStatement.value();
            this.visitMetaFaktor(metaFactor);
            this.setFrequencyEnabled(true);
            aStatement.loopBody().accept(this);
            ProgramComplexityNodeBuilder.this.endLevel(aStatement);
        }

        public void visitForEachCheck(MetaForEachCheck aStatement) {
            ProgramComplexityNodeBuilder.this.startLevel(aStatement);
            Iterator it = aStatement.variables();
            while (it != null && it.hasNext()) {
                MetaElement metaElement = (MetaElement)it.next();
                metaElement.accept(this);
            }
            this.visitMetaFaktor(aStatement.value());
            this.visitMetaFaktor(aStatement.condition());
            ProgramComplexityNodeBuilder.this.endLevel(aStatement);
        }

        public void visitWhileLoop(MetaWhileLoop aStatement) {
            ProgramComplexityNodeBuilder.this.startLevel(aStatement);
            this.visitMetaFaktor(aStatement.condition());
            this.setFrequencyEnabled(true);
            aStatement.loopBody().accept(this);
            ProgramComplexityNodeBuilder.this.endLevel(aStatement);
        }

        public void visitPrintStatement(MetaPrintStatement aStatement) {
            ProgramComplexityNodeBuilder.this.startLevel(aStatement);
            Iterator it = aStatement.toPrint();
            while (it.hasNext()) {
                MetaElement tmp = (MetaElement)it.next();
                if (tmp instanceof MetaFactor) {
                    this.visitMetaFaktor((MetaFactor)tmp);
                    continue;
                }
                tmp.accept(this);
            }
            ProgramComplexityNodeBuilder.this.endLevel(aStatement);
        }

        public void visitPruefeStatement(MetaPruefeStatement aStatement) {
            ProgramComplexityNodeBuilder.this.startLevel(aStatement, aStatement.startLine(), aStatement.startColumn(), aStatement.function().endLine(), aStatement.function().endColumn());
            MetaCustomPruefung metaCustomPruefung = (MetaCustomPruefung)aStatement.referredElement();
            metaCustomPruefung.accept(this);
            ProgramComplexityNodeBuilder.this.endLevel(aStatement);
        }

        public void visitAblaufStatement(MetaAblaufStatement aStatement) {
            ProgramComplexityNodeBuilder.this.startLevel(aStatement);
            MetaCustomAblauf metaCustomAblauf = (MetaCustomAblauf)aStatement.referredElement();
            metaCustomAblauf.accept(this);
            ProgramComplexityNodeBuilder.this.endLevel(aStatement);
        }

        public void visitCheckFeldStatement(MetaCheckFeldStatement aStatement) {
            String name = ProgramComplexityNodeBuilder.this.displayNames.getDisplayName(aStatement);
            FieldNamensExtractor namensExtractor = new FieldNamensExtractor();
            name = String.valueOf(name) + " (" + namensExtractor.getName(aStatement) + ")";
            ProgramComplexityNodeBuilder.this.startLevel(name, aStatement, false);
            aStatement.field().accept(this);
            MetaCustomTBFeld tbfeld = (MetaCustomTBFeld)aStatement.referredElement();
            MetaCustomMerkmal merkmal = (MetaCustomMerkmal)tbfeld.getKlasse();
            merkmal.accept(this);
            ProgramComplexityNodeBuilder.this.endLevel(aStatement);
        }

        public void visitReturnStatement(MetaReturnStatement aStatement) {
            ProgramComplexityNodeBuilder.this.startLevel(aStatement);
            this.visitMetaFaktor(aStatement.returnValue());
            ProgramComplexityNodeBuilder.this.endLevel(aStatement);
        }

        public void visitFunctionCall(MetaFunctionCall aStatement) {
            ProgramComplexityNodeBuilder.this.startLevel(aStatement);
            Iterator it = aStatement.parameters();
            while (it != null && it.hasNext()) {
                MetaElement metaElement = (MetaElement)it.next();
                if (metaElement instanceof MetaFactor) {
                    this.visitMetaFaktor((MetaFactor)metaElement);
                    continue;
                }
                metaElement.accept(this);
            }
            if (!InternalFunctions.instance().identifiesInternalFunction(aStatement.function())) {
                MetaCustomFunktion metaCustomFunktion = (MetaCustomFunktion)aStatement.referredElement();
                metaCustomFunktion.accept(this);
            }
            ProgramComplexityNodeBuilder.this.endLevel(aStatement);
        }

        public void visitProgram(MetaProgram aProgram) {
            ProgramComplexityNodeBuilder.this.inProgramm.push("true");
            this.visitElements(aProgram.statements().statements());
            ProgramComplexityNodeBuilder.this.inProgramm.pop();
        }

        public void visitVarDeclaration(MetaVarDeclaration aDeclaration) {
            ProgramComplexityNodeBuilder.this.startLevel(aDeclaration);
            Iterator ids = aDeclaration.identifiers();
            while (ids.hasNext()) {
                MetaElement tmp = (MetaElement)ids.next();
                tmp.accept(this);
            }
            ProgramComplexityNodeBuilder.this.endLevel(aDeclaration);
        }

        public void visitMathOperator(MetaMathOperator anOperator) {
            ProgramComplexityNodeBuilder.this.startLevel(anOperator);
            this.visitMetaFaktor(anOperator.firstOperand());
            this.visitMetaFaktor(anOperator.secondOperand());
            ProgramComplexityNodeBuilder.this.endLevel(anOperator);
        }

        public void visitSignOperator(MetaSignOperator anOperator) {
            ProgramComplexityNodeBuilder.this.startLevel(anOperator);
            this.visitMetaFaktor(anOperator.operand());
            ProgramComplexityNodeBuilder.this.endLevel(anOperator);
        }

        public void visitUnaryBoolOperator(MetaUnaryBoolOperator anOperator) {
            ProgramComplexityNodeBuilder.this.startLevel(anOperator);
            this.visitMetaFaktor(anOperator.operand());
            ProgramComplexityNodeBuilder.this.endLevel(anOperator);
        }

        public void visitBooleanOperator(MetaBooleanOperator anOperator) {
            ProgramComplexityNodeBuilder.this.startLevel(anOperator);
            this.visitMetaFaktor(anOperator.firstOperand());
            this.visitMetaFaktor(anOperator.secondOperand());
            ProgramComplexityNodeBuilder.this.endLevel(anOperator);
        }

        public void visitTestingOperator(MetaTestingOperator anOperator) {
            ProgramComplexityNodeBuilder.this.startLevel(anOperator);
            this.visitMetaFaktor(anOperator.firstOperand());
            this.visitMetaFaktor(anOperator.secondOperand());
            ProgramComplexityNodeBuilder.this.endLevel(anOperator);
        }

        public void visitSizeOfOperator(MetaSizeOfOperator anOperator) {
            ProgramComplexityNodeBuilder.this.startLevel(anOperator);
            this.visitMetaFaktor(anOperator.operand());
            ProgramComplexityNodeBuilder.this.endLevel(anOperator);
        }

        public void visitIndexOfOperator(MetaIndexOfOperator anOperator) {
            ProgramComplexityNodeBuilder.this.startLevel(anOperator);
            this.visitMetaFaktor(anOperator.operand());
            ProgramComplexityNodeBuilder.this.endLevel(anOperator);
        }

        public void visitTypeCheck(MetaTypeCheck typeCheck) {
            ProgramComplexityNodeBuilder.this.startLevel(typeCheck);
            this.visitMetaFaktor(typeCheck.value());
            if (typeCheck.maske() != null) {
                typeCheck.maske().accept(this);
            }
            ProgramComplexityNodeBuilder.this.endLevel(typeCheck);
        }

        public void visitSetStatement(MetaSetStatement aSetStatemnt) {
            ProgramComplexityNodeBuilder.this.startLevel(aSetStatemnt);
            ProgramComplexityNodeBuilder.this.endLevel(aSetStatemnt);
        }

        public void visitPLPruefung(MetaPLPruefung anObject) {
            MetaCustomPruefung metaCustomPruefung = (MetaCustomPruefung)anObject;
            ProgramComplexityNodeBuilder.this.startLevel(anObject.getName(), ICON_PRUEFUNG, anObject, metaCustomPruefung.getPLSpezifikation(), false);
            if (!this.inProgramm()) {
                metaCustomPruefung.getMetaSpezifikation().accept(this);
            }
            ProgramComplexityNodeBuilder.this.endLevel(anObject);
        }

        public void visitDsbObjekt(MetaDsbObjekt anObject) {
        }

        public void visitEinzelfeld(MetaEinzelfeld anObject) {
        }

        public void visitRawField(MetaRawField anObject) {
        }

        public void visitAuspraegungsgruppeComps(MetaAuspraegungsgruppeComps anObject) {
            Iterator it = anObject.getAuspraegungen();
            while (it.hasNext()) {
                MetaAuspraegung metaAuspraegung = (MetaAuspraegung)it.next();
                metaAuspraegung.accept(this);
            }
        }

        public void visitPLAblauf(MetaPLAblauf anObject) {
            MetaCustomAblauf metaCustomAblauf = (MetaCustomAblauf)anObject;
            ProgramComplexityNodeBuilder.this.startLevel(metaCustomAblauf.getName(), ICON_ABLAUF, anObject, metaCustomAblauf.getSpezifikation(), false);
            if (!this.inProgramm()) {
                metaCustomAblauf.getMetaSpezifikation().accept(this);
            }
            ProgramComplexityNodeBuilder.this.endLevel(anObject);
        }

        public void visitAuspraegung(MetaAuspraegung anObject) {
        }

        public void visitDsbFeld(MetaDsbFeld anObject) {
        }

        public void visitStatspezKomponente(MetaStatspezKomponente anObject) {
        }

        public void visitDsbMultiKommentar(MetaDsbMultiKommentar anObject) {
        }

        public void visitPlausibilisierung(MetaPlausibilisierung anObject) {
            ProgramComplexityNodeBuilder.this.rootNode = new ProgramComplexityNode(null, (MetaElement)anObject, anObject.getPLName(), ICON_PLAUSI, "Plausibilisierung", false);
            ProgramComplexityNodeBuilder.this.inProgramm = new Stack();
            ProgramComplexityNodeBuilder.this.currentNode = new Stack();
            ProgramComplexityNodeBuilder.this.currentNode.push(ProgramComplexityNodeBuilder.this.rootNode);
            ProgramComplexityNode merkmaleNode = new ProgramComplexityNode((ProgramComplexityNode)ProgramComplexityNodeBuilder.this.currentNode.peek(), null, "Merkmale", null, null, false);
            ProgramComplexityNodeBuilder.this.currentNode.push(merkmaleNode);
            this.visitElements(anObject.getMerkmale());
            ProgramComplexityNodeBuilder.this.currentNode.pop();
            ProgramComplexityNode apgsNode = new ProgramComplexityNode((ProgramComplexityNode)ProgramComplexityNodeBuilder.this.currentNode.peek(), null, "Auspr\u00e4gungsgruppen", null, null, false);
            ProgramComplexityNodeBuilder.this.currentNode.push(apgsNode);
            this.visitElements(anObject.getAuspraegungsgruppen());
            ProgramComplexityNodeBuilder.this.currentNode.pop();
            ProgramComplexityNode tbsNode = new ProgramComplexityNode((ProgramComplexityNode)ProgramComplexityNodeBuilder.this.currentNode.peek(), null, "Themenbereiche", null, null, false);
            ProgramComplexityNodeBuilder.this.currentNode.push(tbsNode);
            this.visitElements(anObject.getThemenbereiche());
            ProgramComplexityNodeBuilder.this.currentNode.pop();
            ProgramComplexityNode funktionsNode = new ProgramComplexityNode((ProgramComplexityNode)ProgramComplexityNodeBuilder.this.currentNode.peek(), null, "Funktionen", null, null, false);
            ProgramComplexityNodeBuilder.this.currentNode.push(funktionsNode);
            this.visitElements(anObject.getFunktionen());
            ProgramComplexityNodeBuilder.this.currentNode.pop();
        }

        public void visitPLInitwert(MetaPLInitwert anObject) {
        }

        public void visitStatspezObjekt(MetaStatspezObjekt anObject) {
        }

        public void visitPLEigenschaft(MetaPLEigenschaft anObject) {
        }

        public void visitDsbKommentar(MetaDsbKommentar anObject) {
        }

        public void visitTBFeld(MetaTBFeld anObject) {
        }

        public void visitRawSet(MetaRawSet anObject) {
        }

        public void visitRawDataSet(MetaRawDataSet anObject) {
        }

        public void visitPLVariable(MetaPLVariable anObject) {
        }

        public void visitDsbZeilenKommentar(MetaDsbZeilenKommentar anObject) {
        }

        public void visitRawFieldGroup(MetaRawFieldGroup anObject) {
        }

        public void visitPLFunktion(MetaPLFunktion anObject) {
            MetaCustomFunktion metaCustomFunktion = (MetaCustomFunktion)anObject;
            ProgramComplexityNodeBuilder.this.startLevel(anObject.getName(), ICON_FUNCTION, anObject, metaCustomFunktion.getAnweisungen(), false);
            if (!this.inProgramm()) {
                metaCustomFunktion.getMetaSpezifikation().accept(this);
            }
            ProgramComplexityNodeBuilder.this.endLevel(metaCustomFunktion);
        }

        public void visitPLMaterial(MetaPLMaterial anObject) {
        }

        public void visitMerkmal(MetaMerkmal anObject) {
            MetaCustomMerkmal merkmal = (MetaCustomMerkmal)anObject;
            ProgramComplexityNodeBuilder.this.startLevel(anObject.getName(), ICON_MERKMAL, anObject, merkmal.getPLSpezifikation(), false);
            if (!this.inProgramm()) {
                merkmal.getMetaSpezifikation().accept(this);
            }
            ProgramComplexityNodeBuilder.this.endLevel(anObject);
        }

        public void visitSatzart(MetaSatzart anObject) {
        }

        public void visitPLParameter(MetaPLParameter anObject) {
        }

        public void visitMapping(MetaMapping anObject) {
        }

        public void visitMappingElement(MetaMappingElement anObject) {
        }

        public void visitDsbComps(MetaDsbComps anObject) {
        }

        public void visitRefAuspraegung(MetaRefAuspraegung anObject) {
        }

        public void visitTBMaterialReferenz(MetaTBMaterialReferenz anObject) {
        }

        public void visitThemenbereich(MetaThemenbereich anObject) {
            ProgramComplexityNode tbNode = new ProgramComplexityNode((ProgramComplexityNode)ProgramComplexityNodeBuilder.this.currentNode.peek(), (MetaElement)anObject, anObject.getName(), ICON_THEMENBEREICH, null, false);
            if (!this.inProgramm() && anObject == this.rootThemenbereich) {
                tbNode.setRootTB(true);
            }
            ProgramComplexityNodeBuilder.this.currentNode.push(tbNode);
            ProgramComplexityNode pruefOrdnerNode = new ProgramComplexityNode((ProgramComplexityNode)ProgramComplexityNodeBuilder.this.currentNode.peek(), null, "Pr\u00fcfungen", null, null, false);
            ProgramComplexityNodeBuilder.this.currentNode.push(pruefOrdnerNode);
            this.visitElements(anObject.getPruefungen());
            ProgramComplexityNodeBuilder.this.currentNode.pop();
            ProgramComplexityNode funkOrdnerNode = new ProgramComplexityNode((ProgramComplexityNode)ProgramComplexityNodeBuilder.this.currentNode.peek(), null, "Funktionen", null, null, false);
            ProgramComplexityNodeBuilder.this.currentNode.push(funkOrdnerNode);
            this.visitElements(anObject.getFunktionen());
            ProgramComplexityNodeBuilder.this.currentNode.pop();
            ProgramComplexityNode ablOrdnerNode = new ProgramComplexityNode((ProgramComplexityNode)ProgramComplexityNodeBuilder.this.currentNode.peek(), null, "Abl\u00e4ufe", null, null, false);
            ProgramComplexityNodeBuilder.this.currentNode.push(ablOrdnerNode);
            this.visitElements(anObject.getAblaeufe());
            ProgramComplexityNodeBuilder.this.currentNode.pop();
            ProgramComplexityNodeBuilder.this.currentNode.pop();
        }

        public void visitNumber(MetaNumber aNumber) {
            ProgramComplexityNodeBuilder.this.startEndLevel(String.valueOf(ProgramComplexityNodeBuilder.this.displayNames.getDisplayName(aNumber)) + " " + aNumber.value(), null, aNumber);
        }

        public void visitBoolean(MetaBoolean aBoolean) {
            ProgramComplexityNodeBuilder.this.startEndLevel(aBoolean);
        }

        public void visitString(MetaString aString) {
            ProgramComplexityNodeBuilder.this.startEndLevel(aString);
        }

        public void visitDate(MetaDate aDate) {
            ProgramComplexityNodeBuilder.this.startEndLevel(aDate);
        }

        public void visitNoValue(MetaNoValue value) {
            ProgramComplexityNodeBuilder.this.startEndLevel(value);
        }

        public void visitIdentifier(MetaIdentifier anIdentifier) {
            ProgramComplexityNodeBuilder.this.startEndLevel(String.valueOf(ProgramComplexityNodeBuilder.this.displayNames.getDisplayName(anIdentifier)) + " " + anIdentifier.value(), null, anIdentifier);
        }

        public void visitSelfAccess(MetaSelfAccess aSelfAccess) {
            ProgramComplexityNodeBuilder.this.startEndLevel(aSelfAccess);
        }

        public void visitForEachIndexOperand(MetaForEachIndexOperator aForEachIndexOperand) {
            ProgramComplexityNodeBuilder.this.startEndLevel(aForEachIndexOperand);
        }

        public void visitBreakStatement(MetaBreakStatement aStatement) {
            ProgramComplexityNodeBuilder.this.startEndLevel(aStatement);
        }

        public void visitErrorStatement(MetaErrorStatement aStatement) {
            ProgramComplexityNodeBuilder.this.startEndLevel(aStatement);
        }

        public void visitProgramParameter(MetaProgramParameter aParameter) {
            ProgramComplexityNodeBuilder.this.startEndLevel(aParameter);
        }

        public void visitMapStatement(MetaMapStatement aStatement) {
            ProgramComplexityNodeBuilder.this.startEndLevel(aStatement);
        }

        public void visitWithOperator(MetaWithOperator anOperator) {
            ProgramComplexityNodeBuilder.this.startLevel(anOperator);
            this.visitMetaFaktor(anOperator.operand());
            ProgramComplexityNodeBuilder.this.endLevel(anOperator);
        }

        public void visitSizeTestingOperator(MetaSizeTestingOperator anOperator) {
            ProgramComplexityNodeBuilder.this.startEndLevel(anOperator);
        }

        public void visitHierarchicalOperator(MetaHierarchicalOperator anOperator) {
            ProgramComplexityNodeBuilder.this.startEndLevel(anOperator);
        }

        public void visitContextOperator(MetaContextOperator anOperator) {
            ProgramComplexityNodeBuilder.this.startEndLevel(anOperator);
        }

        public void visitHierarchicalForEachLoop(MetaHierarchicalForEachLoop aStatement) {
            ProgramComplexityNodeBuilder.this.startEndLevel(aStatement);
        }

        private void visitMetaFaktor(MetaFactor metaFactor) {
            metaFactor.accept(this);
        }

        private void visitMetaRightValue(MetaRightValue metaRightValue) {
            MetaElement metaElement = (MetaElement)((Object)metaRightValue.value());
            if (metaElement instanceof MetaFactor) {
                this.visitMetaFaktor((MetaFactor)metaElement);
            } else {
                metaElement.accept(this);
            }
        }

        private void visitElements(Iterator it) {
            while (it != null && it.hasNext()) {
                ((MetaElement)it.next()).accept(ProgramComplexityNodeBuilder.this.resolver);
            }
        }

        private boolean inProgramm() {
            return ProgramComplexityNodeBuilder.this.inProgramm.size() > 0;
        }

        private void setFrequencyEnabled(boolean enabled) {
            this.frequencyEnabled = enabled;
        }

        private boolean isFrequencyEnabled() {
            return this.frequencyEnabled;
        }
    }
}

