/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.analysis.complexity.ui;

import de.statspez.pleditor.generator.codegen.analysis.complexity.ui.ComplexityNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.TreeNode;

public class ComplexityUITreeNode
implements TreeNode {
    private List childNodes = null;
    private List childUIAllNodes = null;
    private ComplexityNode complexityNode = null;
    private ComplexityUITreeNode parent = null;
    private Comparator comparator = null;

    ComplexityUITreeNode(ComplexityUITreeNode parent, ComplexityNode complexityNode) {
        if (complexityNode == null) {
            throw new NullPointerException();
        }
        this.parent = parent;
        this.complexityNode = complexityNode;
        this.childNodes = this.complexityNode.getChildren();
        this.initChildren();
    }

    public Enumeration children() {
        return new Enumeration(){
            private int count = 0;

            public boolean hasMoreElements() {
                return this.count < ComplexityUITreeNode.this.getChildCount();
            }

            public Object nextElement() {
                return ComplexityUITreeNode.this.getChildAt(this.count++);
            }
        };
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public TreeNode getChildAt(int childIndex) {
        return (TreeNode)this.childUIAllNodes.get(childIndex);
    }

    public int getChildCount() {
        return this.childUIAllNodes.size();
    }

    public int getIndex(TreeNode node) {
        return this.childUIAllNodes.indexOf(node);
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public boolean isLeaf() {
        return this.childNodes.size() == 0;
    }

    public String toString() {
        return this.complexityNode.toString();
    }

    ComplexityNode getComplexityNode() {
        return this.complexityNode;
    }

    void sortChildren(Comparator comparator) {
        if (comparator == null) {
            throw new NullPointerException();
        }
        this.comparator = comparator;
        Collections.sort(this.childUIAllNodes, comparator);
        Enumeration enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            ComplexityUITreeNode child = (ComplexityUITreeNode)enumeration.nextElement();
            child.sortChildren(comparator);
        }
    }

    private void initChildren() {
        this.childUIAllNodes = new ArrayList(this.childNodes.size());
        Iterator iterator = this.childNodes.iterator();
        while (iterator.hasNext()) {
            ComplexityNode complexityNode = (ComplexityNode)iterator.next();
            ComplexityUITreeNode complexityUINode = new ComplexityUITreeNode(this, complexityNode);
            this.childUIAllNodes.add(complexityUINode);
        }
    }
}

