/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.analysis.complexity.frequency;

import de.statspez.pleditor.generator.codegen.analysis.complexity.datastructure.AbstractDatastructureComplexityResolver;
import de.statspez.pleditor.generator.codegen.support.Traverser;
import de.statspez.pleditor.generator.meta.MetaConditionalStatement;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.MetaCustomTBFeld;
import de.statspez.pleditor.generator.meta.MetaForEachLoop;
import de.statspez.pleditor.generator.meta.MetaForNextLoop;
import de.statspez.pleditor.generator.meta.MetaMaterialAccess;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.MetaWhileLoop;
import de.statspez.pleditor.generator.meta.generated.MetaTBFeld;

public class FrequencyDefaultLoader
extends Traverser {
    public void loadDefaultFrequencyToPlausi(MetaCustomPlausibilisierung plausi) {
        plausi.accept(this);
    }

    public void visitForNextLoop(MetaForNextLoop aStatement) {
        aStatement.loopBody().setFunctionalFrequency(new Double(100.0));
        super.visitForNextLoop(aStatement);
    }

    public void visitForEachLoop(MetaForEachLoop aStatement) {
        aStatement.loopBody().setFunctionalFrequency(new Double(100.0));
        super.visitForEachLoop(aStatement);
    }

    public void visitWhileLoop(MetaWhileLoop aStatement) {
        aStatement.loopBody().setFunctionalFrequency(new Double(100.0));
        super.visitWhileLoop(aStatement);
    }

    public void visitMaterialAccess(MetaMaterialAccess anAccess) {
        anAccess.setFunctionalFrequency(new Double(100.0));
        super.visitMaterialAccess(anAccess);
    }

    public void visitTBFeld(MetaTBFeld anObject) {
        MetaCustomTBFeld field = (MetaCustomTBFeld)anObject;
        if (field.getListe()) {
            int[] dimensions = field.dimensions();
            if (AbstractDatastructureComplexityResolver.isNDimensional(dimensions)) {
                field.setDatastructureFrequency(new Double(100.0));
            } else {
                double frequency = 0.0;
                int i = 0;
                while (i < dimensions.length) {
                    frequency = i == 0 ? (double)dimensions[i] : (frequency *= (double)dimensions[i]);
                    ++i;
                }
                field.setDatastructureFrequency(new Double(frequency));
            }
        } else {
            field.setDatastructureFrequency(new Double(1.0));
        }
        super.visitTBFeld(anObject);
    }

    public void visitProgram(MetaProgram aProgram) {
        super.visitProgram(aProgram);
    }

    public void visitConditionalStatement(MetaConditionalStatement aStatement) {
        Double trueFrequency = new Double(0.5);
        Double falseFrequency = new Double(0.5);
        aStatement.ifTrue().setFunctionalFrequency(trueFrequency);
        aStatement.ifFalse().setFunctionalFrequency(falseFrequency);
        super.visitConditionalStatement(aStatement);
    }
}

