/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.analysis.complexity.datastructure;

import de.statspez.pleditor.generator.meta.AbstractElementVisitor;
import de.statspez.pleditor.generator.meta.MetaCustomMerkmal;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.MetaCustomTBFeld;
import de.statspez.pleditor.generator.meta.MetaCustomThemenbereich;
import de.statspez.pleditor.generator.meta.generated.MetaMerkmal;
import de.statspez.pleditor.generator.meta.generated.MetaPlausibilisierung;
import de.statspez.pleditor.generator.meta.generated.MetaTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractDatastructureComplexityResolver {
    public static final double DEFAULT_FREQUENCY_FOR_NDIMENSION = 100.0;
    private List resolvedElements;

    protected abstract int getSqlType(MetaMerkmal var1);

    protected abstract int getVarcharSize(MetaMerkmal var1);

    protected abstract AbstractDatastructureComplexityResolver createSubResolver(List var1);

    public AbstractDatastructureComplexityResolver() {
        this(new ArrayList());
    }

    public AbstractDatastructureComplexityResolver(List calculatedElements) {
        this.resolvedElements = calculatedElements;
    }

    public void resolveComplexity(MetaCustomPlausibilisierung plausi) {
        Resolver resolver = new Resolver();
        plausi.accept(resolver);
    }

    public void resolveComplexity(MetaThemenbereich themenbereich, boolean rootThemenbereich) {
        Resolver resolver = new Resolver();
        themenbereich.accept(resolver);
    }

    private boolean isNotResolved(Object obj) {
        return !this.resolvedElements.contains(obj);
    }

    public static boolean isNDimensional(int[] dimensions) {
        boolean nDimensional = false;
        int i = 0;
        while (i < dimensions.length) {
            if (dimensions[i] < 0) {
                nDimensional = true;
                break;
            }
            ++i;
        }
        return nDimensional;
    }

    private class Resolver
    extends AbstractElementVisitor {
        private Resolver() {
        }

        public void visitPlausibilisierung(MetaPlausibilisierung anObject) {
            this.visitElements(anObject.getThemenbereiche());
        }

        public void visitMerkmal(MetaMerkmal anObject) {
            if (AbstractDatastructureComplexityResolver.this.isNotResolved(anObject)) {
                MetaCustomMerkmal merkmal = (MetaCustomMerkmal)anObject;
                merkmal.setDatastructureComplexity(null);
                AbstractDatastructureComplexityResolver.this.resolvedElements.add(merkmal);
                int byteAnzahl = this.getSpeicherbedarf(anObject);
                merkmal.setDatastructureComplexity(new Double(byteAnzahl));
            }
        }

        public void visitThemenbereich(MetaThemenbereich anObject) {
            if (AbstractDatastructureComplexityResolver.this.isNotResolved(anObject)) {
                double size = 0.0;
                Iterator it = anObject.getFelder();
                while (it != null && it.hasNext()) {
                    MetaCustomTBFeld field = (MetaCustomTBFeld)it.next();
                    field.accept(this);
                    size += field.getDatastructureComplexity().doubleValue();
                }
                ((MetaCustomThemenbereich)anObject).setDatastructureComplexity(new Double(size));
            }
        }

        public void visitTBFeld(MetaTBFeld anObject) {
            MetaCustomTBFeld field = (MetaCustomTBFeld)anObject;
            if (AbstractDatastructureComplexityResolver.this.isNotResolved(field.getKlasse())) {
                if (field.getKlasse() instanceof MetaThemenbereich) {
                    AbstractDatastructureComplexityResolver subResolver = AbstractDatastructureComplexityResolver.this.createSubResolver(AbstractDatastructureComplexityResolver.this.resolvedElements);
                    subResolver.resolveComplexity((MetaThemenbereich)field.getKlasse(), false);
                } else {
                    field.getKlasse().accept(this);
                }
            }
            if (field.getListe()) {
                int[] dimensions = field.dimensions();
                if (AbstractDatastructureComplexityResolver.isNDimensional(dimensions)) {
                    if (field.getDatastructureFrequency() == null) {
                        field.setDatastructureFrequency(new Double(100.0));
                    }
                } else {
                    double frequency = 0.0;
                    int i = 0;
                    while (i < dimensions.length) {
                        frequency = i == 0 ? (double)dimensions[i] : (frequency *= (double)dimensions[i]);
                        ++i;
                    }
                    field.setDatastructureFrequency(new Double(frequency));
                }
            } else {
                field.setDatastructureFrequency(new Double(1.0));
            }
            double complexity = 0.0;
            if (field.getKlasse() instanceof MetaCustomThemenbereich) {
                MetaCustomThemenbereich themenbereich = (MetaCustomThemenbereich)field.getKlasse();
                complexity = themenbereich.getDatastructureComplexity();
            } else if (field.getKlasse() instanceof MetaCustomMerkmal) {
                MetaCustomMerkmal merkmal = (MetaCustomMerkmal)field.getKlasse();
                complexity = merkmal.getDatastructureComplexity();
            }
            field.setDatastructureComplexity(new Double(complexity *= field.getDatastructureFrequency().doubleValue()));
        }

        private int getSpeicherbedarf(MetaMerkmal merkmal) {
            int sqlDataType = AbstractDatastructureComplexityResolver.this.getSqlType(merkmal);
            return this.getSqlStorage(sqlDataType, merkmal);
        }

        private int getSqlStorage(int sqlDataType, MetaMerkmal merkmal) {
            int result;
            switch (sqlDataType) {
                case -5: {
                    result = 8;
                    break;
                }
                case 8: {
                    result = 8;
                    break;
                }
                case -7: {
                    result = 8;
                    break;
                }
                case 12: {
                    result = 1 + AbstractDatastructureComplexityResolver.this.getVarcharSize(merkmal);
                    break;
                }
                case -1: {
                    result = 12;
                    break;
                }
                default: {
                    new IllegalArgumentException("Unbekannter Felddaten-Typ!");
                    result = -1;
                }
            }
            return result;
        }
    }
}

