/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xsql;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.Enumeration;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLDocumentFragment;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLProcessor;
import oracle.xml.parser.v2.XSLStylesheet;
import oracle.xml.xsql.XSQLPageRequest;
import oracle.xml.xsql.XSQLPeekaheadWriter;
import oracle.xml.xsql.XSQLStylesheet;
import oracle.xml.xsql.XSQLStylesheetManager;
import org.w3c.dom.Document;
import org.xml.sax.SAXParseException;

public final class XSQLStylesheetProcessor {
    public static final char QUOTE = '\"';
    public static final char APOS = '\'';

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Document processToDocument(Document document, String string, XSQLPageRequest xSQLPageRequest) throws Exception, SAXParseException, XSLException, FileNotFoundException {
        XMLDocument xMLDocument = null;
        XSQLStylesheet xSQLStylesheet = null;
        XSQLStylesheetManager xSQLStylesheetManager = XSQLStylesheetManager.getManager();
        try {
            XSLProcessor xSLProcessor = new XSLProcessor();
            xSQLStylesheet = xSQLStylesheetManager.getStylesheet(string, xSQLPageRequest, true);
            XSQLStylesheetProcessor.setStylesheetParametersFromPageRequest(xSQLStylesheet.getStylesheet(), xSQLPageRequest);
            XMLDocumentFragment xMLDocumentFragment = xSLProcessor.processXSL(xSQLStylesheet.getStylesheet(), (XMLDocument)document);
            xMLDocument = new XMLDocument();
            xMLDocument.appendChild(xMLDocumentFragment);
            if (xSQLStylesheet == null) return xMLDocument;
        }
        catch (SAXParseException sAXParseException) {
            try {
                throw sAXParseException;
                catch (FileNotFoundException fileNotFoundException) {
                    throw fileNotFoundException;
                }
                catch (XSLException xSLException) {
                    xSQLPageRequest.signalError(25011, new String[]{string}, new Object[]{xSLException.getMessage()});
                    throw xSLException;
                }
                catch (Exception exception) {
                    if (xSQLPageRequest.printedErrorHeader()) throw exception;
                    xSQLPageRequest.signalError(25018, new String[]{xSQLPageRequest.getStylesheetURI()}, new Object[]{exception});
                    throw exception;
                }
            }
            catch (Throwable throwable) {
                if (xSQLStylesheet == null) throw throwable;
                xSQLStylesheetManager.releaseStylesheet(xSQLStylesheet, xSQLPageRequest, true);
                throw throwable;
            }
        }
        xSQLStylesheetManager.releaseStylesheet(xSQLStylesheet, xSQLPageRequest, true);
        return xMLDocument;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void processToWriter(Document document, String string, XSQLPageRequest xSQLPageRequest) throws Exception, SAXParseException, XSLException, FileNotFoundException {
        XSQLStylesheet xSQLStylesheet = null;
        XSQLStylesheetManager xSQLStylesheetManager = XSQLStylesheetManager.getManager();
        try {
            Object var5_5 = null;
            String string2 = null;
            XSQLPeekaheadWriter xSQLPeekaheadWriter = null;
            XSLProcessor xSLProcessor = new XSLProcessor();
            xSQLStylesheet = xSQLStylesheetManager.getStylesheet(string, xSQLPageRequest, false);
            XSLStylesheet xSLStylesheet = xSQLStylesheet.getStylesheet();
            string2 = xSLStylesheet.getOutputEncoding();
            XSQLStylesheetProcessor.setStylesheetParametersFromPageRequest(xSLStylesheet, xSQLPageRequest);
            xSQLPeekaheadWriter = new XSQLPeekaheadWriter(xSLStylesheet, xSQLPageRequest, string2);
            xSLProcessor.processXSL(xSLStylesheet, (XMLDocument)document, (PrintWriter)xSQLPeekaheadWriter);
            if (xSQLStylesheet == null) return;
        }
        catch (SAXParseException sAXParseException) {
            try {
                throw sAXParseException;
                catch (FileNotFoundException fileNotFoundException) {
                    throw fileNotFoundException;
                }
                catch (XSLException xSLException) {
                    xSQLPageRequest.signalError(25011, new String[]{xSQLPageRequest.getStylesheetURI()}, new Object[]{xSLException.getMessage()});
                    throw xSLException;
                }
                catch (Exception exception) {
                    if (xSQLPageRequest.printedErrorHeader()) throw exception;
                    xSQLPageRequest.signalError(25018, new String[]{xSQLPageRequest.getStylesheetURI()}, new Object[]{exception});
                    throw exception;
                }
            }
            catch (Throwable throwable) {
                if (xSQLStylesheet == null) throw throwable;
                xSQLStylesheetManager.releaseStylesheet(xSQLStylesheet, xSQLPageRequest, true);
                throw throwable;
            }
        }
        xSQLStylesheetManager.releaseStylesheet(xSQLStylesheet, xSQLPageRequest, true);
    }

    private static void setStylesheetParametersFromPageRequest(XSLStylesheet xSLStylesheet, XSQLPageRequest xSQLPageRequest) {
        try {
            xSLStylesheet.resetParams();
            Enumeration enumeration = xSQLPageRequest.getStylesheetParameters();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    try {
                        String string = (String)enumeration.nextElement();
                        String string2 = xSQLPageRequest.getStylesheetParameter(string);
                        if (string2.indexOf(39) >= 0) {
                            xSLStylesheet.setParam(string, '\"' + string2 + '\"');
                            continue;
                        }
                        xSLStylesheet.setParam(string, '\'' + string2 + '\'');
                    }
                    catch (XSLException xSLException) {}
                }
            }
        }
        catch (XSLException xSLException) {
            // empty catch block
        }
    }
}

