/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xslt;

import java.io.PrintWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import oracle.xml.parser.v2.NSName;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.util.FastVector;
import oracle.xml.util.NSNameImpl;
import oracle.xml.xpath.XPathSeqType;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xpath.XSLExprBase;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xslt.XSLConstants;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLNode;
import oracle.xml.xslt.XSLStylesheet;
import oracle.xml.xslt.XSLTContext;
import oracle.xml.xslt.XSLTDebuggerTraceEventVars;
import oracle.xml.xslt.XSLVariable;

class XSLTemplate
extends XSLNode
implements XSLConstants {
    private OXMLSequenceType asseq;
    private XSLExprBase pattern;
    private float priority;
    private NSName mode;
    int anchorNodeType = -1;
    String anchorNodeLocalName = null;
    private String[] anchorNodeName = new String[2];
    private String anchorNodeNamespace = null;
    String patternString;
    int importPriority;
    int index;
    int importLevel;
    NSName templateNSName;
    boolean isBuiltInElementTemplate = false;

    XSLTemplate(XSLStylesheet xSLStylesheet) throws XSLException {
        super(xSLStylesheet);
        this.localName = "template";
        this.elementType = 6;
    }

    XSLExprBase getPattern() {
        return this.pattern;
    }

    @Override
    XSLExprBase getContextExpr() {
        return this.pattern;
    }

    XSLExprBase matchTemplate(XMLNode xMLNode, NSName nSName, float f, XSLTContext xSLTContext) throws XSLException, XQException {
        if (nSName.equals(this.mode) && this.pattern != null) {
            URL uRL = xSLTContext.getBaseURL();
            xSLTContext.setBaseURL(this.baseURL);
            XSLExprBase xSLExprBase = this.pattern.matchPattern(xMLNode, f, xSLTContext);
            xSLTContext.setBaseURL(uRL);
            if (xSLExprBase != null) {
                return xSLExprBase;
            }
        }
        return null;
    }

    int matchTemplate(XSLExprBase xSLExprBase, NSName nSName, float f) throws XSLException, XQException {
        if (nSName.equals(this.mode) && this.pattern != null) {
            return this.pattern.matchPattern(xSLExprBase, f);
        }
        return -1;
    }

    void fireOSBDebuggerTraceEventBefore(XSLTContext xSLTContext) throws XSLException {
        if (xSLTContext.getOSBDebugMode() && !this.isBuiltInElementTemplate) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>(2);
            xSLTContext.getOsbDebugAttrStk().push(hashMap);
            hashMap.put("match", this.patternString);
            hashMap.put("name", this.templateNSName);
            this.fireOSBDebuggerTraceEventBeforeExe(xSLTContext, this, "xsl:template");
        }
    }

    @Override
    public void processAction(XSLTContext xSLTContext) throws XSLException, XQException {
        XMLError xMLError = xSLTContext.getError();
        xMLError.setLocator(this);
        String string = xSLTContext.getDefaultCollation();
        URL uRL = xSLTContext.getBaseURL();
        xSLTContext.setBaseURL(this.baseURL);
        this.setDefaultCollation(xSLTContext);
        if (xSLTContext.isInDebugMode()) {
            if (this.patternString == null) {
                this.patternString = "";
            }
            this.addJDWPDataBefore(xSLTContext, this, "xsl:template", this.patternString, (byte)40);
        }
        this.processChildren(xSLTContext);
        xSLTContext.setBaseURL(uRL);
        xSLTContext.setDefaultCollation(string);
        if (xSLTContext.getOSBDebugMode() && !this.isBuiltInElementTemplate) {
            this.fireOSBDebuggerTraceEventAfterExe(xSLTContext, this, "xsl:template");
            xSLTContext.getOsbDebugAttrStk().pop();
        }
        if (xSLTContext.isInDebugMode()) {
            this.addJDWPDataAfter(this, (byte)41, null);
        }
    }

    @Override
    public void appendChild(XSLNode xSLNode) throws XSLException {
        super.appendChild(xSLNode);
        if (xSLNode instanceof XSLVariable && xSLNode.namespace == "http://www.w3.org/1999/XSL/Transform" && xSLNode.localName == "param") {
            if (this.paramList == null) {
                this.paramList = new FastVector(4);
            }
            this.paramList.addElement(xSLNode);
            ++this.nParams;
            this.children.setSize(this.children.size() - 1);
        }
    }

    @Override
    public void setAttribute(String string, String string2, String string3, String string4) throws XSLException, XQException {
        if (string == "") {
            if (string3 == "priority") {
                this.priority = new Float(string4).floatValue();
            } else if (string3 == "name") {
                this.templateNSName = this.resolveQname(string4);
                this.xss.addNamedTemplate(this.templateNSName, this);
            } else if (string3 == "match") {
                this.pattern = XSLExprBase.createPattern(string4, this, true, this.xss);
                this.patternString = string4;
            } else if (string3 == "mode") {
                this.mode = this.resolveQname(string4);
            } else if (string3 == "as") {
                this.asseq = XPathSeqType.createSequenceType(string4, this, this.xss);
            }
        }
        super.setAttribute(string, string2, string3, string4);
    }

    @Override
    public void startContent() throws XSLException {
        if (this.pattern == null && this.templateNSName == null) {
            this.xss.err.error2(1009, 1, "match", "template");
        }
        if (this.getAttribute("", "priority") != null) {
            if (this.pattern != null) {
                this.pattern.setPriority(this.priority);
            }
        } else if (this.pattern != null) {
            this.priority = this.pattern.getPriority();
        }
        if (this.pattern != null) {
            this.anchorNodeType = this.pattern.getAnchorType();
            this.pattern.getAnchorName(this.anchorNodeName);
            this.anchorNodeNamespace = this.anchorNodeName[0];
            this.anchorNodeLocalName = this.anchorNodeName[1];
        }
        if (this.mode == null) {
            this.mode = new NSNameImpl();
        }
    }

    @Override
    void endContent() throws XSLException, XQException {
        super.endContent();
    }

    @Override
    public void finalizeXSLNode() throws XSLException, XQException {
        for (int i = 0; i < this.nParams; ++i) {
            ((XSLNode)this.paramList.elementAt(i)).finalizeXSLNode();
        }
        super.finalizeXSLNode();
    }

    NSName getMode() {
        return this.mode;
    }

    float getPriority() {
        return this.priority;
    }

    int getImportPriority() {
        return this.importPriority;
    }

    void setParams(Hashtable hashtable, XSLTContext xSLTContext) throws XSLException, XQException {
        Object object;
        this.fireOSBDebuggerTraceEventBefore(xSLTContext);
        XMLError xMLError = xSLTContext.getError();
        xMLError.setLocator(this);
        URL uRL = xSLTContext.getBaseURL();
        xSLTContext.setBaseURL(this.baseURL);
        if (xSLTContext.isInDebugMode() && (((LinkedList)(object = this.xss.getFrames())).size() == 0 || ((LinkedList)object).size() > 0 && ((LinkedList)object).getLast() != null)) {
            ((LinkedList)object).add(null);
            this.xss.frameValues.add(new LinkedList());
            this.xss.frameParams.add(new Integer(1));
        }
        object = null;
        if (hashtable != null) {
            for (int i = 0; i < this.nParams; ++i) {
                XSLVariable xSLVariable = (XSLVariable)this.paramList.elementAt(i);
                XPathSequence xPathSequence = (XPathSequence)hashtable.get(xSLVariable.getName());
                if (xPathSequence == null) {
                    xPathSequence = xSLVariable.getValue(xSLTContext);
                }
                xSLTContext.pushVariable(xPathSequence);
                if (xSLTContext.isInDebugMode()) {
                    this.addParamValuesNums(this.xss, this.xss.getFrames().size() - 1, xPathSequence);
                }
                if (!xSLTContext.getOSBDebugMode()) continue;
                HashMap<String, Object> hashMap = new HashMap<String, Object>(2);
                xSLTContext.getOsbDebugAttrStk().push(hashMap);
                hashMap.put("name", xSLVariable.getName());
                hashMap.put("value", xPathSequence);
                object = new XSLTDebuggerTraceEventVars(xSLVariable, false);
                xSLTContext.pushOSBDebugVar((XSLTDebuggerTraceEventVars)object);
                xSLVariable.setParamPos(i + 1);
                ((XSLTDebuggerTraceEventVars)object).setParamPos(i + 1);
                this.fireOSBDebuggerTraceEventBeforeExe(xSLTContext, xSLVariable, "xsl:" + xSLVariable.localName);
                ((XSLTDebuggerTraceEventVars)object).setValue(xPathSequence);
                this.fireOSBDebuggerTraceEventAfterExe(xSLTContext, xSLVariable, "xsl:" + xSLVariable.localName);
                xSLTContext.getOsbDebugAttrStk().pop();
            }
        } else {
            HashMap<String, Object> hashMap = null;
            for (int i = 0; i < this.nParams; ++i) {
                XSLVariable xSLVariable = (XSLVariable)this.paramList.elementAt(i);
                if (xSLTContext.getOSBDebugMode()) {
                    hashMap = new HashMap<String, Object>(2);
                    xSLTContext.getOsbDebugAttrStk().push(hashMap);
                    hashMap.put("name", xSLVariable.getName());
                    object = new XSLTDebuggerTraceEventVars(xSLVariable, false);
                    xSLTContext.pushOSBDebugVar((XSLTDebuggerTraceEventVars)object);
                    xSLVariable.setParamPos(i + 1);
                    ((XSLTDebuggerTraceEventVars)object).setParamPos(i + 1);
                    this.fireOSBDebuggerTraceEventBeforeExe(xSLTContext, xSLVariable, "xsl:" + xSLVariable.localName);
                }
                XPathSequence xPathSequence = xSLVariable.getValue(xSLTContext);
                xSLTContext.pushVariable(xPathSequence);
                if (xSLTContext.isInDebugMode()) {
                    this.addParamValuesNums(this.xss, this.xss.getFrames().size() - 1, xPathSequence);
                }
                if (!xSLTContext.getOSBDebugMode()) continue;
                hashMap.put("value", xPathSequence);
                ((XSLTDebuggerTraceEventVars)object).setValue(xPathSequence);
                this.fireOSBDebuggerTraceEventAfterExe(xSLTContext, xSLVariable, "xsl:" + xSLVariable.localName);
                xSLTContext.getOsbDebugAttrStk().pop();
            }
        }
        xSLTContext.setBaseURL(uRL);
    }

    private void addParamValuesNums(XSLStylesheet xSLStylesheet, int n, XPathSequence xPathSequence) {
        LinkedList linkedList = (LinkedList)xSLStylesheet.frameValues.get(n);
        linkedList.add(xPathSequence);
        Integer n2 = (Integer)xSLStylesheet.frameParams.get(n);
        xSLStylesheet.frameParams.set(n, new Integer(n2 + 1));
    }

    @Override
    void printChildren(PrintWriter printWriter, int n) {
        for (int i = 0; i < this.nParams; ++i) {
            ((XSLNode)this.paramList.elementAt(i)).printXSLNode(printWriter, n);
        }
        super.printChildren(printWriter, n);
    }
}

