/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import oracle.i18n.util.LocaleMapper;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLParseException;
import oracle.xml.util.ArrayPool;
import oracle.xml.util.XMLUtil;

public class XMLOutputStream {
    private final int outputType;
    private static final int OUTPUT_TYPE_BYTE_STREAM = 1;
    private static final int OUTPUT_TYPE_CHAR_STREAM = 2;
    private static final String nlStr;
    public static final int DEFAULT = 0;
    public static final int PRETTY = 1;
    public static final int COMPACT = 2;
    public static final int REUSE = 0;
    public static final int NO_REUSE = 1;
    private static final int OUTPUT_STATE_UNSET = -1;
    static final int UTF8 = 1;
    static final int ASCII = 2;
    static final int UCS2_LE = 3;
    static final int UCS2_BE = 4;
    static final int UCS4_LE = 5;
    static final int UCS4_BE = 6;
    static final int OUTPUTSW = 7;
    private char highSurrogate = '\u0000';
    private static final char UNICODE_REPLACEMENT_CHARACTER = '\ufffd';
    private OutputStream outStream;
    private Writer outWriter;
    char[] charBuffer;
    int charIndex;
    int charDebugIndex = -1;
    byte[] byteBuffer;
    int byteIndex;
    int byteDebugIndex = -1;
    private boolean localErr;
    XMLError err;
    private String encStr;
    private boolean lendian;
    private int wrtstate;
    private boolean encUsesBOM = false;
    private int indent = 0;
    private int outstyle = 1;
    boolean mixed = false;
    private char[] nlChars;
    private static final byte BOM_HI = -2;
    private static final byte BOM_LO = -1;

    public XMLOutputStream(OutputStream outputStream) {
        this.outputType = 1;
        this.init(outputStream, null);
    }

    public XMLOutputStream(Writer writer) {
        this.outputType = 2;
        this.init(null, writer);
    }

    public void setEOLChars(String string) {
        this.nlChars = string.toCharArray();
    }

    private final void init(OutputStream outputStream, Writer writer) {
        this.outStream = outputStream;
        this.outWriter = writer;
        this.setEOLChars(nlStr);
        if (outputStream != null && writer == null) {
            this.wrtstate = 1;
            this.byteBuffer = ArrayPool.allocByteArrDefault();
        } else if (outputStream == null && writer != null) {
            this.wrtstate = 7;
            this.charBuffer = ArrayPool.allocCharArrDefault();
        }
    }

    public void setEncoding(String string, boolean bl, boolean bl2) throws IOException {
        boolean bl3;
        if (this.outWriter != null) {
            return;
        }
        if (this.encUsesBOM && (this.wrtstate == 3 || this.wrtstate == 4)) {
            if (this.byteIndex >= 2) {
                byte by = this.byteBuffer[this.byteIndex - 2];
                byte by2 = this.byteBuffer[this.byteIndex - 1];
                bl3 = this.lendian && by == -2 && by2 == -1 || !this.lendian && by == -1 && by2 == -2;
            } else {
                bl3 = false;
            }
            if (bl3) {
                this.byteIndex -= 2;
            }
        }
        this.encStr = string;
        this.lendian = bl;
        this.encUsesBOM = false;
        if (string.equalsIgnoreCase("ISO-10646-UCS-2") || string.equalsIgnoreCase("UCS-2") || string.equalsIgnoreCase("UTF-16")) {
            this.wrtstate = bl ? 3 : 4;
            if (bl2) {
                this.encUsesBOM = true;
                if (bl) {
                    this.byteBuffer[this.byteIndex] = -2;
                    this.byteBuffer[this.byteIndex + 1] = -1;
                } else {
                    this.byteBuffer[this.byteIndex] = -1;
                    this.byteBuffer[this.byteIndex + 1] = -2;
                }
                this.byteIndex += 2;
            }
            return;
        }
        if (string.equalsIgnoreCase("ISO-10646-UCS-4") || string.equalsIgnoreCase("UCS-4")) {
            this.wrtstate = bl ? 5 : 6;
            return;
        }
        if (string.toUpperCase().equals("ASCII")) {
            this.wrtstate = 2;
            return;
        }
        if (string.toUpperCase().equals("UTF-8")) {
            this.wrtstate = 1;
            return;
        }
        bl3 = false;
        String string2 = LocaleMapper.getJavaCharacterSet(2, string.toUpperCase());
        if (string2 != null) {
            try {
                this.outWriter = new OutputStreamWriter(this.outStream, string2);
            }
            catch (Exception exception) {
                bl3 = true;
            }
        }
        if (bl3 || string2 == null) {
            string2 = LocaleMapper.getJavaCharacterSet(1, string.toUpperCase());
            try {
                this.outWriter = new OutputStreamWriter(this.outStream, string2);
            }
            catch (Exception exception) {
                bl3 = true;
            }
        }
        if (bl3 || string2 == null) {
            string2 = string;
            try {
                this.outWriter = new OutputStreamWriter(this.outStream, string2);
            }
            catch (Exception exception) {
                if (this.err == null) {
                    this.localErr = true;
                    this.err = new XMLError();
                }
                throw new IOException(this.err.getMessage1(231, string));
            }
        }
        this.wrtstate = 7;
        this.charBuffer = ArrayPool.allocCharArrDefault();
        ArrayPool.freeByteArrDefault(this.byteBuffer);
        this.byteBuffer = null;
    }

    public void flush() throws IOException {
        if (this.wrtstate == 7) {
            this.outWriter.write(this.charBuffer, 0, this.charIndex);
            this.charIndex = 0;
        } else {
            this.outStream.write(this.byteBuffer, 0, this.byteIndex);
            this.byteIndex = 0;
        }
    }

    public void flushDebugStream() throws IOException {
        this.flush();
    }

    public void close() throws IOException {
        this.close(0);
    }

    public void close(int n) throws IOException {
        if (this.highSurrogate != '\u0000') {
            this.highSurrogate = '\u0000';
            this.write(65533);
        }
        this.finalFlush();
        if (n == 1) {
            if (this.outWriter != null) {
                this.outWriter.close();
            }
            if (this.outStream != null) {
                this.outStream.close();
            }
        }
        if (this.charBuffer != null) {
            ArrayPool.freeCharArrDefault(this.charBuffer);
        }
        if (this.byteBuffer != null) {
            ArrayPool.freeByteArrDefault(this.byteBuffer);
        }
        try {
            if (this.localErr) {
                this.err.flushErrors();
            }
        }
        catch (XMLParseException xMLParseException) {
            throw new IOException(xMLParseException.getMessage());
        }
    }

    public void pop(int n) throws IOException {
        if (this.wrtstate == 7) {
            if (this.charIndex < n) {
                throw new IOException("Internal error while writing file");
            }
            this.charIndex -= n;
        } else {
            if (this.byteIndex < n) {
                throw new IOException("Internal error while writing file");
            }
            this.byteIndex -= n;
        }
    }

    public void write(int n) throws IOException {
        try {
            if (this.wrtstate == 1 || this.wrtstate == 6 || this.wrtstate == 5) {
                if (n >= 55296 && n <= 56319) {
                    if (this.highSurrogate != '\u0000') {
                        this.highSurrogate = '\u0000';
                        this.write(65533);
                    }
                    this.highSurrogate = (char)n;
                    return;
                }
                if (n >= 56320 && n <= 57343) {
                    if (this.highSurrogate == '\u0000') {
                        this.write(65533);
                        return;
                    }
                    int n2 = Character.toCodePoint(this.highSurrogate, (char)n);
                    this.highSurrogate = '\u0000';
                    this.write(n2);
                    return;
                }
                if (this.highSurrogate != '\u0000') {
                    this.highSurrogate = '\u0000';
                    this.write(65533);
                }
            }
            switch (this.wrtstate) {
                case 1: {
                    if (n < 128) {
                        this.byteBuffer[this.byteIndex] = (byte)n;
                        ++this.byteIndex;
                        break;
                    }
                    this.writeUTF8Bytes(n);
                    break;
                }
                case 2: {
                    this.byteBuffer[this.byteIndex] = (byte)n;
                    ++this.byteIndex;
                    break;
                }
                case 3: {
                    int n3 = n >> 8;
                    int n4 = n & 0xFF;
                    this.byteBuffer[this.byteIndex] = (byte)n3;
                    this.byteBuffer[this.byteIndex + 1] = (byte)n4;
                    this.byteIndex += 2;
                    break;
                }
                case 4: {
                    int n5 = n >> 8;
                    int n6 = n & 0xFF;
                    this.byteBuffer[this.byteIndex] = (byte)n6;
                    this.byteBuffer[this.byteIndex + 1] = (byte)n5;
                    this.byteIndex += 2;
                    break;
                }
                case 5: {
                    int n7 = n >> 24;
                    int n8 = n >> 16 & 0xFF;
                    int n9 = n >> 8 & 0xFF;
                    int n10 = n & 0xFF;
                    this.byteBuffer[this.byteIndex] = (byte)n10;
                    this.byteBuffer[this.byteIndex + 1] = (byte)n9;
                    this.byteBuffer[this.byteIndex + 2] = (byte)n8;
                    this.byteBuffer[this.byteIndex + 3] = (byte)n7;
                    this.byteIndex += 4;
                    break;
                }
                case 6: {
                    int n11 = n >> 24;
                    int n12 = n >> 16 & 0xFF;
                    int n13 = n >> 8 & 0xFF;
                    int n14 = n & 0xFF;
                    this.byteBuffer[this.byteIndex] = (byte)n11;
                    this.byteBuffer[this.byteIndex + 1] = (byte)n12;
                    this.byteBuffer[this.byteIndex + 2] = (byte)n13;
                    this.byteBuffer[this.byteIndex + 3] = (byte)n14;
                    this.byteIndex += 4;
                    break;
                }
                case 7: {
                    this.charBuffer[this.charIndex] = (char)n;
                    ++this.charIndex;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.flush();
            this.write(n);
        }
    }

    void writeUTF8Bytes(int n) throws IOException {
        if (n < 2048) {
            this.byteBuffer[this.byteIndex] = (byte)(0xC0 | n >> 6);
            this.byteBuffer[this.byteIndex + 1] = (byte)(0x80 | n & 0x3F);
            this.byteIndex += 2;
        } else if (n < 65536) {
            this.byteBuffer[this.byteIndex] = (byte)(0xE0 | n >> 12);
            this.byteBuffer[this.byteIndex + 1] = (byte)(0x80 | n >> 6 & 0x3F);
            this.byteBuffer[this.byteIndex + 2] = (byte)(0x80 | n & 0x3F);
            this.byteIndex += 3;
        } else {
            this.byteBuffer[this.byteIndex] = (byte)(0xF0 | n >> 18);
            this.byteBuffer[this.byteIndex + 1] = (byte)(0x80 | n >> 12 & 0x3F);
            this.byteBuffer[this.byteIndex + 2] = (byte)(0x80 | n >> 6 & 0x3F);
            this.byteBuffer[this.byteIndex + 3] = (byte)(0x80 | n & 0x3F);
            this.byteIndex += 4;
        }
    }

    public void writeChars(String string) throws IOException {
        if (string == null) {
            return;
        }
        int n = string.length();
        if (n == 0) {
            return;
        }
        if (n == 1) {
            char c = string.charAt(0);
            if (c == '\n') {
                this.writeNewLineChars();
            } else {
                this.write(c);
            }
            return;
        }
        int n2 = 0;
        char c = string.charAt(n2);
        char c2 = string.charAt(n2 + 1);
        while (true) {
            if (c2 == '\n') {
                if (c != '\r') {
                    this.write(c);
                }
                this.writeNewLineChars();
                if ((n2 += 2) < n) {
                    if (n2 == n - 1) {
                        c = string.charAt(n2);
                        if (c == '\n') {
                            this.writeNewLineChars();
                        } else {
                            this.write(c);
                        }
                        return;
                    }
                    c = string.charAt(n2);
                    c2 = string.charAt(n2 + 1);
                    continue;
                }
                return;
            }
            this.write(c);
            c = c2;
            if (++n2 + 1 >= n) break;
            c2 = string.charAt(n2 + 1);
        }
        this.write(c);
    }

    void writeNewLineChars() throws IOException {
        int n = this.nlChars.length;
        for (int i = 0; i < n; ++i) {
            this.write(this.nlChars[i]);
        }
    }

    public void writeQuotedString(String string) throws IOException {
        char c = '\"';
        if (string.indexOf(34) >= 0 && string.indexOf(39) < 0) {
            c = '\'';
        }
        this.write(c);
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (c2 == c) {
                if (c == '\"') {
                    this.writeChars("&quot;");
                    continue;
                }
                this.writeChars("&apos;");
                continue;
            }
            this.write(c2);
        }
        this.write(c);
    }

    public void writeNewLine() throws IOException {
        if (this.outstyle == 1 && !this.mixed) {
            this.writeNewLineChars();
        }
    }

    public void addIndent(int n) {
        this.indent += n;
    }

    public void writeIndent() throws IOException {
        if (this.outstyle == 1 && !this.mixed) {
            for (int i = 0; i < this.indent; ++i) {
                this.writeChars("   ");
            }
        }
    }

    public void setOutputStyle(int n) {
        this.outstyle = n;
    }

    public int getOutputStyle() {
        return this.outstyle;
    }

    public void finalFlush() throws IOException {
        this.flush();
        if (this.outWriter != null) {
            this.outWriter.flush();
        }
        if (this.outStream != null) {
            this.outStream.flush();
        }
    }

    public boolean isMixed() {
        return this.mixed;
    }

    public void setMixed(boolean bl) {
        this.mixed = bl;
    }

    static {
        String string = "\n";
        try {
            string = XMLUtil.getProperty("line.separator");
        }
        catch (Exception exception) {
            string = "\n";
        }
        nlStr = string;
    }
}

