/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.dbaccess;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Vector;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;
import oracle.sql.BLOB;
import oracle.sql.CLOB;

public class DBAccess {
    protected int nameSize = 16;

    public int getNameSize() {
        return this.nameSize;
    }

    public boolean isXMLTable(Connection connection, String string) throws Exception {
        ResultSet resultSet = null;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        string = string.toUpperCase();
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT COLUMN_NAME,DATA_TYPE FROM USER_TAB_COLUMNS WHERE TABLE_NAME= ?");
        preparedStatement.setString(1, string);
        resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            string2 = resultSet.getString(1);
            string3 = resultSet.getString(2);
            if (resultSet.next()) {
                string4 = resultSet.getString(1);
                string5 = resultSet.getString(2);
            }
            resultSet.close();
            preparedStatement.close();
            if (!string2.equals("FILENAME")) {
                return false;
            }
            if (!string3.equals("CHAR")) {
                return false;
            }
            if (!string4.equals("FILEDATA")) {
                return false;
            }
            return string5.equals("CLOB");
        }
        resultSet.close();
        preparedStatement.close();
        return false;
    }

    public String[] getXMLTableNames(Connection connection, String string) throws Exception {
        ResultSet resultSet = null;
        Vector<String> vector = new Vector<String>(10);
        string = string.toUpperCase();
        Statement statement = connection.createStatement();
        resultSet = statement.executeQuery("SELECT TABLE_NAME FROM USER_TABLES");
        while (resultSet.next()) {
            String string2 = resultSet.getString(1);
            if (string2.indexOf(string) != 0 || !this.isXMLTable(connection, string2)) continue;
            vector.addElement(string2);
        }
        String[] stringArray = new String[vector.size()];
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        resultSet.close();
        statement.close();
        return stringArray;
    }

    public boolean insertXMLData(Connection connection, String string, String string2, String string3) throws SQLException, IOException {
        OraclePreparedStatement oraclePreparedStatement = null;
        CLOB cLOB = null;
        string = string.toUpperCase();
        string2 = string2.toUpperCase();
        if ((string2 = string2.trim()).length() > this.nameSize) {
            string2 = string2.substring(0, this.nameSize);
        }
        try {
            oraclePreparedStatement = (OraclePreparedStatement)connection.prepareStatement("INSERT INTO " + this.validateTableName(string) + " VALUES (?,empty_clob())");
            oraclePreparedStatement.setString(1, string2);
            oraclePreparedStatement.execute();
            oraclePreparedStatement.close();
            connection.setAutoCommit(false);
            oraclePreparedStatement = (OraclePreparedStatement)connection.prepareStatement("SELECT FILEDATA FROM " + this.validateTableName(string) + " WHERE FILENAME=? FOR UPDATE");
            oraclePreparedStatement.setString(1, string2);
            ResultSet resultSet = oraclePreparedStatement.executeQuery();
            if (resultSet.next()) {
                cLOB = ((OracleResultSet)resultSet).getCLOB(1);
            }
            Writer writer = cLOB.getCharacterOutputStream();
            writer.write(string3);
            writer.flush();
            writer.close();
            resultSet.close();
            oraclePreparedStatement.close();
            connection.commit();
            return true;
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            if (n == 1) {
                return false;
            }
            throw sQLException;
        }
    }

    public boolean insertBLOBData(Connection connection, String string, String string2, byte[] byArray) throws SQLException, IOException {
        OraclePreparedStatement oraclePreparedStatement = null;
        BLOB bLOB = null;
        string = string.toUpperCase();
        string2 = string2.toUpperCase();
        if ((string2 = string2.trim()).length() > this.nameSize) {
            string2 = string2.substring(0, this.nameSize);
        }
        try {
            oraclePreparedStatement = (OraclePreparedStatement)connection.prepareStatement("INSERT INTO " + this.validateTableName(string) + " VALUES (?,empty_blob())");
            oraclePreparedStatement.setString(1, string2);
            oraclePreparedStatement.execute();
            oraclePreparedStatement.close();
            connection.setAutoCommit(false);
            oraclePreparedStatement = (OraclePreparedStatement)connection.prepareStatement("SELECT FILEDATA FROM " + this.validateTableName(string) + " WHERE FILENAME=? FOR UPDATE");
            oraclePreparedStatement.setString(1, string2);
            ResultSet resultSet = oraclePreparedStatement.executeQuery();
            if (resultSet.next()) {
                bLOB = ((OracleResultSet)resultSet).getBLOB(1);
            }
            OutputStream outputStream = bLOB.getBinaryOutputStream();
            outputStream.write(byArray, 0, byArray.length);
            outputStream.flush();
            outputStream.close();
            resultSet.close();
            oraclePreparedStatement.close();
            connection.commit();
            return true;
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            if (n == 1) {
                return false;
            }
            throw sQLException;
        }
    }

    public boolean replaceXMLData(Connection connection, String string, String string2, String string3) throws Exception {
        this.deleteXMLName(connection, string, string2);
        return this.insertXMLData(connection, string, string2, string3);
    }

    public boolean xmlTableExists(Connection connection, String string) throws Exception {
        string = string.toUpperCase();
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("select 'hello' from " + this.validateTableName(string));
            resultSet.close();
            statement.close();
            return true;
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            if (n == 942) {
                return false;
            }
            throw sQLException;
        }
    }

    public boolean dropXMLTable(Connection connection, String string) throws Exception {
        Statement statement = connection.createStatement();
        string = string.toUpperCase();
        try {
            statement.execute("DROP TABLE " + this.validateTableName(string));
            return true;
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            if (n == 942) {
                return true;
            }
            throw sQLException;
        }
    }

    public boolean dropBLOBTable(Connection connection, String string) throws Exception {
        Statement statement = connection.createStatement();
        string = string.toUpperCase();
        try {
            statement.execute("DROP TABLE " + this.validateTableName(string));
            return true;
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            if (n == 942) {
                return true;
            }
            throw sQLException;
        }
    }

    public boolean createXMLTable(Connection connection, String string) throws Exception {
        string = string.toUpperCase();
        try {
            Statement statement = connection.createStatement();
            statement.execute("CREATE TABLE " + this.validateTableName(string) + " (FILENAME CHAR( " + this.nameSize + " ) UNIQUE, FILEDATA CLOB) LOB(FILEDATA) STORE AS (DISABLE STORAGE IN ROW)");
            statement.close();
            return true;
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            if (n == 955) {
                return true;
            }
            throw sQLException;
        }
    }

    public boolean createBLOBTable(Connection connection, String string) throws Exception {
        string = string.toUpperCase();
        try {
            Statement statement = connection.createStatement();
            statement.execute("CREATE TABLE " + this.validateTableName(string) + " (FILENAME CHAR( " + this.nameSize + " ) UNIQUE, FILEDATA BLOB) LOB(FILEDATA) STORE AS (DISABLE STORAGE IN ROW)");
            statement.close();
            return true;
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            if (n == 955) {
                return true;
            }
            throw sQLException;
        }
    }

    private void printXMLTable(Connection connection, String string) throws Exception {
        ResultSet resultSet = null;
        string = string.toUpperCase();
        Statement statement = connection.createStatement();
        resultSet = statement.executeQuery("SELECT * FROM " + this.validateTableName(string));
        while (resultSet.next()) {
            String string2 = resultSet.getString(1);
            CLOB cLOB = ((OracleResultSet)resultSet).getCLOB(2);
            int n = cLOB.length() < 30000L ? (int)cLOB.length() : 30000;
            String string3 = cLOB.getSubString(1L, n);
        }
        resultSet.close();
        statement.close();
    }

    public String[] getXMLNames(Connection connection, String string) throws Exception {
        ResultSet resultSet = null;
        Vector<String> vector = new Vector<String>(10);
        string = string.toUpperCase();
        Statement statement = connection.createStatement();
        resultSet = statement.executeQuery("SELECT FILENAME FROM " + this.validateTableName(string));
        while (resultSet.next()) {
            String string2 = resultSet.getString(1);
            vector.capacity();
            vector.addElement(string2);
        }
        String[] stringArray = new String[vector.size()];
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        resultSet.close();
        statement.close();
        return stringArray;
    }

    public String getXMLData(Connection connection, String string, String string2) throws SQLException {
        ResultSet resultSet = null;
        StringBuffer stringBuffer = new StringBuffer(1000);
        string = string.toUpperCase();
        string2 = string2.toUpperCase();
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT FILEDATA FROM " + this.validateTableName(string) + " WHERE FILENAME= ?");
        preparedStatement.setString(1, string2);
        resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            CLOB cLOB = ((OracleResultSet)resultSet).getCLOB(1);
            long l = cLOB.length();
            int n = 30000;
            int n2 = 0;
            while ((long)n2 < l) {
                int n3 = l - (long)n2 - (long)n >= 0L ? n : (int)(l - (long)n2);
                stringBuffer.append(cLOB.getSubString((long)(n2 + 1), n3));
                n2 += n;
            }
            preparedStatement.close();
            resultSet.close();
            return stringBuffer.toString();
        }
        preparedStatement.close();
        resultSet.close();
        return null;
    }

    public byte[] getBLOBData(Connection connection, String string, String string2) throws SQLException {
        ResultSet resultSet = null;
        StringBuffer stringBuffer = new StringBuffer(1000);
        string = string.toUpperCase();
        string2 = string2.toUpperCase();
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT FILEDATA FROM " + this.validateTableName(string) + " WHERE FILENAME=?");
        preparedStatement.setString(1, string2);
        resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            BLOB bLOB = ((OracleResultSet)resultSet).getBLOB(1);
            long l = bLOB.length();
            byte[] byArray = bLOB.getBytes(1L, (int)l);
            preparedStatement.close();
            resultSet.close();
            return byArray;
        }
        preparedStatement.close();
        resultSet.close();
        return null;
    }

    public boolean deleteBLOBName(Connection connection, String string, String string2) throws Exception {
        string = string.toUpperCase();
        string2 = string2.toUpperCase();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("DELETE FROM " + this.validateTableName(string) + " WHERE FILENAME= ? ");
            preparedStatement.setString(1, string2);
            preparedStatement.execute();
            preparedStatement.close();
            return true;
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            return false;
        }
    }

    public boolean deleteXMLName(Connection connection, String string, String string2) throws Exception {
        string = string.toUpperCase();
        string2 = string2.toUpperCase();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("DELETE FROM " + this.validateTableName(string) + " WHERE FILENAME= ? ");
            preparedStatement.setString(1, string2);
            preparedStatement.execute();
            preparedStatement.close();
            return true;
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            return false;
        }
    }

    private static void fillClob(Connection connection, CLOB cLOB, long l) throws Exception {
        Writer writer = cLOB.getCharacterOutputStream();
        int n = 0;
        int n2 = 10;
        while ((long)n < l) {
            writer.write(n + "hello world", 0, n2);
            if (l - (long)(n += n2) >= (long)n2) continue;
            n2 = (int)l - n;
        }
        writer.close();
    }

    static void dumpClob(Connection connection, CLOB cLOB) throws Exception {
        Reader reader = cLOB.getCharacterStream();
        char[] cArray = new char[1000];
        int n = 0;
        while ((n = reader.read(cArray)) != -1) {
            for (int i = 0; i < n; ++i) {
                System.out.print(cArray[i]);
            }
        }
        reader.close();
    }

    private String validateTableName(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (!(cArray[i] >= '0' && cArray[i] <= '9' || cArray[i] >= 'A' && cArray[i] <= 'Z' || cArray[i] >= 'a' && cArray[i] <= 'z' || cArray[i] == '_' || cArray[i] == '$') && cArray[i] != '#') continue;
            stringBuffer.append(cArray[i]);
        }
        return stringBuffer.toString();
    }
}

