/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.web.servlets;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.web.JRInteractiveException;
import net.sf.jasperreports.web.WebReportContext;
import net.sf.jasperreports.web.servlets.AbstractServlet;
import net.sf.jasperreports.web.servlets.Controller;
import net.sf.jasperreports.web.servlets.JasperPrintAccessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReportContextCreatorServlet
extends AbstractServlet {
    private static final long serialVersionUID = 10200L;
    private static final Log log = LogFactory.getLog(ReportContextCreatorServlet.class);

    @Override
    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.setContentType("application/json; charset=UTF-8");
        this.setNoExpire(response);
        String reportUri = request.getParameter("jr_report_uri");
        PrintWriter out = response.getWriter();
        if (reportUri != null && request.getHeader("accept").indexOf("application/json") >= 0) {
            WebReportContext webReportContext = WebReportContext.getInstance(request);
            JasperPrintAccessor jasperPrintAccessor = (JasperPrintAccessor)webReportContext.getParameterValue("net.sf.jasperreports.web.jasper_print.accessor");
            if (jasperPrintAccessor == null) {
                String appDomain;
                webReportContext.setParameterValue("jr_report_uri", reportUri);
                String async = request.getParameter("jr_async");
                if (async != null) {
                    webReportContext.setParameterValue("jr_async", Boolean.valueOf(async));
                }
                if ((appDomain = request.getParameter("jr_app_domain")) != null) {
                    if (appDomain.endsWith("/")) {
                        appDomain = appDomain.substring(0, appDomain.length() - 1);
                    }
                    webReportContext.setParameterValue("jr_app_domain", appDomain);
                }
                Controller controller = new Controller(this.getJasperReportsContext());
                this.initWebContext(request, webReportContext);
                try {
                    controller.runReport(webReportContext, null);
                }
                catch (JRInteractiveException e) {
                    log.error("Error on report execution", e);
                    throw new JRRuntimeException(e);
                }
                catch (JRException e) {
                    log.error("Error on report execution", e);
                    response.setStatus(404);
                    out.println("{\"msg\": \"JasperReports encountered an error on context creation!\",");
                    out.println("\"devmsg\": \"" + JRStringUtil.escapeJavaStringLiteral(e.getMessage()) + "\"}");
                    return;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            out.println("{\"contextid\": " + webReportContext.getId() + "}");
        } else {
            response.setStatus(400);
            out.println("{\"msg\": \"Wrong parameters!\"}");
        }
    }

    protected void initWebContext(HttpServletRequest request, WebReportContext webReportContext) {
    }
}

