/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.web.servlets;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.ReportContext;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.web.JRInteractiveException;
import net.sf.jasperreports.web.WebReportContext;
import net.sf.jasperreports.web.actions.AbstractAction;
import net.sf.jasperreports.web.actions.Action;
import net.sf.jasperreports.web.actions.MultiAction;
import net.sf.jasperreports.web.servlets.AbstractServlet;
import net.sf.jasperreports.web.servlets.Controller;
import net.sf.jasperreports.web.servlets.JasperPrintAccessor;
import net.sf.jasperreports.web.util.JacksonUtil;
import net.sf.jasperreports.web.util.WebUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReportActionServlet
extends AbstractServlet {
    private static final long serialVersionUID = 10200L;
    private static final Log log = LogFactory.getLog(ReportActionServlet.class);
    private static final String REQUEST_PARAMETER_ACTION = "jr_action";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.setContentType("application/json; charset=UTF-8");
        this.setNoExpire(response);
        PrintWriter out = response.getWriter();
        String contextId = request.getParameter("jr_ctxid");
        if (contextId != null && request.getHeader("accept").indexOf("application/json") >= 0 && request.getParameterMap().containsKey(REQUEST_PARAMETER_ACTION)) {
            WebReportContext webReportContext = WebReportContext.getInstance(request, false);
            if (webReportContext != null) {
                try {
                    this.runAction(request, webReportContext);
                    JsonNode actionResult = (JsonNode)webReportContext.getParameterValue("net.sf.jasperreports.web.actions.result.json");
                    if (actionResult != null) {
                        out.println("{\"contextid\": " + webReportContext.getId() + ", \"actionResult\": " + actionResult + "}");
                        webReportContext.setParameterValue("net.sf.jasperreports.web.actions.result.json", null);
                        return;
                    }
                    out.println("{\"contextid\": " + webReportContext.getId() + "}");
                    return;
                }
                catch (Exception e) {
                    log.error("Error on page status update", e);
                    response.setStatus(404);
                    out.println("{\"msg\": \"JasperReports encountered an error on context creation!\",");
                    out.println("\"devmsg\": \"" + JRStringUtil.escapeJavaStringLiteral(e.getMessage()) + "\"}");
                }
                return;
            }
            response.setStatus(404);
            out.println("{\"msg\": \"Resource with id '" + contextId + "' not found!\"}");
            return;
        }
        response.setStatus(400);
        out.println("{\"msg\": \"Wrong parameters!\"}");
    }

    public void runAction(HttpServletRequest request, WebReportContext webReportContext) throws JRException, JRInteractiveException {
        JasperPrintAccessor jasperPrintAccessor = (JasperPrintAccessor)webReportContext.getParameterValue("net.sf.jasperreports.web.jasper_print.accessor");
        Action action = this.getAction(webReportContext, WebUtil.decodeUrl(request.getParameter(REQUEST_PARAMETER_ACTION)));
        Controller controller = new Controller(this.getJasperReportsContext());
        controller.runReport(webReportContext, action);
    }

    private Action getAction(ReportContext webReportContext, String jsonData) {
        Action result = null;
        List<AbstractAction> actions = JacksonUtil.getInstance(this.getJasperReportsContext()).loadAsList(jsonData, AbstractAction.class);
        if (actions != null) {
            if (actions.size() == 1) {
                result = actions.get(0);
            } else if (actions.size() > 1) {
                result = new MultiAction(actions);
            }
            ((AbstractAction)result).init(this.getJasperReportsContext(), webReportContext);
        }
        return result;
    }
}

