/*
 * Decompiled with CFR 0.152.
 */
package dguv.unidav.common.utils;

import dguv.unidav.common.exception.TechnicalException;
import java.net.URL;
import java.util.Properties;
import java.util.Vector;
import oracle.soap.transport.http.OracleSOAPHTTPConnection;
import org.apache.soap.Fault;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.rpc.Call;
import org.apache.soap.rpc.Parameter;
import org.apache.soap.rpc.Response;
import org.apache.soap.transport.SOAPTransport;

public class WebServiceInvoker {
    private final int SERVICE_TIMEOUT = 60000;
    private String webServiceURL = null;
    private String webServiceName = null;
    private String proxyHost = null;
    private int proxyPort = 8008;
    private String proxyUser = null;
    private String proxyPass = null;
    private OracleSOAPHTTPConnection httpConnection = null;
    private SOAPMappingRegistry soapMappingRegistry = null;

    public WebServiceInvoker(String aWebServiceName, String aWebServiceURL) {
        this.webServiceName = aWebServiceName;
        this.webServiceURL = aWebServiceURL;
        this.httpConnection = new OracleSOAPHTTPConnection();
        this.soapMappingRegistry = new SOAPMappingRegistry();
    }

    public void useProxy(String aProxyHost, int aProxyPort, String aProxyUser, String aProxyPass) {
        this.proxyHost = aProxyHost;
        this.proxyPort = aProxyPort;
        this.proxyUser = aProxyUser;
        this.proxyPass = aProxyPass;
    }

    public Object invoke(String aMethodName) throws TechnicalException {
        return this.invoke(aMethodName, new String[0], new Object[0]);
    }

    public Object invoke(String aMethodName, String aParamName, Object aParamValue) throws TechnicalException {
        String[] lParamNames = new String[]{aParamName};
        Object[] lParamValues = new Object[]{aParamValue};
        return this.invoke(aMethodName, lParamNames, lParamValues);
    }

    public Object invoke(String aMethodName, String[] aParamNames, Object[] aParamValues) throws TechnicalException {
        int lTryCount = 0;
        Throwable lEx = null;
        while (lTryCount < 5) {
            try {
                return this.invokeImpl(aMethodName, aParamNames, aParamValues);
            }
            catch (Throwable t) {
                lEx = t;
                if (lEx instanceof TechnicalException) {
                    throw (TechnicalException)t;
                }
                ++lTryCount;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (lEx != null) {
            throw new TechnicalException(lEx.getMessage(), lEx);
        }
        throw new TechnicalException("WebSevriceInvoker.invoke(): no Exception; method=[" + aMethodName + "]", null);
    }

    private Object invokeImpl(String aMethodName, String[] aParamNames, Object[] aParamValues) throws Exception {
        if (aParamNames.length != aParamValues.length) {
            throw new TechnicalException("WebServiceInvoker.invoke() Fehler: Anzahl Parameternamen [" + aParamNames.length + "] entspricht nicht Anzahl Parameterwerte [" + aParamValues.length + "]");
        }
        this.initialize();
        Object lRval = null;
        URL lEndpointURL = new URL(this.webServiceURL);
        Call lCall = new Call();
        lCall.setSOAPTransport((SOAPTransport)this.httpConnection);
        lCall.setTargetObjectURI(this.webServiceName);
        lCall.setMethodName(aMethodName);
        lCall.setEncodingStyleURI("http://schemas.xmlsoap.org/soap/encoding/");
        lCall.setTimeout(60000);
        Vector<Parameter> lParams = new Vector<Parameter>();
        for (int i = 0; i < aParamNames.length; ++i) {
            lParams.addElement(new Parameter(aParamNames[i], aParamValues[i].getClass(), aParamValues[i], null));
        }
        lCall.setParams(lParams);
        lCall.setSOAPMappingRegistry(this.soapMappingRegistry);
        Response lResponse = lCall.invoke(lEndpointURL, "");
        if (lResponse.generatedFault()) {
            Fault lFault = lResponse.getFault();
            throw new TechnicalException(lFault.getFaultCode() + " - " + lFault.getFaultString());
        }
        Parameter lResult = lResponse.getReturnValue();
        lRval = lResult.getValue();
        return lRval;
    }

    private void initialize() {
        Properties lProps = this.getTransportProperties();
        if (this.proxyHost != null && this.proxyHost.length() > 0) {
            lProps.setProperty("http.proxyHost", this.proxyHost);
            lProps.setProperty("http.proxyPort", new Integer(this.proxyPort).toString());
            if (this.proxyUser != null && this.proxyUser.length() > 0) {
                lProps.setProperty("http.proxyUsername", this.proxyUser);
                lProps.setProperty("http.proxyPassword", this.proxyPass);
            }
        } else {
            lProps.setProperty("http.proxyHost", "");
        }
        this.setTransportProperties(lProps);
    }

    private void setTransportProperties(Properties aProps) {
        this.httpConnection.setProperties(aProps);
    }

    private Properties getTransportProperties() {
        return this.httpConnection.getProperties();
    }

    public static void main(String[] args) {
        WebServiceInvoker lInvoker = new WebServiceInvoker("TestBeanServicePort", "http://10.40.17.118:7101/EJBRPCTest-Model-webapp/TestBeanServicePort");
        try {
            String lResponse = (String)lInvoker.invoke("doTest", "aTest", "Test");
            if (lResponse != null) {
                System.out.println(lResponse);
            }
        }
        catch (TechnicalException e) {
            e.printStackTrace();
        }
    }
}

